package ttsolver.model;

import ifs.util.FastVector;

import java.util.Vector;

/**
 * Cross-listed lectures of a lecture.
 * <br><br>
 * This is used only when the model is loaded directly from the database. One class can have several 
 * identifications there.
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public class CrossListedLecture {
    private String iSubject;
    private String iCourseNbr;
    private String iIType;
    private int iSection;
    private String iName;
    
    private Lecture iLecture = null;;
    private Vector iStudents = new FastVector(1);

    /** Constructor
     * @param subject subject
     * @param courseNbr course number
     * @param iType instructional type
     * @param section section
     */
    public CrossListedLecture(String subject, String courseNbr, String iType, int section) {
        this(subject,courseNbr,iType,section,subject+" "+courseNbr+" "+iType+" "+section);
    }
    
    /** Constructor
     * @param subject subject
     * @param courseNbr course number
     * @param iType instructional type
     * @param section section
     * @param name (string representation of this class)
     */
    public CrossListedLecture(String subject, String courseNbr, String iType, int section, String name) {
        iSubject = subject;
        iCourseNbr = courseNbr;
        iIType = iType;
        iSection = section;
        iName = name;
    }
    
    /** Subject */
    public String getSubject() { return iSubject; }
    /** Course number */
    public String getCourseNbr() { return iCourseNbr; }
    /** Instructional type */
    public String getIType() { return iIType; }
    /** Section */
    public int getSection() { return iSection; }
    /** Name */
    public String getName() { return iName; }
    
    /** Parent lecture */
    public Lecture getLecture() { return iLecture; }
    /** Parent lecture */
    public void setLecture(Lecture lecture) { iLecture = lecture; }
    
    /** List of enrolled students */
    public Vector students() { return iStudents; }
    /** Add student enrollment */
    public void addStudent(String student) {
        iStudents.addElement(student);
        iLecture.addSameLectureStudent(student);
    }
    /** Has given student enrollment */
    public boolean hasStudent(String student) { return iStudents.contains(student);}

    public boolean equals(Object o) {
        if (o==null || !(o instanceof CrossListedLecture)) return false;
        CrossListedLecture sl = (CrossListedLecture)o;
        return (getSubject().equals(sl.getSubject()) &&
                getCourseNbr().equals(sl.getCourseNbr()) &&
                getIType().equals(sl.getIType()) &&
                getSection() == sl.getSection());
    }
}
