package ttsolver;

import ifs.solution.Solution;
import java.io.*;

/**
 * Abstract timetable saver class.
 * 
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public abstract class TimetableSaver {
    private Solution iSolution = null;
    /** Constructor
     * @param solution solution to be saved
     */
    public TimetableSaver(Solution solution) {
        iSolution = solution;
    }
    /** Solution to be saved */
    protected Solution getSolution() { return iSolution; }
    /** Model of the solution */
    protected TimetableModel getModel() { return (TimetableModel)iSolution.getModel(); }
    /** Save the solution
     * @param out some error/warning/info messages could be printed here
     */
    public abstract void save(PrintWriter out) throws Exception;
}
