package ttsolver;

import java.io.*;

/**
 * Abstract timetable loader class.
 * 
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public abstract class TimetableLoader {
    private TimetableModel iModel = null;
    /** Constructor 
     * @param model an empty instance of timetable model 
     */
    public TimetableLoader(TimetableModel model) {
        iModel = model;
    }
    protected TimetableModel getModel() { return iModel; }
    /** Load the model.
     * @param out some error/warning/info messages could be printed here
     */
    public abstract void load(PrintWriter out) throws Exception;
}
