package ifs.util;

import java.util.*;

/** Vector extension with faster enumeration.
 * In {@link FastVector#elements()}, no unnecessary check is made.
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public class FastVector extends Vector {
    
    public FastVector() {
        super();
    }
    public FastVector(int initialCapacity) {
        super(initialCapacity);
    }
    public FastVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }
    public FastVector(Collection c) {
        super(c);
    }
 
    public Enumeration elements() {
	return new Enumeration() {
	    int count = 0;
	    public boolean hasMoreElements() { return count < elementCount; }
	    public Object nextElement() { return elementData[count++]; }
	};
    }
    
    public String toString() {
        return size()+"/"+super.toString();
    }
}
