package ifs.solver;

import ifs.model.*;

/**
 * IFS Solver Listener.
 *
 * @see Solver
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
**/
public interface SolverListener {
    
    /** A variable was selected 
     * @param iteration current iteration
     * @param variable selected variable
     */
    public boolean variableSelected(long iteration, Variable variable);
    
    /** A value was selected 
     * @param iteration current iteration
     * @param variable selected variable
     * @param value selected variable
     */
    public boolean valueSelected(long iteration, Variable variable, Value value);
}
