package ifs.solution;

/**
 * IFS solution listener.
 *
 * @see Solution
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface SolutionListener {
    /** Called by the solution when it is updated, see {@link Solution#update(double)}. 
     * @param solution source solution
     */
    public void solutionUpdated(Solution solution);
    
    /** Called by the solution when it is asked to produce info table, see {@link Solution#getInfo()}.
     * A listener can also add some its info into this table.
     * @param solution source solution
     * @param info produced info table
     */
    public void getInfo(Solution solution, java.util.Dictionary info);
    
    /** Called by the solution when method {@link Solution#clearBest()} is called.
     * @param solution source solution
     */
    public void bestCleared(Solution solution);

    /** Called by the solution when method {@link Solution#saveBest()} is called.
     * @param solution source solution
     */
    public void bestSaved(Solution solution);

    /** Called by the solution when method {@link Solution#restoreBest()} is called.
     * @param solution source solution
     */
    public void bestRestored(Solution solution);
}
