package ifs.solution;

import ifs.util.DataProperties;

/**
 * General implementation of solution comparator.
 * <br><br>
 * The solution is better than the best ever found solution when it has more variables assigned. In the case, when both
 * solutions have the same number of assigned variables, the better solution is the one with smaller total value, i.e.,
 * the sum of {@link ifs.model.Value#toInt()} over all assigned variables.
 *
 * @see Solution
 * @see ifs.solver.Solver
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public class GeneralSolutionComparator implements SolutionComparator {
    
    public GeneralSolutionComparator() {}
    /** No parameters are used so far. */
    public GeneralSolutionComparator(DataProperties properties) {
    }
    
    public boolean isBetterThanBestSolution(Solution currentSolution) {
        if (currentSolution.getBestInfo()==null) return true;
        int unassigned = currentSolution.getModel().unassignedVariables().size();
        if (currentSolution.getModel().getBestUnassignedVariables()!=unassigned)
            return currentSolution.getModel().getBestUnassignedVariables()>unassigned;
        return currentSolution.getModel().getTotalValue()<currentSolution.getBestValue();
    }
    
}
