package ifs.model;

/**
 * IFS variable listener.
 *
 * @see Variable
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface VariableListener {
    /** Called by the variable when a value is assigned to it
     * @param iteration current iteration
     * @param value assigned to the variable
     */
    public void variableAssigned(long iteration, Value value);

    /** Called by the variable when a value is unassigned from it
     * @param iteration current iteration
     * @param value unassigned from the variable
     */
    public void variableUnassigned(long iteration, Value value);

    /** Called by the variable when a value is permanently removed from its domain
     * @param iteration current iteration
     * @param value removed from the variable's domain
     */
    public void valueRemoved(long iteration, Value value);
}
