package ifs.model;

/**
 * IFS model listener.
 *
 * @see Model
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public interface ModelListener {
    /** Variable is added to the model
     * @param variable added variable
     */
    public void variableAdded(Variable variable);
    
    /** Variable is removed from the model
     * @param variable removed variable
     */
    public void variableRemoved(Variable variable);
    
    /** Constraint is added to the model
     * @param constraint added constraint
     */
    public void constraintAdded(Constraint constraint);
    
    /** Constraint is removed from the model
     * @param constraint removed constraint
     */
    public void constraintRemoved(Constraint constraint);
    
    /** Called before a value is assigned to its variable ({@link Value#variable()}). 
     * @param iteration current iteration
     * @param value value to be assigned
     */
    public void beforeAssigned(long iteration, Value value);

    /** Called before a value is unassigned from its variable ({@link Value#variable()}). 
     * @param iteration current iteration
     * @param value value to be unassigned
     */
    public void beforeUnassigned(long iteration, Value value);
    
    /** Called after a value is assigned to its variable ({@link Value#variable()}). 
     * @param iteration current iteration
     * @param value value to be assigned
     */
    public void afterAssigned(long iteration, Value value);

    /** Called after a value is unassigned from its variable ({@link Value#variable()}). 
     * @param iteration current iteration
     * @param value value to be unassigned
     */
    public void afterUnassigned(long iteration, Value value);
    
    /** Query for info about the model. A listener can also add some its info.
     * @param anInfo resultant table with informations (key, value).
     */
    public void getInfo(java.util.Hashtable anInfo);

    /** Notification that the model was initialized by the solver. 
     * @param solver IFS solver
     */
    public boolean init(ifs.solver.Solver solver);
}
