package ifs.model;

/**
 * Binary constraint.
 * <br><br>
 * Extension of {@link Constraint} that links exactly two variables.
 *
 * @see Variable
 * @see Constraint
 * @see Model
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */

public abstract class BinaryConstraint extends Constraint {
    private Variable iFirst = null, iSecond = null;
    public BinaryConstraint() {
        super();
    }
    
    public void addVariable(Variable var) {
        if (iFirst == null)
            iFirst = (Variable)var;
        else
            iSecond = (Variable)var;
        super.addVariable(var);
    }
    
    /** First variable */
    public Variable first() {
        return iFirst;
    }
    
    /** Second variable */
    public Variable second() {
        return iSecond;
    }
    
    /** True, id the given variable is the first one */
    public boolean isFirst(Variable variable) {
        return variable.equals(first());
    }
    
    /** Returns the variable out of the constraints variables which is different from the given variable.*/
    public Variable another(Variable variable) {
        return (
                first() != null && variable.equals(first()) ? second() : first());
    }
}
