package ifs.heuristics;

import ifs.model.*;
import ifs.solution.*;
import ifs.solver.*;

/**
 * Value selection criterion.
 * <br><br>
 * After a variable is selected, we need to find a value to be assigned to the variable. This problem is usually called
 * "value selection" in constraint programming. Typically, the most useful advice is to select the best-fit value.
 * So, we are looking for a value which is the most preferred for the variable and which causes the least trouble as well.
 * This means that we need to find a value with the minimal potential for future conflicts with other variables.
 * For example, a value which violates the smallest number of soft constraints can be selected among those with
 * the smallest number of hard conflicts.
 * <br><br>
 * The task of this criterion is to select a value of the given variable which will be assigned to this variable.
 *
 * @see Solver
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 **/
public interface ValueSelection {
    /** Initialization */
    public void init(Solver solver);
    /** Value selection
     * @param solution current solution
     * @param selectedVariable selected variable
     */
    public Value selectValue(Solution solution, Variable selectedVariable);
}
