package ifs.example.csp;

import java.util.*;

/**
 * Simple test of IFS CBS algorithm on random binary CSP problem CSP(25,12,198/300,36/144).
 *
 * @author <a href="mailto:muller@ktiml.mff.cuni.cz">Tomas Muller</a>
 * @version 1.0
 */
public class SimpleTest {
    /**
     * run the test
     */
    public static void main(String[] args) {
        org.apache.log4j.BasicConfigurator.configure();
        int nrVariables = 25;
        int nrValues = 12;
        int nrConstraints = 198;
        double tigtness = 0.25;
        int nrAllPairs = nrValues*nrValues;
        int nrCompatiblePairs = (int)((1.0-tigtness)*nrAllPairs);
        long seed = System.currentTimeMillis();
        System.out.println("CSP("+nrVariables+","+nrValues+","+nrConstraints+"/"+((nrVariables*(nrVariables-1))/2)+","+(nrAllPairs-nrCompatiblePairs)+"/"+nrAllPairs+")");
        
        ifs.util.DataProperties cfg = new ifs.util.DataProperties();
        cfg.setProperty("Termination.Class","ifs.termination.GeneralTerminationCondition");
        cfg.setProperty("Termination.StopWhenComplete","true");
        cfg.setProperty("Termination.TimeOut","60");
        cfg.setProperty("Comparator.Class","ifs.solution.GeneralSolutionComparator");
        cfg.setProperty("Value.Class","ifs.heuristics.GeneralValueSelection");
        cfg.setProperty("Value.WeightConflicts", "1");
        cfg.setProperty("Variable.Class","ifs.heuristics.GeneralVariableSelection");
        cfg.setProperty("Extensions.Classes","ifs.extension.ConflictStatistics");
        
        CSPModel model = new CSPModel(nrVariables,nrValues,nrConstraints,nrCompatiblePairs,seed);
        ifs.solver.Solver solver = new ifs.solver.Solver(cfg);
        solver.setInitalSolution(model);
        
        solver.start();
        try {
            solver.getSolverThread().join();
        } catch (InterruptedException e) {}
        
        ifs.solution.Solution solution = solver.lastSolution();
        solution.restoreBest();
        
        System.out.println("Best solution found after "+solution.getBestTime()+" seconds ("+solution.getBestIteration()+" iterations).");
        System.out.println("Number of assigned variables is "+solution.getModel().assignedVariables().size());
        System.out.println("Total value of the solution is "+solution.getModel().getTotalValue());
        
        int idx=1;
        for (Enumeration e=solution.getModel().variables().elements();e.hasMoreElements();) {
            CSPVariable v=(CSPVariable)e.nextElement();
            if (v.getAssignment()!=null)
                System.out.println("Var"+(idx++)+"="+v.getAssignment().toInt());
        }
    }
}
