/*
 * Decompiled with CFR 0.152.
 */
package ifs.util;

import ifs.util.FastVector;
import ifs.util.ProgressListener;
import java.util.Enumeration;
import java.util.Vector;

public class Progress {
    private String iStatus = "";
    private String iPhase = "";
    private long iProgressMax = 0L;
    private long iProgressCurrent = 0L;
    private Vector iListeners = new FastVector(5);
    private Vector iSave = new FastVector(5);
    private static Progress sInstance = new Progress();

    private Progress() {
    }

    public static Progress getInstance() {
        return sInstance;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String string) {
        if (!string.equals(this.iStatus)) {
            this.iStatus = string;
            this.fireStatusChanged();
        }
    }

    public String getPhase() {
        return this.iPhase;
    }

    public void setPhase(String string, long l) {
        this.iPhase = string;
        this.iProgressMax = l;
        this.iProgressCurrent = 0L;
        this.firePhaseChanged();
    }

    public void setPhase(String string) {
        this.setPhase(string, 100L);
    }

    public void setProgress(long l) {
        if (this.iProgressCurrent != l) {
            this.iProgressCurrent = l;
            this.fireProgressChanged();
        }
    }

    public long getProgress() {
        return this.iProgressCurrent;
    }

    public long getProgressMax() {
        return this.iProgressMax;
    }

    public void incProgress() {
        ++this.iProgressCurrent;
        this.fireProgressChanged();
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.iListeners.addElement(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.iListeners.removeElement(progressListener);
    }

    public synchronized void save() {
        this.iSave.addElement(new Object[]{this.iStatus, this.iPhase, new Long(this.iProgressMax), new Long(this.iProgressCurrent)});
        this.fireProgressSaved();
    }

    public synchronized void restore() {
        if (this.iSave.isEmpty()) {
            return;
        }
        Object[] objectArray = (Object[])this.iSave.lastElement();
        this.iSave.removeElementAt(this.iSave.size() - 1);
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        long l = (Long)objectArray[2];
        long l2 = (Long)objectArray[3];
        this.fireProgressRestored();
        this.setStatus(string);
        this.setPhase(string2, l2);
        this.setProgress(l);
    }

    private void fireStatusChanged() {
        Enumeration enumeration = this.iListeners.elements();
        while (enumeration.hasMoreElements()) {
            ProgressListener progressListener = (ProgressListener)enumeration.nextElement();
            progressListener.statusChanged(this.iStatus);
        }
    }

    private void firePhaseChanged() {
        Enumeration enumeration = this.iListeners.elements();
        while (enumeration.hasMoreElements()) {
            ProgressListener progressListener = (ProgressListener)enumeration.nextElement();
            progressListener.phaseChanged(this.iPhase);
        }
    }

    private void fireProgressChanged() {
        Enumeration enumeration = this.iListeners.elements();
        while (enumeration.hasMoreElements()) {
            ProgressListener progressListener = (ProgressListener)enumeration.nextElement();
            progressListener.progressChanged(this.iProgressCurrent, this.iProgressMax);
        }
    }

    private void fireProgressSaved() {
        Enumeration enumeration = this.iListeners.elements();
        while (enumeration.hasMoreElements()) {
            ProgressListener progressListener = (ProgressListener)enumeration.nextElement();
            progressListener.progressSaved();
        }
    }

    private void fireProgressRestored() {
        Enumeration enumeration = this.iListeners.elements();
        while (enumeration.hasMoreElements()) {
            ProgressListener progressListener = (ProgressListener)enumeration.nextElement();
            progressListener.progressRestored();
        }
    }
}

