/*
 * Decompiled with CFR 0.152.
 */
package ifs.termination;

import ifs.solution.Solution;
import ifs.termination.TerminationCondition;
import ifs.util.DataProperties;
import org.apache.log4j.Logger;

public class GeneralTerminationCondition
implements TerminationCondition {
    protected static Logger sLogger = Logger.getLogger((Class)(class$ifs$termination$GeneralTerminationCondition == null ? (class$ifs$termination$GeneralTerminationCondition = GeneralTerminationCondition.class$("ifs.termination.GeneralTerminationCondition")) : class$ifs$termination$GeneralTerminationCondition));
    private int iMaxIter;
    private double iTimeOut;
    private boolean iStopWhenComplete;
    static /* synthetic */ Class class$ifs$termination$GeneralTerminationCondition;

    public GeneralTerminationCondition(DataProperties dataProperties) {
        this.iMaxIter = dataProperties.getPropertyInt("Termination.MaxIters", -1);
        this.iTimeOut = dataProperties.getPropertyDouble("Termination.TimeOut", -1.0);
        this.iStopWhenComplete = dataProperties.getPropertyBoolean("Termination.StopWhenComplete", false);
    }

    public boolean canContinue(Solution solution) {
        if (this.iMaxIter >= 0 && solution.getIteration() >= (long)this.iMaxIter) {
            sLogger.info((Object)"Maximum number of iteration reached.");
            return false;
        }
        if (this.iTimeOut >= 0.0 && solution.getTime() > this.iTimeOut) {
            sLogger.info((Object)"Timeout reached.");
            return false;
        }
        if (this.iStopWhenComplete || this.iMaxIter < 0 && this.iTimeOut < 0.0) {
            boolean bl;
            boolean bl2 = bl = !solution.getModel().unassignedVariables().isEmpty();
            if (!bl) {
                sLogger.info((Object)"Complete solution found.");
            }
            return bl;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

