/*
 * Decompiled with CFR 0.152.
 */
package ifs.solver;

import ifs.extension.Extension;
import ifs.heuristics.ValueSelection;
import ifs.heuristics.VariableSelection;
import ifs.model.Model;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.perturbations.PerturbationsCounter;
import ifs.solution.Solution;
import ifs.solution.SolutionComparator;
import ifs.solver.SolverListener;
import ifs.termination.TerminationCondition;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.JProf;
import ifs.util.Progress;
import ifs.util.ToolBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Solver {
    protected static Logger sLogger = Logger.getLogger((Class)(class$ifs$solver$Solver == null ? (class$ifs$solver$Solver = Solver.class$("ifs.solver.Solver")) : class$ifs$solver$Solver));
    protected Solution iCurrentSolution = null;
    protected Solution iLastSolution = null;
    protected boolean iDone = false;
    protected boolean iRunning = false;
    protected boolean iStop = false;
    protected SolverThread iSolverThread = null;
    private DataProperties iProperties = null;
    private TerminationCondition iTerminationCondition = null;
    private SolutionComparator iSolutionComparator = null;
    private PerturbationsCounter iPerturbationsCounter = null;
    private ValueSelection iValueSelection = null;
    private VariableSelection iVariableSelection = null;
    private Vector iExtensions = new FastVector(5);
    private Vector iSolverListeners = new FastVector(5);
    private int iSaveBestUnassigned = 0;
    private boolean iValueExtraUsed = false;
    private boolean iVariableExtraUsed = false;
    static /* synthetic */ Class class$ifs$solver$Solver;
    static /* synthetic */ Class class$ifs$util$DataProperties;

    public Solver(DataProperties dataProperties) {
        this.iProperties = dataProperties;
        long l = dataProperties.getPropertyLong("General.Seed", System.currentTimeMillis());
        ToolBox.setSeed(l);
        this.iSaveBestUnassigned = dataProperties.getPropertyInt("General.SaveBestUnassigned", 0);
        this.clearBest();
        if (this.iProperties.getPropertyBoolean("Solver.AutoConfigure", true)) {
            this.autoConfigure();
        }
    }

    public void setTerminalCondition(TerminationCondition terminationCondition) {
        this.iTerminationCondition = terminationCondition;
    }

    public void setSolutionComparator(SolutionComparator solutionComparator) {
        this.iSolutionComparator = solutionComparator;
    }

    public void setValueSelection(ValueSelection valueSelection) {
        this.iValueSelection = valueSelection;
    }

    public void setVariableSelection(VariableSelection variableSelection) {
        this.iVariableSelection = variableSelection;
    }

    public void setPerturbationsCounter(PerturbationsCounter perturbationsCounter) {
        this.iPerturbationsCounter = perturbationsCounter;
    }

    public void addExtension(Extension extension) {
        if (extension.useValueExtra() && this.iValueExtraUsed) {
            sLogger.warn((Object)("Unable to add an extension " + extension + " -- value extra is already used."));
            return;
        }
        if (extension.useVariableExtra() && this.iVariableExtraUsed) {
            sLogger.warn((Object)("Unable to add extension " + extension + " -- variable extra is already used."));
            return;
        }
        this.iValueExtraUsed |= extension.useValueExtra();
        this.iValueExtraUsed = this.iVariableExtraUsed | extension.useVariableExtra();
        this.iExtensions.addElement(extension);
    }

    public TerminationCondition getTerminationCondition() {
        return this.iTerminationCondition;
    }

    public SolutionComparator getSolutionComparator() {
        return this.iSolutionComparator;
    }

    public ValueSelection getValueSelection() {
        return this.iValueSelection;
    }

    public VariableSelection getVariableSelection() {
        return this.iVariableSelection;
    }

    public PerturbationsCounter getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    public Vector getExtensions() {
        return this.iExtensions;
    }

    public void addSolverListener(SolverListener solverListener) {
        this.iSolverListeners.addElement(solverListener);
    }

    public void removeSolverListener(SolverListener solverListener) {
        this.iSolverListeners.removeElement(solverListener);
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    protected void autoConfigure() {
        try {
            boolean bl = this.getProperties().getPropertyBoolean("General.MPP", false);
            String string = this.getProperties().getProperty("Termination.Class", bl ? "ifs.termination.MPPTerminationCondition" : "ifs.termination.GeneralTerminationCondition");
            sLogger.info((Object)("Using " + string));
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(class$ifs$util$DataProperties == null ? (class$ifs$util$DataProperties = Solver.class$("ifs.util.DataProperties")) : class$ifs$util$DataProperties);
            this.setTerminalCondition((TerminationCondition)constructor.newInstance(this.getProperties()));
            String string2 = this.getProperties().getProperty("Comparator.Class", bl ? "ifs.solution.MPPSolutionComparator" : "ifs.solution.GeneralSolutionComparator");
            sLogger.info((Object)("Using " + string2));
            Class<?> clazz2 = Class.forName(string2);
            Constructor<?> constructor2 = clazz2.getConstructor(class$ifs$util$DataProperties == null ? (class$ifs$util$DataProperties = Solver.class$("ifs.util.DataProperties")) : class$ifs$util$DataProperties);
            this.setSolutionComparator((SolutionComparator)constructor2.newInstance(this.getProperties()));
            String string3 = this.getProperties().getProperty("Value.Class", "ifs.heuristics.GeneralValueSelection");
            sLogger.info((Object)("Using " + string3));
            Class<?> clazz3 = Class.forName(string3);
            Constructor<?> constructor3 = clazz3.getConstructor(class$ifs$util$DataProperties == null ? (class$ifs$util$DataProperties = Solver.class$("ifs.util.DataProperties")) : class$ifs$util$DataProperties);
            this.setValueSelection((ValueSelection)constructor3.newInstance(this.getProperties()));
            String string4 = this.getProperties().getProperty("Variable.Class", "ifs.heuristics.GeneralVariableSelection");
            sLogger.info((Object)("Using " + string4));
            Class<?> clazz4 = Class.forName(string4);
            Constructor<?> constructor4 = clazz4.getConstructor(class$ifs$util$DataProperties == null ? (class$ifs$util$DataProperties = Solver.class$("ifs.util.DataProperties")) : class$ifs$util$DataProperties);
            this.setVariableSelection((VariableSelection)constructor4.newInstance(this.getProperties()));
            String string5 = this.getProperties().getProperty("PerturbationCounter.Class", "ifs.perturbations.DefaultPerturbationsCounter");
            sLogger.info((Object)("Using " + string5));
            Class<?> clazz5 = Class.forName(string5);
            Constructor<?> constructor5 = clazz5.getConstructor(class$ifs$util$DataProperties == null ? (class$ifs$util$DataProperties = Solver.class$("ifs.util.DataProperties")) : class$ifs$util$DataProperties);
            this.setPerturbationsCounter((PerturbationsCounter)constructor5.newInstance(this.getProperties()));
            String string6 = this.getProperties().getProperty("Extensions.Classes", null);
            if (string6 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    sLogger.info((Object)("Using " + string7));
                    Class<?> clazz6 = Class.forName(string7);
                    Constructor<?> constructor6 = clazz6.getConstructor(class$ifs$solver$Solver == null ? Solver.class$("ifs.solver.Solver") : class$ifs$solver$Solver, class$ifs$util$DataProperties == null ? Solver.class$("ifs.util.DataProperties") : class$ifs$util$DataProperties);
                    this.addExtension((Extension)constructor6.newInstance(this, this.getProperties()));
                }
            }
        }
        catch (Exception exception) {
            sLogger.error((Object)"Unable to autoconfigure solver.", (Throwable)exception);
        }
    }

    public void clearBest() {
        if (this.iCurrentSolution != null) {
            this.iCurrentSolution.clearBest();
        }
    }

    public void setInitalSolution(Solution solution) {
        this.iCurrentSolution = solution;
    }

    public void setInitalSolution(Model model) {
        this.iCurrentSolution = new Solution(model, 0L, 0.0);
    }

    public void start() {
        this.iSolverThread = new SolverThread();
        this.iSolverThread.start();
    }

    public Thread getSolverThread() {
        return this.iSolverThread;
    }

    public void init() {
        this.iStop = false;
        this.iDone = false;
        this.iRunning = false;
    }

    public Solution lastSolution() {
        return this.iLastSolution == null ? this.iCurrentSolution : this.iLastSolution;
    }

    public Solution currentSolution() {
        return this.iCurrentSolution;
    }

    public boolean isDone() {
        return this.iDone;
    }

    public boolean isRunning() {
        return this.iRunning;
    }

    public void stopSolver() {
        this.iStop = true;
    }

    public boolean isStopped() {
        return this.iStop;
    }

    private void initSolver() {
        Progress.getInstance().setPhase("Initializing solver");
        Object object = this.iExtensions.elements();
        while (object.hasMoreElements()) {
            Extension extension = (Extension)object.nextElement();
            extension.register(this.iCurrentSolution.getModel());
        }
        this.iCurrentSolution.init(this);
        this.getValueSelection().init(this);
        this.getVariableSelection().init(this);
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().init(this);
        }
        if (this.iProperties.getPropertyBoolean("General.SaveConfiguration", false)) {
            try {
                object = new FileOutputStream(this.iProperties.getProperty("General.Output") + File.separator + this.iProperties.getProperty("General.ProblemName", "ifs") + ".properties");
                this.iProperties.store((OutputStream)object, this.iProperties.getProperty("General.ProblemNameLong", "Iterative Forward Search") + "  -- configuration file");
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {
                sLogger.error((Object)"Unable to store configuration file :-(", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class SolverThread
    extends Thread {
        protected SolverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object;
                this.setName("Solver");
                Solver.this.iStop = false;
                Solver.this.iDone = false;
                Solver.this.iRunning = true;
                Progress.getInstance().setStatus("Solving");
                Solver.this.initSolver();
                double d = JProf.currentTimeSec();
                if (Solver.this.iCurrentSolution.getBestInfo() == null) {
                    Progress.getInstance().setPhase("Searching for initial solution ...", Solver.this.iCurrentSolution.getModel().variables().size());
                } else {
                    Progress.getInstance().setPhase("Improving found solution ...");
                }
                long l = 9999L;
                sLogger.info((Object)("Initial solution:" + ToolBox.dict2string(Solver.this.iCurrentSolution.getInfo(), 1)));
                if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getModel().unassignedVariables().size() || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                    if (Solver.this.iCurrentSolution.getModel().unassignedVariables().isEmpty()) {
                        sLogger.info((Object)("Complete solution " + ToolBox.dict2string(Solver.this.iCurrentSolution.getInfo(), 1) + " was found."));
                    }
                    object = Solver.this.iCurrentSolution;
                    synchronized (object) {
                        Solver.this.iCurrentSolution.saveBest();
                    }
                }
                while (!Solver.this.iStop && Solver.this.getTerminationCondition().canContinue(Solver.this.iCurrentSolution)) {
                    object = Solver.this.getVariableSelection().selectVariable(Solver.this.iCurrentSolution);
                    Object object2 = Solver.this.iSolverListeners.elements();
                    while (object2.hasMoreElements()) {
                        if (((SolverListener)object2.nextElement()).variableSelected(Solver.this.iCurrentSolution.getIteration(), (Variable)object)) continue;
                    }
                    if (object == null) {
                        sLogger.warn((Object)"No variable selected.");
                    }
                    if (object != null && ((Variable)object).values().isEmpty()) {
                        sLogger.error((Object)("Variable " + ((Variable)object).getName() + " has no values."));
                        continue;
                    }
                    object2 = Solver.this.getValueSelection().selectValue(Solver.this.iCurrentSolution, (Variable)object);
                    Object object3 = Solver.this.iSolverListeners.elements();
                    while (object3.hasMoreElements()) {
                        if (((SolverListener)object3.nextElement()).valueSelected(Solver.this.iCurrentSolution.getIteration(), (Variable)object, (Value)object2)) continue;
                    }
                    if (object == null) {
                        sLogger.warn((Object)("No value selected for variable " + object + "."));
                    }
                    object3 = Solver.this.iCurrentSolution;
                    synchronized (object3) {
                        if (object2 != null) {
                            ((Variable)object).assign(Solver.this.iCurrentSolution.getIteration(), (Value)object2);
                        } else {
                            ((Variable)object).unassign(Solver.this.iCurrentSolution.getIteration());
                        }
                        Solver.this.iCurrentSolution.update(JProf.currentTimeSec() - d);
                    }
                    if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getModel().unassignedVariables().size() || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                        if (Solver.this.iCurrentSolution.getModel().unassignedVariables().isEmpty()) {
                            sLogger.info((Object)("Complete solution " + ToolBox.dict2string(Solver.this.iCurrentSolution.getInfo(), 1) + " was found."));
                        }
                        object3 = Solver.this.iCurrentSolution;
                        synchronized (object3) {
                            Solver.this.iCurrentSolution.saveBest();
                        }
                    }
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() == 0) {
                        if (++l == 10000L) {
                            Progress.getInstance().setPhase("Improving found solution ...");
                            l = 0L;
                            continue;
                        }
                        Progress.getInstance().setProgress(l / 100L);
                        continue;
                    }
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() <= 0 || (long)(Solver.this.iCurrentSolution.getModel().variables().size() - Solver.this.iCurrentSolution.getModel().unassignedVariables().size()) <= Progress.getInstance().getProgress()) continue;
                    Progress.getInstance().setProgress(Solver.this.iCurrentSolution.getModel().variables().size() - Solver.this.iCurrentSolution.getModel().unassignedVariables().size());
                }
                Solver.this.iLastSolution = Solver.this.iCurrentSolution;
                if (!Solver.this.iStop) {
                    Progress.getInstance().setPhase("Done", 1L);
                    Progress.getInstance().incProgress();
                }
                Solver.this.iDone = true;
                Solver.this.iRunning = false;
                Solver.this.iSolverThread = null;
                sLogger.debug((Object)"Solver stoped.");
            }
            catch (Exception exception) {
                sLogger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

