/*
 * Decompiled with CFR 0.152.
 */
package ifs.model;

import ifs.model.Constraint;
import ifs.model.Model;
import ifs.model.Value;
import ifs.model.VariableListener;
import ifs.util.FastVector;
import ifs.util.IdGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Variable
implements Comparable {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$model$Variable == null ? (class$ifs$model$Variable = Variable.class$("ifs.model.Variable")) : class$ifs$model$Variable));
    private static IdGenerator iIdGenerator = new IdGenerator();
    private long iId = -1L;
    private Model iModel = null;
    private Value iInitialValue = null;
    protected Value iValue = null;
    private Value iBestValue = null;
    private long iBestAssignmentIteration = 0L;
    private Vector iValues = null;
    private Value iRecentlyRemovedValue = null;
    private long iAssignmentCounter = 0L;
    private long iLastAssignmentIteration = -1L;
    private long iLastUnassignmentIteration = -1L;
    private Object iExtra = null;
    private Vector iConstraints = new FastVector();
    private Vector iHardConstraints = new FastVector();
    private Vector iSoftConstraints = new FastVector();
    private Vector iVariableListeners = null;
    private Hashtable iConstraintVariables = null;
    static /* synthetic */ Class class$ifs$model$Variable;

    public Variable() {
        this(null);
    }

    public Variable(Value value) {
        this.iId = iIdGenerator.newId();
        this.setInitialAssignment(value);
    }

    public Model getModel() {
        return this.iModel;
    }

    public void setModel(Model model) {
        this.iModel = model;
    }

    public Vector values() {
        return this.iValues;
    }

    protected void setValues(Vector vector) {
        this.iValues = vector;
    }

    public Value getAssignment() {
        return this.iValue;
    }

    public boolean hasAssignment() {
        return this.iValue != null;
    }

    public Value getInitialAssignment() {
        return this.iInitialValue;
    }

    public void setInitialAssignment(Value value) {
        this.iInitialValue = value;
        if (this.iInitialValue != null && this.iInitialValue.variable() == null) {
            this.iInitialValue.setVariable(this);
        }
    }

    public boolean hasInitialAssignment() {
        return this.iInitialValue != null;
    }

    public void assign(long l, Value value) {
        this.getModel().beforeAssigned(l, value);
        this.iLastAssignmentIteration = l;
        if (this.iValue != null) {
            this.unassign(l);
        }
        if (this.iRecentlyRemovedValue != null && this.iRecentlyRemovedValue.equals(value)) {
            this.iRecentlyRemovedValue = null;
            return;
        }
        if (value == null) {
            return;
        }
        this.iValue = value;
        Enumeration enumeration = this.iConstraints.elements();
        while (enumeration.hasMoreElements()) {
            Constraint constraint = (Constraint)enumeration.nextElement();
            constraint.assigned(l, value);
        }
        ++this.iAssignmentCounter;
        value.assigned(l);
        if (this.iVariableListeners != null) {
            enumeration = this.iVariableListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((VariableListener)enumeration.nextElement()).variableAssigned(l, value);
            }
        }
        this.getModel().afterAssigned(l, value);
    }

    public void unassign(long l) {
        if (this.iValue == null) {
            return;
        }
        this.getModel().beforeUnassigned(l, this.iValue);
        this.iLastUnassignmentIteration = l;
        Value value = this.iValue;
        this.iValue = null;
        Enumeration enumeration = this.iConstraints.elements();
        while (enumeration.hasMoreElements()) {
            Constraint constraint = (Constraint)enumeration.nextElement();
            constraint.unassigned(l, value);
        }
        value.unassigned(l);
        if (this.iVariableListeners != null) {
            enumeration = this.iVariableListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((VariableListener)enumeration.nextElement()).variableUnassigned(l, value);
            }
        }
        this.getModel().afterUnassigned(l, value);
    }

    public long countAssignments() {
        return this.iAssignmentCounter;
    }

    public void addContstraint(Constraint constraint) {
        this.iConstraints.addElement(constraint);
        if (constraint.isHard()) {
            this.iHardConstraints.addElement(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.addElement(constraint);
        }
    }

    public void removeContstraint(Constraint constraint) {
        this.iConstraints.removeElement(constraint);
        if (this.iHardConstraints.contains(constraint)) {
            this.iHardConstraints.removeElement(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.removeElement(constraint);
        }
    }

    public Vector constraints() {
        return this.iConstraints;
    }

    public Vector hardConstraints() {
        return this.iHardConstraints;
    }

    public Vector softConstraints() {
        return this.iSoftConstraints;
    }

    public String toString() {
        return "Variable{name=" + this.getName() + ", initial=" + this.getInitialAssignment() + ", current=" + this.getAssignment() + ", values=" + this.values().size() + ", constraints=" + this.iConstraints.size() + "}";
    }

    public long getId() {
        return this.iId;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public void setBestAssignment(Value value) {
        this.iBestValue = value;
        this.iBestAssignmentIteration = value == null ? 0L : value.lastAssignmentIteration();
    }

    public Value getBestAssignment() {
        return this.iBestValue;
    }

    public long getBestAssignmentIteration() {
        return this.iBestAssignmentIteration;
    }

    public long lastAssignmentIteration() {
        return this.iLastAssignmentIteration;
    }

    public long lastUnassignmentIteration() {
        return this.iLastUnassignmentIteration;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof Variable)) {
            return -1;
        }
        Variable variable = (Variable)object;
        return this.getName().compareTo(variable.getName());
    }

    public boolean equals(Object object) {
        try {
            Variable variable = (Variable)object;
            return this.getId() == variable.getId();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addVariableListener(VariableListener variableListener) {
        if (this.iVariableListeners == null) {
            this.iVariableListeners = new FastVector();
        }
        this.iVariableListeners.addElement(variableListener);
    }

    public void removeVariableListener(VariableListener variableListener) {
        if (this.iVariableListeners == null) {
            this.iVariableListeners = new FastVector();
        }
        this.iVariableListeners.removeElement(variableListener);
    }

    public void setExtra(Object object) {
        this.iExtra = object;
    }

    public Object getExtra() {
        return this.iExtra;
    }

    public void removeValue(long l, Value value) {
        if (this.iValue != null && this.iValue.equals(value)) {
            this.unassign(l);
        }
        if (this.iValues == null) {
            return;
        }
        this.iValues.remove(value);
        if (this.iInitialValue != null && this.iInitialValue.equals(value)) {
            this.iInitialValue = null;
        }
        if (this.iVariableListeners != null) {
            Enumeration enumeration = this.iVariableListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((VariableListener)enumeration.nextElement()).valueRemoved(l, value);
            }
        }
        this.iRecentlyRemovedValue = value;
    }

    public Hashtable constraintVariables() {
        if (this.iConstraintVariables == null) {
            this.iConstraintVariables = new Hashtable();
            Enumeration enumeration = this.constraints().elements();
            while (enumeration.hasMoreElements()) {
                Constraint constraint = (Constraint)enumeration.nextElement();
                Enumeration enumeration2 = constraint.variables().elements();
                while (enumeration2.hasMoreElements()) {
                    Variable variable = (Variable)enumeration2.nextElement();
                    if (variable.equals(this)) continue;
                    Vector vector = (Vector)this.iConstraintVariables.get(variable);
                    if (vector == null) {
                        vector = new FastVector(1, 10);
                        this.iConstraintVariables.put(variable, vector);
                    }
                    vector.add(constraint);
                }
            }
        }
        return this.iConstraintVariables;
    }

    public void removeInitialValue() {
        if (this.iInitialValue == null) {
            return;
        }
        if (this.iValues == null) {
            return;
        }
        if (this.getAssignment() != null && this.getAssignment().equals(this.iInitialValue)) {
            this.unassign(0L);
        }
        this.iValues.remove(this.iInitialValue);
        this.iInitialValue = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

