/*
 * Decompiled with CFR 0.152.
 */
package ifs.model;

import ifs.model.Constraint;
import ifs.model.ModelListener;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solver.Solver;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Model {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$model$Model == null ? (class$ifs$model$Model = Model.class$("ifs.model.Model")) : class$ifs$model$Model));
    private static DecimalFormat sTimeFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private Vector iVariables = new FastVector();
    private Vector iConstraints = new FastVector();
    private Vector iUnassignedVariables = new FastVector();
    private Vector iAssignedVariables = new FastVector();
    private Vector iPerturbVariables = null;
    private Vector iConflictVariables = null;
    private Vector iVariablesWithoutInitialValue = null;
    private int iBestUnassignedVariables = -1;
    private int iBestPerturbations = 0;
    private Vector iModelListeners = new FastVector();
    static /* synthetic */ Class class$ifs$model$Model;

    public Vector variables() {
        return this.iVariables;
    }

    public int countVariables() {
        return this.iVariables.size();
    }

    public void addVariable(Variable variable) {
        variable.setModel(this);
        this.iVariables.addElement(variable);
        if (variable.getAssignment() == null) {
            this.iUnassignedVariables.addElement(variable);
        } else {
            this.iAssignedVariables.addElement(variable);
        }
        if (variable.getAssignment() != null) {
            variable.assign(0L, variable.getAssignment());
        }
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).variableAdded(variable);
        }
    }

    public void removeVariable(Variable variable) {
        variable.setModel(null);
        this.iVariables.removeElement(variable);
        if (this.iUnassignedVariables.contains(variable)) {
            this.iUnassignedVariables.removeElement(variable);
        }
        if (this.iAssignedVariables.contains(variable)) {
            this.iAssignedVariables.removeElement(variable);
        }
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).variableRemoved(variable);
        }
    }

    public Vector constraints() {
        return this.iConstraints;
    }

    public int countConstraints() {
        return this.iConstraints.size();
    }

    public void addConstraint(Constraint constraint) {
        constraint.setModel(this);
        this.iConstraints.addElement(constraint);
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).constraintAdded(constraint);
        }
    }

    public void removeConstraint(Constraint constraint) {
        constraint.setModel(null);
        this.iConstraints.removeElement(constraint);
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).constraintRemoved(constraint);
        }
    }

    public Vector unassignedVariables() {
        return this.iUnassignedVariables;
    }

    public Vector assignedVariables() {
        return this.iAssignedVariables;
    }

    public Vector perturbVariables() {
        if (this.iPerturbVariables != null) {
            return this.iPerturbVariables;
        }
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getInitialAssignment() == null) continue;
            if (variable.getAssignment() != null) {
                if (variable.getInitialAssignment().equals(variable.getAssignment())) continue;
                fastVector.addElement(variable);
                continue;
            }
            boolean bl = false;
            Enumeration enumeration2 = variable.hardConstraints().elements();
            while (!bl && enumeration2.hasMoreElements()) {
                Constraint constraint = (Constraint)enumeration2.nextElement();
                if (!constraint.variables().contains(variable) || !constraint.inConflict(variable.getInitialAssignment())) continue;
                bl = true;
            }
            if (!bl) continue;
            fastVector.addElement(variable);
        }
        this.iPerturbVariables = fastVector;
        return fastVector;
    }

    public Set conflictValues(Value value) {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = value.variable().hardConstraints().elements();
        while (enumeration.hasMoreElements()) {
            ((Constraint)enumeration.nextElement()).computeConflicts(value, hashSet);
        }
        return hashSet;
    }

    public Vector variablesWithoutInitialValue() {
        if (this.iVariablesWithoutInitialValue != null) {
            return this.iVariablesWithoutInitialValue;
        }
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getInitialAssignment() != null) continue;
            fastVector.addElement(variable);
        }
        this.iVariablesWithoutInitialValue = fastVector;
        return fastVector;
    }

    public void beforeAssigned(long l, Value value) {
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).beforeAssigned(l, value);
        }
    }

    public void beforeUnassigned(long l, Value value) {
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).beforeUnassigned(l, value);
        }
    }

    public void afterAssigned(long l, Value value) {
        this.iUnassignedVariables.removeElement(value.variable());
        this.iAssignedVariables.addElement(value.variable());
        this.iPerturbVariables = null;
        this.iConflictVariables = null;
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).afterAssigned(l, value);
        }
    }

    public void afterUnassigned(long l, Value value) {
        this.iUnassignedVariables.addElement(value.variable());
        this.iAssignedVariables.removeElement(value.variable());
        this.iPerturbVariables = null;
        this.iConflictVariables = null;
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).afterUnassigned(l, value);
        }
    }

    public String toString() {
        Collections.sort(this.variables(), new Comparator(){

            public int compare(Object object, Object object2) {
                Variable variable = (Variable)object;
                Variable variable2 = (Variable)object2;
                return variable != null ? variable.getName().compareTo(variable2.getName()) : (int)(variable.getId() - variable2.getId());
            }
        });
        return "Model{\n    variables=" + ToolBox.col2string(this.variables(), 2) + ",\n    constraints=" + ToolBox.col2string(this.constraints(), 2) + ",\n    #unassigned=" + this.unassignedVariables().size() + ",\n    unassigned=" + ToolBox.col2string(this.unassignedVariables(), 2) + ",\n    #perturbations=" + this.perturbVariables().size() + "+" + this.variablesWithoutInitialValue().size() + ",\n    perturbations=" + ToolBox.col2string(this.perturbVariables(), 2) + ",\n    info=" + this.getInfo() + (this.variablesWithoutInitialValue().size() < this.variables().size() ? ",\n    withoutInitial=" + ToolBox.col2string(this.variablesWithoutInitialValue(), 2) : "") + "\n  }";
    }

    public Hashtable getInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Unassigned variables", this.unassignedVariables().size() + " / " + this.variables().size());
        hashtable.put("Perturbation variables (with + without initial value)", this.perturbVariables().size() + " + " + this.variablesWithoutInitialValue().size());
        hashtable.put("Total value", new Integer(this.getTotalValue()));
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ModelListener)enumeration.nextElement()).getInfo(hashtable);
        }
        enumeration = this.iConstraints.elements();
        while (enumeration.hasMoreElements()) {
            ((Constraint)enumeration.nextElement()).getInfo(hashtable);
        }
        return hashtable;
    }

    public int getBestUnassignedVariables() {
        return this.iBestUnassignedVariables;
    }

    public int getBestPerturbations() {
        return this.iBestPerturbations;
    }

    public void saveBest() {
        this.iBestUnassignedVariables = this.unassignedVariables().size();
        this.iBestPerturbations = this.perturbVariables().size();
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            variable.setBestAssignment(variable.getAssignment());
        }
    }

    public void restoreBest() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Comparable comparable;
        Object object5;
        Object object6 = this.variables().elements();
        while (object6.hasMoreElements()) {
            object5 = (Variable)object6.nextElement();
            ((Variable)object5).unassign(0L);
        }
        object6 = new HashSet();
        object5 = ToolBox.sortEnumeration(this.variables().elements(), new BestAssignmentComparator());
        while (object5.hasMoreElements()) {
            comparable = (Variable)object5.nextElement();
            if (((Variable)comparable).getBestAssignment() == null) continue;
            object4 = this.conflictValues(((Variable)comparable).getBestAssignment());
            if (!object4.isEmpty()) {
                sLogger.error((Object)("restore best problem: assignment " + ((Variable)comparable).getName() + " = " + ((Variable)comparable).getBestAssignment().getName()));
                object3 = ((Variable)comparable).hardConstraints().elements();
                while (object3.hasMoreElements()) {
                    object2 = (Constraint)object3.nextElement();
                    object = new HashSet();
                    ((Constraint)object2).computeConflicts(((Variable)comparable).getBestAssignment(), (Set)object);
                    if (object.isEmpty()) continue;
                    sLogger.error((Object)("  constraint " + ((Constraint)object2).getName() + " causes the following conflicts " + object));
                }
                ((HashSet)object6).add(((Variable)comparable).getBestAssignment());
                continue;
            }
            ((Variable)comparable).assign(0L, ((Variable)comparable).getBestAssignment());
        }
        int n = 0;
        while (!((HashSet)object6).isEmpty() && n <= 100) {
            ++n;
            comparable = (Value)ToolBox.random((Collection)object6);
            ((HashSet)object6).remove(comparable);
            object4 = ((Value)comparable).variable();
            object3 = this.conflictValues((Value)comparable);
            if (!object3.isEmpty()) {
                sLogger.error((Object)("restore best problem (again, att=" + n + "): assignment " + ((Variable)object4).getName() + " = " + ((Variable)object4).getBestAssignment().getName()));
                object2 = ((Variable)object4).hardConstraints().elements();
                while (object2.hasMoreElements()) {
                    object = (Constraint)object2.nextElement();
                    HashSet hashSet = new HashSet();
                    ((Constraint)object).computeConflicts((Value)comparable, hashSet);
                    if (hashSet.isEmpty()) continue;
                    sLogger.error((Object)("  constraint " + ((Constraint)object).getName() + " causes the following conflicts " + hashSet));
                }
                ((AbstractCollection)object6).addAll(object3);
            }
            ((Variable)object4).assign(0L, (Value)comparable);
        }
    }

    public Vector bestUnassignedVariables() {
        if (this.iBestUnassignedVariables < 0) {
            return this.unassignedVariables();
        }
        FastVector fastVector = new FastVector(this.variables().size());
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.getBestAssignment() != null) continue;
            fastVector.addElement(variable);
        }
        return fastVector;
    }

    public int getTotalValue() {
        int n = 0;
        Enumeration enumeration = this.assignedVariables().elements();
        while (enumeration.hasMoreElements()) {
            n += ((Variable)enumeration.nextElement()).getAssignment().toInt();
        }
        return n;
    }

    public void addModelListener(ModelListener modelListener) {
        this.iModelListeners.addElement(modelListener);
        Enumeration enumeration = this.iConstraints.elements();
        while (enumeration.hasMoreElements()) {
            modelListener.constraintAdded((Constraint)enumeration.nextElement());
        }
        enumeration = this.iVariables.elements();
        while (enumeration.hasMoreElements()) {
            modelListener.variableAdded((Variable)enumeration.nextElement());
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        Enumeration enumeration = this.iVariables.elements();
        while (enumeration.hasMoreElements()) {
            modelListener.variableRemoved((Variable)enumeration.nextElement());
        }
        enumeration = this.iConstraints.elements();
        while (enumeration.hasMoreElements()) {
            modelListener.constraintRemoved((Constraint)enumeration.nextElement());
        }
        this.iModelListeners.removeElement(modelListener);
    }

    public boolean init(Solver solver) {
        boolean bl = true;
        Enumeration enumeration = this.iModelListeners.elements();
        while (bl && enumeration.hasMoreElements()) {
            bl = ((ModelListener)enumeration.nextElement()).init(solver);
        }
        return bl;
    }

    public Vector getModelListeners() {
        return this.iModelListeners;
    }

    public ModelListener modelListenerOfType(Class clazz) {
        Enumeration enumeration = this.iModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            ModelListener modelListener = (ModelListener)enumeration.nextElement();
            if (modelListener.getClass() != clazz) continue;
            return modelListener;
        }
        return null;
    }

    public Hashtable conflictConstraints(Value value) {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = value.variable().hardConstraints().elements();
        while (enumeration.hasMoreElements()) {
            Constraint constraint = (Constraint)enumeration.nextElement();
            HashSet hashSet = new HashSet();
            constraint.computeConflicts(value, hashSet);
            if (hashSet == null || hashSet.isEmpty()) continue;
            hashtable.put(constraint, hashSet);
        }
        return hashtable;
    }

    public Vector unassignedHardConstraints() {
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.constraints().elements();
        while (enumeration.hasMoreElements()) {
            Constraint constraint = (Constraint)enumeration.nextElement();
            if (!constraint.isHard()) continue;
            boolean bl = true;
            Enumeration enumeration2 = constraint.variables().elements();
            while (bl && enumeration2.hasMoreElements()) {
                if (((Variable)enumeration2.nextElement()).getAssignment() != null) continue;
                bl = false;
            }
            if (bl) continue;
            fastVector.addElement(constraint);
        }
        return fastVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BestAssignmentComparator
    implements Comparator {
        private BestAssignmentComparator() {
        }

        public int compare(Object object, Object object2) {
            Variable variable = (Variable)object;
            Variable variable2 = (Variable)object2;
            return (int)(variable.getBestAssignmentIteration() - variable2.getBestAssignmentIteration());
        }
    }
}

