/*
 * Decompiled with CFR 0.152.
 */
package ifs.extension;

import ifs.extension.Assignment;
import ifs.extension.AssignmentSet;
import ifs.extension.Extension;
import ifs.model.Constraint;
import ifs.model.ConstraintListener;
import ifs.model.Model;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solution.SolutionListener;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConflictStatistics
extends Extension
implements ConstraintListener,
SolutionListener {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$extension$ConflictStatistics == null ? (class$ifs$extension$ConflictStatistics = ConflictStatistics.class$("ifs.extension.ConflictStatistics")) : class$ifs$extension$ConflictStatistics));
    private static final String PARAM_AGEING = "ConflictStatistics.Ageing";
    private static final String PARAM_HALF_AGE = "ConflictStatistics.AgeingHalfTime";
    private static final String PARAM_PRINT = "ConflictStatistics.Print";
    private static final String PARAM_PRINTINTERVAL = "ConflictStatistics.PrintInterval";
    private static final int TYPE_VARIABLE_BASED = 0;
    private static final int TYPE_CONSTRAINT_BASED = 1;
    private double iAgeing = 1.0;
    private long iPrintInterval = -1L;
    private boolean iPrint = false;
    private int iPrintCounter = 0;
    private Hashtable iAssignments = new Hashtable();
    private Hashtable iUnassignedVariables = new Hashtable();
    private Hashtable iNoGoods = new Hashtable();
    static /* synthetic */ Class class$ifs$extension$ConflictStatistics;

    public ConflictStatistics(Solver solver, DataProperties dataProperties) {
        super(solver, dataProperties);
        this.iAgeing = dataProperties.getPropertyDouble(PARAM_AGEING, this.iAgeing);
        int n = dataProperties.getPropertyInt(PARAM_HALF_AGE, 0);
        if (n > 0) {
            this.iAgeing = Math.exp(Math.log(0.5) / (double)n);
        }
        this.iPrint = dataProperties.getPropertyBoolean(PARAM_PRINT, this.iPrint);
        this.iPrintInterval = dataProperties.getPropertyLong(PARAM_PRINTINTERVAL, this.iPrintInterval);
    }

    public void register(Model model) {
        super.register(model);
        if (this.iPrint) {
            this.getSolver().currentSolution().addSolutionListener(this);
        }
    }

    public void unregister(Model model) {
        super.unregister(model);
        if (this.iPrint) {
            this.getSolver().currentSolution().removeSolutionListener(this);
        }
    }

    private void variableUnassigned(long l, Value value, AssignmentSet assignmentSet) {
        Assignment assignment = new Assignment(l, value, this.iAgeing);
        Vector vector = (Vector)this.iNoGoods.get(assignment);
        if (vector != null) {
            if (vector.contains(assignmentSet)) {
                ((AssignmentSet)vector.elementAt(vector.indexOf(assignmentSet))).incCounter();
            } else {
                vector.addElement(assignmentSet);
            }
        } else {
            vector = new FastVector();
            vector.addElement(assignmentSet);
            this.iNoGoods.put(assignment, vector);
        }
    }

    private void variableUnassigned(long l, Value value, Value value2) {
        Vector vector;
        Assignment assignment = new Assignment(l, value2, this.iAgeing);
        Assignment assignment2 = new Assignment(l, value, this.iAgeing);
        if (this.iAssignments.containsKey(assignment2)) {
            vector = (Vector)this.iAssignments.get(assignment2);
            if (vector.contains(assignment)) {
                ((Assignment)vector.elementAt(vector.indexOf(assignment))).incCounter(l);
            } else {
                vector.addElement(assignment);
            }
        } else {
            vector = new FastVector();
            vector.addElement(assignment);
            this.iAssignments.put(assignment2, vector);
        }
        if (this.iUnassignedVariables.containsKey(value.variable())) {
            vector = (Vector)this.iUnassignedVariables.get(value.variable());
            if (vector.contains(assignment)) {
                ((Assignment)vector.elementAt(vector.indexOf(assignment))).incCounter(l);
            } else {
                vector.addElement(assignment);
            }
        } else {
            vector = new FastVector();
            vector.addElement(assignment);
            this.iUnassignedVariables.put(value.variable(), vector);
        }
    }

    public double countRemovals(long l, Collection collection, Value value) {
        long l2 = 0L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Value value2 = (Value)iterator.next();
            l2 = (long)((double)l2 + this.countRemovals(l, value2, value));
        }
        return l2;
    }

    public double countRemovals(long l, Value value, Value value2) {
        Vector vector = (Vector)this.iUnassignedVariables.get(value.variable());
        if (vector == null) {
            return 0.0;
        }
        Assignment assignment = new Assignment(l, value2, this.iAgeing);
        int n = vector.indexOf(assignment);
        if (n < 0) {
            return 0.0;
        }
        return ((Assignment)vector.elementAt(n)).getCounter(l);
    }

    public long countPotentialConflicts(long l, Value value, int n) {
        Vector vector = (Vector)this.iAssignments.get(new Assignment(l, value, this.iAgeing));
        if (vector == null) {
            return 0L;
        }
        long l2 = 0L;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Assignment assignment = (Assignment)enumeration.nextElement();
            if (assignment.getValue().variable().getAssignment() != null) continue;
            if (n >= 0) {
                l2 = (long)((double)l2 + assignment.getCounter(l) * (double)Math.max(0, 1 + n - value.variable().getModel().conflictValues(assignment.getValue()).size()));
                continue;
            }
            l2 = (long)((double)l2 + assignment.getCounter(l));
        }
        return l2;
    }

    private void menu_item(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, boolean bl) {
        printWriter.println("<div style=\"margin-left:5px;\">");
        printWriter.println("<A style=\"border:0;background:0\" id=\"__idMenu" + string2 + "\" href=\"javascript:toggle('" + string2 + "')\" name=\"" + string3 + "\" title=\"Expand " + string3 + "\">");
        printWriter.println("<img id=\"__idMenuImg" + string2 + "\" border=\"0\" src=\"" + (string == null ? "img/" : string) + (bl ? "expand" : "collapse") + ".gif\" align=\"absmiddle\"></A>");
        printWriter.println("&nbsp;<A target=\"__idContentFrame\" " + (string5 == null ? "" : "href=\"" + string5 + "\" ") + "title=\"" + (string4 == null ? "" : string4) + "\" >" + string3 + (string4 == null ? "" : " <font color='gray'>[" + string4 + "]</font>") + "</A><br>");
        printWriter.println("</div>");
        printWriter.println("<div ID=\"__idMenuDiv" + string2 + "\" style=\"display:" + (bl ? "none" : "block") + ";position:relative;margin-left:18px;\">");
    }

    private void leaf_item(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        printWriter.println("<div style=\"margin-left:5px;\">");
        printWriter.println("<img border=\"0\" src=\"" + (string == null ? "img/" : string) + "end.gif\" align=\"absmiddle\">");
        printWriter.println("&nbsp;<A target=\"__idContentFrame\" " + (string4 == null ? "" : "href=\"" + string4 + "\" ") + "title=\"" + (string3 == null ? "" : string3) + "\" >" + string2 + (string3 == null ? "" : " <font color='gray'>[" + string3 + "]</font>") + "</A><br>");
        printWriter.println("</div>");
    }

    private void end_item(PrintWriter printWriter) {
        printWriter.println("</div>");
    }

    private void unassignedVariableMenuItem(PrintWriter printWriter, String string, String string2, long l, Variable variable) {
        this.menu_item(printWriter, string, string2, l + "x " + variable.getName(), variable.getDescription(), null, true);
    }

    private void unassignmentMenuItem(PrintWriter printWriter, String string, String string2, double d, Assignment assignment) {
        this.menu_item(printWriter, string, string2, Math.round(d) + "x " + assignment.getValue().getName(), assignment.getValue().getDescription(), null, true);
    }

    private void constraintMenuItem(PrintWriter printWriter, String string, String string2, long l, Constraint constraint) {
        String string3 = constraint == null ? null : constraint.getClass().getName().substring(constraint.getClass().getName().lastIndexOf(46) + 1) + (constraint.getName() == null ? "" : " " + constraint.getName());
        this.menu_item(printWriter, string, string2, l + "x " + string3, constraint == null ? null : constraint.getDescription(), null, true);
    }

    private void assignmentsMenuItem(PrintWriter printWriter, String string, String string2, AssignmentSet assignmentSet) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = assignmentSet.getSet().elements();
        while (enumeration.hasMoreElements()) {
            Assignment assignment = (Assignment)enumeration.nextElement();
            stringBuffer.append(stringBuffer.length() == 0 ? "" : ", ").append(assignment.getValue().variable().getName());
        }
        this.menu_item(printWriter, string, string2, assignmentSet.getCounter() + "x [" + stringBuffer + "]", null, null, true);
    }

    private void assignmentLeafItem(PrintWriter printWriter, String string, Assignment assignment) {
        this.leaf_item(printWriter, string, assignment.getValue().variable().getName() + " := " + assignment.getValue().getName(), null, null);
    }

    private void assignmentLeafItem(PrintWriter printWriter, String string, long l, Assignment assignment) {
        this.leaf_item(printWriter, string, l + "x " + assignment.getValue().variable().getName() + " := " + assignment.getValue().getName(), null, null);
    }

    public void printHtml(long l, PrintWriter printWriter, long l2, long l3, long l4, int n) {
        this.printHtml(l, printWriter, true, l2, l3, l4, null, n);
    }

    public void printHtml(long l, PrintWriter printWriter, DataProperties dataProperties) {
        this.printHtml(l, printWriter, dataProperties.getPropertyBoolean("ConflictStatistics.PringHeader", false), dataProperties.getPropertyInt("ConflictStatistics.MaxLines", 25), dataProperties.getPropertyInt("ConflictStatistics.MaxBranchingLev1", 100), dataProperties.getPropertyInt("ConflictStatistics.MaxBranchingLev2", 10), dataProperties.getProperty("ConflictStatistics.ImageBase", null), dataProperties.getPropertyInt("ConflictStatistics.Type", 0));
    }

    public void printHtml(long l, PrintWriter printWriter, boolean bl, long l2, long l3, long l4, String string, int n) {
        if (bl) {
            printWriter.println("<html><head>");
            printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            printWriter.println();
            printWriter.println("<style type=\"text/css\">");
            printWriter.println("<!--");
            printWriter.println("A:link     { color: blue; text-decoration: none; border:0; background:0; }");
            printWriter.println("A:visited  { color: blue; text-decoration: none; border:0; background:0; }");
            printWriter.println("A:active   { color: blue; text-decoration: none; border:0; background:0; }");
            printWriter.println("A:hover    { color: blue; text-decoration: none; border:0; background:0; }");
            printWriter.println(".TextBody  { background-color: white; color:black; font-size: 12px; }");
            printWriter.println(".WelcomeHead { color: black; margin-top: 0px; margin-left: 0px; font-weight: bold; text-align: right; font-size: 30px; font-family: Comic Sans MS}");
            printWriter.println("-->");
            printWriter.println("</style>");
            printWriter.println();
            printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
            printWriter.println("function toggle(item) {");
            printWriter.println("\tobj=document.getElementById(\"__idMenuDiv\"+item);");
            printWriter.println("\tvisible=(obj.style.display!=\"none\");");
            printWriter.println("\timg=document.getElementById(\"__idMenuImg\" + item);");
            printWriter.println("\tmenu=document.getElementById(\"__idMenu\" + item);");
            printWriter.println("\tif (visible) {obj.style.display=\"none\";img.src=\"" + (string == null ? "img/" : string) + "expand.gif\";menu.title='Expand '+menu.name;}");
            printWriter.println("\telse {obj.style.display=\"block\";img.src=\"" + (string == null ? "img/" : string) + "collapse.gif\";menu.title='Collapse '+menu.name;}");
            printWriter.println("}");
            printWriter.println("</script>");
            printWriter.println();
            printWriter.println("</head>");
            printWriter.println("<body class=\"TextBody\">");
            printWriter.println("<br><table border='0' width='100%'>");
            printWriter.println("<tr><td width=12>&nbsp;</td><td bgcolor='#BBCDE4' align='right'>");
            printWriter.println("<div class=WelcomeHead>Conflict Statistics&nbsp;</div></td></tr></table><br>");
            printWriter.println("<ul>");
        }
        if (n == 0) {
            Object object;
            Hashtable<Variable, Long> hashtable = new Hashtable<Variable, Long>();
            Hashtable<Variable, Object> hashtable2 = new Hashtable<Variable, Object>();
            Enumeration enumeration = this.iNoGoods.keys();
            while (enumeration.hasMoreElements()) {
                object = (Assignment)enumeration.nextElement();
                long l5 = 0L;
                Object object2 = ((Vector)this.iNoGoods.get(object)).elements();
                while (object2.hasMoreElements()) {
                    l5 += (long)((AssignmentSet)object2.nextElement()).getCounter();
                }
                ((Assignment)object).setCounter(l5);
                hashtable.put(((Assignment)object).getValue().variable(), new Long(l5 += hashtable.containsKey(((Assignment)object).getValue().variable()) ? (Long)hashtable.get(((Assignment)object).getValue().variable()) : 0L));
                object2 = (Vector)hashtable2.get(((Assignment)object).getValue().variable());
                if (object2 == null) {
                    object2 = new FastVector();
                    hashtable2.put(((Assignment)object).getValue().variable(), object2);
                }
                ((Vector)object2).addElement(object);
            }
            int n2 = 0;
            object = ToolBox.sortEnumeration(hashtable.keys(), new VariableComparator(hashtable));
            while (object.hasMoreElements()) {
                Variable variable = (Variable)object.nextElement();
                if ((long)(++n2) <= l2) {
                    long l6 = (Long)hashtable.get(variable);
                    this.unassignedVariableMenuItem(printWriter, string, String.valueOf(variable.getId()), l6, variable);
                    Enumeration enumeration2 = ToolBox.sortEnumeration(((Vector)hashtable2.get(variable)).elements(), Assignment.getComparator(l));
                    while (enumeration2.hasMoreElements()) {
                        Object object3;
                        Long l7;
                        Object object4;
                        Assignment assignment = (Assignment)enumeration2.nextElement();
                        if (!assignment.getValue().variable().equals(variable)) continue;
                        double d = 0.0;
                        Enumeration enumeration3 = ((Vector)this.iNoGoods.get(assignment)).elements();
                        while (enumeration3.hasMoreElements()) {
                            d += (double)((AssignmentSet)enumeration3.nextElement()).getCounter();
                        }
                        if (Math.round(d) < l3) continue;
                        this.unassignmentMenuItem(printWriter, string, assignment.getValue().variable().getId() + "." + assignment.getValue().getId(), d, assignment);
                        int n3 = 0;
                        Hashtable<Constraint, Long> hashtable3 = new Hashtable<Constraint, Long>();
                        Hashtable<Constraint, Vector> hashtable4 = new Hashtable<Constraint, Vector>();
                        Enumeration enumeration4 = ((Vector)this.iNoGoods.get(assignment)).elements();
                        while (enumeration4.hasMoreElements()) {
                            object4 = (AssignmentSet)enumeration4.nextElement();
                            if (((AssignmentSet)object4).getConstraint() == null) continue;
                            l7 = (Long)hashtable3.get(((AssignmentSet)object4).getConstraint());
                            if (l7 == null) {
                                hashtable3.put(((AssignmentSet)object4).getConstraint(), new Long(((AssignmentSet)object4).getCounter()));
                            } else {
                                hashtable3.put(((AssignmentSet)object4).getConstraint(), new Long((long)((AssignmentSet)object4).getCounter() + l7));
                            }
                            object3 = (Vector)hashtable4.get(((AssignmentSet)object4).getConstraint());
                            if (object3 == null) {
                                object3 = new FastVector();
                                hashtable4.put(((AssignmentSet)object4).getConstraint(), (Vector)object3);
                            }
                            ((Vector)object3).addElement(object4);
                        }
                        enumeration4 = ToolBox.sortEnumeration(hashtable3.keys(), new ConstraintComparator(hashtable3));
                        while (enumeration4.hasMoreElements()) {
                            object4 = (Constraint)enumeration4.nextElement();
                            l7 = (Long)hashtable3.get(object4);
                            this.constraintMenuItem(printWriter, string, assignment.getValue().variable().getId() + "." + assignment.getValue().getId() + "." + ((Constraint)object4).getId(), l7, (Constraint)object4);
                            if (l7 >= l4) {
                                object3 = ((Vector)hashtable4.get(object4)).elements();
                                while (object3.hasMoreElements()) {
                                    boolean bl2;
                                    AssignmentSet assignmentSet = (AssignmentSet)object3.nextElement();
                                    boolean bl3 = bl2 = assignmentSet.getSet().size() > 2;
                                    if (bl2) {
                                        this.assignmentsMenuItem(printWriter, string, assignment.getValue().variable().getId() + "." + assignment.getValue().getId() + "." + ((Constraint)object4).getId() + "." + ++n3, assignmentSet);
                                    }
                                    Enumeration enumeration5 = ToolBox.sortEnumeration(assignmentSet.getSet().elements(), Assignment.getComparator(l));
                                    while (enumeration5.hasMoreElements()) {
                                        Assignment assignment2 = (Assignment)enumeration5.nextElement();
                                        if (assignment.equals(assignment2)) continue;
                                        if (bl2) {
                                            this.assignmentLeafItem(printWriter, string, assignment2);
                                            continue;
                                        }
                                        this.assignmentLeafItem(printWriter, string, assignmentSet.getCounter(), assignment2);
                                    }
                                    if (!bl2) continue;
                                    this.end_item(printWriter);
                                }
                            }
                            this.end_item(printWriter);
                        }
                        this.end_item(printWriter);
                    }
                    this.end_item(printWriter);
                    continue;
                }
                break;
            }
        } else if (n == 1) {
            Serializable serializable;
            Cloneable cloneable;
            Hashtable hashtable;
            Object object;
            Object object5;
            Object object6;
            Hashtable<Constraint, Hashtable> hashtable5 = new Hashtable<Constraint, Hashtable>();
            Hashtable<Constraint, Long> hashtable6 = new Hashtable<Constraint, Long>();
            Enumeration enumeration = this.iNoGoods.keys();
            while (enumeration.hasMoreElements()) {
                object6 = (Assignment)enumeration.nextElement();
                object5 = ((Vector)this.iNoGoods.get(object6)).elements();
                while (object5.hasMoreElements()) {
                    object = (AssignmentSet)object5.nextElement();
                    if (((AssignmentSet)object).getConstraint() == null) continue;
                    hashtable = (Hashtable)hashtable5.get(((AssignmentSet)object).getConstraint());
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                        hashtable5.put(((AssignmentSet)object).getConstraint(), hashtable);
                    }
                    if ((cloneable = (Vector)hashtable.get(object6)) == null) {
                        cloneable = new FastVector();
                        hashtable.put(object6, cloneable);
                    }
                    ((Vector)cloneable).addElement(object);
                    serializable = (Long)hashtable6.get(((AssignmentSet)object).getConstraint());
                    hashtable6.put(((AssignmentSet)object).getConstraint(), new Long((long)((AssignmentSet)object).getCounter() + (serializable == null ? 0L : (Long)serializable)));
                }
            }
            int n4 = 0;
            object6 = ToolBox.sortEnumeration(hashtable6.keys(), new ConstraintComparator(hashtable6));
            while (object6.hasMoreElements()) {
                object5 = (Constraint)object6.nextElement();
                if ((long)(++n4) <= l2) {
                    Object object7;
                    long l8;
                    Object object8;
                    object = (Long)hashtable6.get(object5);
                    hashtable = (Hashtable)hashtable5.get(object5);
                    this.constraintMenuItem(printWriter, string, String.valueOf(((Constraint)object5).getId()), (Long)object, (Constraint)object5);
                    cloneable = new Hashtable();
                    serializable = new Hashtable();
                    Enumeration enumeration6 = hashtable.keys();
                    while (enumeration6.hasMoreElements()) {
                        object8 = (Assignment)enumeration6.nextElement();
                        l8 = 0L;
                        object7 = ((Vector)hashtable.get(object8)).elements();
                        while (object7.hasMoreElements()) {
                            l8 += (long)((AssignmentSet)object7.nextElement()).getCounter();
                        }
                        ((Assignment)object8).setCounter(l8);
                        ((Hashtable)cloneable).put(((Assignment)object8).getValue().variable(), new Long(l8 += ((Hashtable)cloneable).containsKey(((Assignment)object8).getValue().variable()) ? (Long)((Hashtable)cloneable).get(((Assignment)object8).getValue().variable()) : 0L));
                        object7 = (Vector)((Hashtable)serializable).get(((Assignment)object8).getValue().variable());
                        if (object7 == null) {
                            object7 = new FastVector();
                            ((Hashtable)serializable).put(((Assignment)object8).getValue().variable(), object7);
                        }
                        ((Vector)object7).addElement(object8);
                    }
                    enumeration6 = ToolBox.sortEnumeration(((Hashtable)cloneable).keys(), new VariableComparator((Hashtable)cloneable));
                    while (enumeration6.hasMoreElements()) {
                        object8 = (Variable)enumeration6.nextElement();
                        l8 = (Long)((Hashtable)cloneable).get(object8);
                        if (l8 < l3) continue;
                        this.unassignedVariableMenuItem(printWriter, string, ((Constraint)object5).getId() + "." + ((Variable)object8).getId(), l8, (Variable)object8);
                        object7 = ToolBox.sortEnumeration(((Vector)((Hashtable)serializable).get(object8)).elements(), Assignment.getComparator(l));
                        while (object7.hasMoreElements()) {
                            Assignment assignment = (Assignment)object7.nextElement();
                            if (!assignment.getValue().variable().equals(object8)) continue;
                            double d = 0.0;
                            Enumeration enumeration7 = ((Vector)this.iNoGoods.get(assignment)).elements();
                            while (enumeration7.hasMoreElements()) {
                                d += (double)((AssignmentSet)enumeration7.nextElement()).getCounter();
                            }
                            if (Math.round(d) < l4) continue;
                            this.unassignmentMenuItem(printWriter, string, ((Constraint)object5).getId() + "." + assignment.getValue().variable().getId() + "." + assignment.getValue().getId(), d, assignment);
                            int n5 = 0;
                            Enumeration enumeration8 = ((Vector)hashtable.get(assignment)).elements();
                            while (enumeration8.hasMoreElements()) {
                                boolean bl4;
                                AssignmentSet assignmentSet = (AssignmentSet)enumeration8.nextElement();
                                boolean bl5 = bl4 = assignmentSet.getSet().size() > 2;
                                if (bl4) {
                                    this.assignmentsMenuItem(printWriter, string, ((Constraint)object5).getId() + "." + assignment.getValue().variable().getId() + "." + assignment.getValue().getId() + "." + ++n5, assignmentSet);
                                }
                                Enumeration enumeration9 = ToolBox.sortEnumeration(assignmentSet.getSet().elements(), Assignment.getComparator(l));
                                while (enumeration9.hasMoreElements()) {
                                    Assignment assignment3 = (Assignment)enumeration9.nextElement();
                                    if (assignment.equals(assignment3)) continue;
                                    if (bl4) {
                                        this.assignmentLeafItem(printWriter, string, assignment3);
                                        continue;
                                    }
                                    this.assignmentLeafItem(printWriter, string, assignmentSet.getCounter(), assignment3);
                                }
                                if (!bl4) continue;
                                this.end_item(printWriter);
                            }
                            this.end_item(printWriter);
                        }
                        this.end_item(printWriter);
                    }
                    this.end_item(printWriter);
                    continue;
                }
                break;
            }
        }
        if (bl) {
            printWriter.println("</ul>");
            printWriter.println("</body></html>");
        }
    }

    public void print(PrintWriter printWriter, long l) {
        printWriter.print("Statistics{");
        Enumeration enumeration = ToolBox.sortEnumeration(this.iNoGoods.keys(), Assignment.getComparator(l));
        while (enumeration.hasMoreElements()) {
            Assignment assignment = (Assignment)enumeration.nextElement();
            double d = 0.0;
            Enumeration enumeration2 = ((Vector)this.iNoGoods.get(assignment)).elements();
            while (enumeration2.hasMoreElements()) {
                d += (double)((AssignmentSet)enumeration2.nextElement()).getCounter();
            }
            if (d < 100.0) continue;
            printWriter.print("\n      " + d + "x " + assignment.getValue().variable().getName() + " != " + assignment.getValue().getName() + " <= {");
            enumeration2 = ((Vector)this.iNoGoods.get(assignment)).elements();
            while (enumeration2.hasMoreElements()) {
                AssignmentSet assignmentSet = (AssignmentSet)enumeration2.nextElement();
                if (assignmentSet.getCounter() < 10) continue;
                printWriter.print("\n        " + assignmentSet.getCounter() + "x " + (assignmentSet.getName() == null ? null : assignmentSet.getName()) + "{");
                Enumeration enumeration3 = ToolBox.sortEnumeration(assignmentSet.getSet().elements(), Assignment.getComparator(l));
                while (enumeration3.hasMoreElements()) {
                    Assignment assignment2 = (Assignment)enumeration3.nextElement();
                    printWriter.print(assignment2.getValue().variable().getName() + " := " + assignment2.getValue().getName() + (enumeration3.hasMoreElements() ? "," : ""));
                }
                printWriter.print(enumeration2.hasMoreElements() ? "}," : "}");
            }
            printWriter.print("\n      }");
        }
        printWriter.print("\n    }");
        printWriter.flush();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Statistics{");
        Enumeration enumeration = ToolBox.sortEnumeration(this.iUnassignedVariables.keys(), Assignment.getComparator(0L));
        while (enumeration.hasMoreElements()) {
            Variable variable = (Variable)enumeration.nextElement();
            if (variable.countAssignments() < 100L) continue;
            stringBuffer.append("\n      ").append(variable.countAssignments() + "x ").append(variable.getName()).append(" <= {");
            Enumeration enumeration2 = ToolBox.sortEnumeration(((Vector)this.iUnassignedVariables.get(variable)).elements(), Assignment.getComparator(0L));
            while (enumeration2.hasMoreElements()) {
                Assignment assignment = (Assignment)enumeration2.nextElement();
                if (!(assignment.getCounter(0L) >= 10.0)) continue;
                stringBuffer.append("\n        ").append(assignment.toString(0L, true)).append(enumeration2.hasMoreElements() ? "," : "");
            }
            stringBuffer.append("\n      }");
        }
        stringBuffer.append("\n    }");
        return stringBuffer.toString();
    }

    public void getInfo(Hashtable hashtable) {
    }

    public void constraintBeforeAssigned(long l, Constraint constraint, Value value, Set set) {
    }

    public void constraintAfterAssigned(long l, Constraint constraint, Value value, Set set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        if (this.iPrint) {
            AssignmentSet assignmentSet = AssignmentSet.createAssignmentSet(l, set, this.iAgeing);
            assignmentSet.addAssignment(l, value, this.iAgeing);
            assignmentSet.setConstraint(constraint);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Value value2 = (Value)iterator.next();
                this.variableUnassigned(l, value2, assignmentSet);
                this.variableUnassigned(l, value2, value);
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Value value3 = (Value)iterator.next();
                this.variableUnassigned(l, value3, value);
            }
        }
    }

    public void constraintAdded(Constraint constraint) {
        constraint.addConstraintListener(this);
    }

    public void constraintRemoved(Constraint constraint) {
        constraint.removeConstraintListener(this);
    }

    public void solutionUpdated(Solution solution) {
        if (this.iPrint && this.iPrintInterval > 0L && solution.getIteration() % this.iPrintInterval == 0L) {
            try {
                int n = this.getProperties().getPropertyInt("ConflictStatistics.MaxLines", 25);
                int n2 = this.getProperties().getPropertyInt("ConflictStatistics.MaxBranchingLev1", 100);
                int n3 = this.getProperties().getPropertyInt("ConflictStatistics.MaxBranchingLev2", 10);
                String string = this.getProperties().getProperty("ConflictStatistics.ImageBase", null);
                if (0 == this.getProperties().getPropertyInt("ConflictStatistics.Type", 0)) {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(this.getProperties().getProperty("General.Output", ".") + File.separator + "stat" + ++this.iPrintCounter + ".html"));
                    this.printHtml(solution.getIteration(), printWriter, true, n, n2, n3, string, 0);
                    printWriter.flush();
                    printWriter.close();
                } else {
                    PrintWriter printWriter = new PrintWriter(new FileWriter(this.getProperties().getProperty("General.Output", ".") + File.separator + "stat" + ++this.iPrintCounter + ".html"));
                    this.printHtml(solution.getIteration(), printWriter, true, n, n2, n3, string, 1);
                    printWriter.flush();
                    printWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                sLogger.error((Object)exception);
            }
        }
    }

    public void getInfo(Solution solution, Dictionary dictionary) {
    }

    public void bestCleared(Solution solution) {
    }

    public void bestSaved(Solution solution) {
    }

    public void bestRestored(Solution solution) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConstraintComparator
    implements Comparator {
        Hashtable iConstrs = null;

        public ConstraintComparator(Hashtable hashtable) {
            this.iConstrs = hashtable;
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = (Long)this.iConstrs.get(object);
            if (l2 != (l = ((Long)this.iConstrs.get(object2)).longValue())) {
                return l2 < l ? 1 : -1;
            }
            return ((Constraint)object).getName().compareTo(((Constraint)object2).getName());
        }
    }

    private class VariableComparator
    implements Comparator {
        Hashtable iVars = null;

        public VariableComparator(Hashtable hashtable) {
            this.iVars = hashtable;
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = (Long)this.iVars.get(object);
            if (l2 != (l = ((Long)this.iVars.get(object2)).longValue())) {
                return l2 < l ? 1 : -1;
            }
            return ((Variable)object).getName().compareTo(((Variable)object2).getName());
        }
    }
}

