/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.tt;

import ifs.example.tt.Activity;
import ifs.example.tt.Resource;
import ifs.example.tt.TimetableModel;
import ifs.model.Value;

public class Location
extends Value {
    private int iSlot;
    private Resource[] iResources;
    private int iNrOfDiscouragedSlots = -1;

    public Location(Activity activity, int n, Resource[] resourceArray) {
        super(activity);
        this.iSlot = n;
        this.iResources = resourceArray;
        this.iNrOfDiscouragedSlots = this.computeNrOfDiscouragedSlots();
    }

    public Location(Activity activity, int n, int n2, Resource[] resourceArray) {
        super(activity);
        this.iSlot = ((TimetableModel)activity.getModel()).getNrHours() * n + n2;
        this.iResources = resourceArray;
        this.iNrOfDiscouragedSlots = this.computeNrOfDiscouragedSlots();
    }

    public int getSlot() {
        return this.iSlot;
    }

    public Resource[] getResources() {
        return this.iResources;
    }

    public Resource getResource(int n) {
        return this.iResources[n];
    }

    public boolean containResource(Resource resource) {
        for (int i = 0; i < this.iResources.length; ++i) {
            if (!this.iResources[i].equals(resource)) continue;
            return true;
        }
        return false;
    }

    public int getNrOfDiscouragedSlots() {
        return this.iNrOfDiscouragedSlots;
    }

    public int toInt() {
        return this.iNrOfDiscouragedSlots;
    }

    public int computeNrOfDiscouragedSlots() {
        Activity activity = (Activity)this.variable();
        int n = 0;
        for (int i = this.getSlot(); i < this.getSlot() + activity.getLength(); ++i) {
            if (activity.isDiscouragedSlot(i)) {
                ++n;
            }
            for (int j = 0; j < this.getResources().length; ++j) {
                if (!this.getResource(j).isDiscouragedSlot(i)) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean hasIntersection(Location location) {
        int n = this.getSlot();
        int n2 = ((Activity)this.variable()).getLength();
        int n3 = location.getSlot();
        int n4 = ((Activity)location.variable()).getLength();
        return n + n2 > n3 && n3 + n4 > n;
    }

    public boolean isProhibited() {
        Activity activity = (Activity)this.variable();
        for (int i = this.getSlot(); i < this.getSlot() + activity.getLength(); ++i) {
            if (activity.isProhibitedSlot(i)) {
                return true;
            }
            for (int j = 0; j < this.getResources().length; ++j) {
                if (!this.getResource(j).isProhibitedSlot(i)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer(this.getSlot() + "/");
        for (int i = 0; i < this.iResources.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.iResources[i].getName());
        }
        return stringBuffer.toString();
    }
}

