/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.tt;

import ifs.example.tt.Activity;
import ifs.example.tt.Location;
import ifs.model.BinaryConstraint;
import ifs.model.Value;
import java.util.Set;

public class Dependence
extends BinaryConstraint {
    public static final int TYPE_NO_DEPENDENCE = 0;
    public static final int TYPE_BEFORE = 1;
    public static final int TYPE_CLOSELY_BEFORE = 2;
    public static final int TYPE_AFTER = 3;
    public static final int TYPE_CLOSELY_AFTER = 4;
    public static final int TYPE_CONCURRENCY = 5;
    private int iType = 0;
    private String iResourceId = null;

    public Dependence(String string, int n) {
        this.iType = n;
        this.iResourceId = string;
    }

    public int getType() {
        return this.iType;
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    public void computeConflicts(Value value, Set set) {
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        Activity activity2 = (Activity)this.another(activity);
        Location location2 = (Location)activity2.getAssignment();
        if (location2 == null) {
            return;
        }
        if (this.isFirst(activity)) {
            if (!this.isConsistent(location.getSlot(), activity.getLength(), location2.getSlot(), activity2.getLength())) {
                set.add(location2);
            }
        } else if (!this.isConsistent(location2.getSlot(), activity2.getLength(), location.getSlot(), activity.getLength())) {
            set.add(location2);
        }
    }

    public boolean isConsistent(int n, int n2, int n3, int n4) {
        switch (this.iType) {
            case 1: {
                return n + n2 <= n3;
            }
            case 2: {
                return n + n2 == n3;
            }
            case 3: {
                return n3 + n4 <= n;
            }
            case 4: {
                return n3 + n4 == n;
            }
            case 5: {
                return n <= n3 && n3 + n4 <= n + n2 || n3 <= n && n + n2 <= n3 + n4;
            }
        }
        return true;
    }

    public boolean inConflict(Value value) {
        Activity activity = (Activity)value.variable();
        Location location = (Location)value;
        Activity activity2 = (Activity)this.another(activity);
        Location location2 = (Location)activity2.getAssignment();
        if (location2 == null) {
            return false;
        }
        if (this.isFirst(activity)) {
            return !this.isConsistent(location.getSlot(), activity.getLength(), location2.getSlot(), activity2.getLength());
        }
        return !this.isConsistent(location2.getSlot(), activity2.getLength(), location.getSlot(), activity.getLength());
    }

    public boolean isConsistent(Value value, Value value2) {
        Activity activity = (Activity)value.variable();
        Activity activity2 = (Activity)value2.variable();
        Location location = (Location)value;
        Location location2 = (Location)value2;
        if (this.isFirst(activity)) {
            return !this.isConsistent(location.getSlot(), activity.getLength(), location2.getSlot(), activity2.getLength());
        }
        return !this.isConsistent(location2.getSlot(), activity2.getLength(), location.getSlot(), activity.getLength());
    }

    public String getName() {
        switch (this.iType) {
            case 1: {
                return this.first().getName() + "<" + this.second().getName();
            }
            case 2: {
                return this.first().getName() + "<|" + this.second().getName();
            }
            case 3: {
                return this.first().getName() + ">" + this.second().getName();
            }
            case 4: {
                return this.first().getName() + "|>" + this.second().getName();
            }
            case 5: {
                return this.first().getName() + "||" + this.second().getName();
            }
        }
        return this.first().getName() + "?" + this.second().getName();
    }
}

