/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.jobshop;

import ifs.example.jobshop.JobShopModel;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.Progress;
import ifs.util.ProgressWriter;
import ifs.util.ToolBox;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Test {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$jobshop$Test == null ? (class$ifs$example$jobshop$Test = Test.class$("ifs.example.jobshop.Test")) : class$ifs$example$jobshop$Test));
    static /* synthetic */ Class class$ifs$example$jobshop$Test;

    public static void test(DataProperties dataProperties) {
        try {
            String string = dataProperties.getProperty("General.Input");
            JobShopModel jobShopModel = JobShopModel.loadModel(string);
            Solver solver = new Solver(dataProperties);
            solver.setInitalSolution(jobShopModel);
            solver.start();
            solver.getSolverThread().join();
            Solution solution = solver.currentSolution();
            solution.restoreBest();
            sLogger.info((Object)("Best solution info:" + solution.getInfo()));
            sLogger.info((Object)("Best solution:" + jobShopModel.toString()));
            jobShopModel.save(dataProperties.getProperty("General.Output") + File.separator + "solution.txt");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File file = new File(stringArray[0]);
            DataProperties dataProperties = ToolBox.loadProperties(file);
            String string = dataProperties.getProperty("General.Output", ".") + File.separator + file.getName().substring(0, file.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
            new File(string).mkdirs();
            dataProperties.setProperty("General.Output", string.toString());
            ToolBox.configureLogging(string, null);
            Test.test(dataProperties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

