/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.jobshop;

import ifs.example.jobshop.Job;
import ifs.example.jobshop.JobShopModel;
import ifs.example.jobshop.Location;
import ifs.example.jobshop.Machine;
import ifs.model.Variable;
import java.util.Vector;

public class Operation
extends Variable {
    private Job iJob = null;
    private Machine iMachine = null;
    private int iProcessingTime = 0;
    private int iOperationNumber = 0;

    public Operation(Job job, Machine machine, int n, int n2) {
        super(null);
        this.iJob = job;
        this.iMachine = machine;
        this.iProcessingTime = n2;
        this.iOperationNumber = n;
    }

    public Job getJob() {
        return this.iJob;
    }

    public int getJobNumber() {
        return this.iJob.getJobNumner();
    }

    public int getOperationNumber() {
        return this.iOperationNumber;
    }

    public Machine getMachine() {
        return this.iMachine;
    }

    public int getMachineNumber() {
        return this.iMachine.getMachineNumber();
    }

    public int getProcessingTime() {
        return this.iProcessingTime;
    }

    public Operation getPrecedingOperation() {
        return this.iOperationNumber == 0 ? null : this.iJob.getOperation(this.iOperationNumber - 1);
    }

    public Operation getSubsequentOperation() {
        return this.iOperationNumber + 1 == this.iJob.countOperations() ? null : this.iJob.getOperation(this.iOperationNumber + 1);
    }

    public int getMinStartTime() {
        if (this.iOperationNumber == 0) {
            return 0;
        }
        return this.getPrecedingOperation().getMinStartTime() + this.iProcessingTime;
    }

    public int getMaxStartTime() {
        if (this.iOperationNumber + 1 == this.iJob.countOperations()) {
            return ((JobShopModel)this.getModel()).getTotalNumberOfSlots() - this.iProcessingTime;
        }
        return this.getSubsequentOperation().getMaxStartTime() - this.iProcessingTime;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)object;
        return this.getJobNumber() == operation.getJobNumber() && this.getOperationNumber() == operation.getOperationNumber();
    }

    public void init() {
        this.setValues(this.computeValues());
    }

    private Vector computeValues() {
        Vector<Location> vector = new Vector<Location>();
        for (int i = this.getMinStartTime(); i <= this.getMaxStartTime(); ++i) {
            vector.addElement(new Location(this, i));
        }
        return vector;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return "O[" + this.getJobNumber() + "," + this.getOperationNumber() + "]";
    }
}

