/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.jobshop;

import ifs.example.jobshop.Job;
import ifs.example.jobshop.Location;
import ifs.example.jobshop.Machine;
import ifs.example.jobshop.Operation;
import ifs.model.Constraint;
import ifs.model.Model;
import ifs.util.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JobShopModel
extends Model {
    private int iTotalNumberOfSlots = 1250;
    private Machine[] iMachines;
    private Job[] iJobs;

    public JobShopModel(int n, int n2) {
        this.iMachines = new Machine[n];
        this.iJobs = new Job[n2];
    }

    public int getTotalNumberOfSlots() {
        return this.iTotalNumberOfSlots;
    }

    public Machine getMachine(int n) {
        return this.iMachines[n];
    }

    public int countMachines() {
        return this.iMachines.length;
    }

    public Job getJob(int n) {
        return this.iJobs[n];
    }

    public int countJobs() {
        return this.iJobs.length;
    }

    private void setJob(int n, Job job) {
        this.iJobs[n] = job;
    }

    private void setMachine(int n, Machine machine) {
        this.iMachines[n] = machine;
    }

    public static JobShopModel loadModel(String string) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2.startsWith("#")) {
            string2 = bufferedReader.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        JobShopModel jobShopModel = new JobShopModel(n3, n2);
        Machine[] machineArray = new Machine[n3];
        for (n = 0; n < n3; ++n) {
            machineArray[n] = new Machine(n);
            jobShopModel.addConstraint(machineArray[n]);
            jobShopModel.setMachine(n, machineArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            Job job = new Job(n);
            jobShopModel.addConstraint(job);
            jobShopModel.setJob(n, job);
            string2 = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string2, " ");
            for (int i = 0; i < n3; ++i) {
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                Operation operation = new Operation(job, machineArray[n4], i, n5);
                jobShopModel.addVariable(operation);
                job.addVariable(operation);
                machineArray[n4].addVariable(operation);
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            job.setDueTime(Integer.parseInt(stringTokenizer.nextToken()));
        }
        bufferedReader.close();
        Enumeration enumeration = jobShopModel.variables().elements();
        while (enumeration.hasMoreElements()) {
            ((Operation)enumeration.nextElement()).init();
        }
        return jobShopModel;
    }

    public int getFinishingTime() {
        int n = 0;
        Enumeration enumeration = this.assignedVariables().elements();
        while (enumeration.hasMoreElements()) {
            n = Math.max(n, ((Location)((Operation)enumeration.nextElement()).getAssignment()).getFinishingTime());
        }
        return n;
    }

    public Hashtable getInfo() {
        Hashtable hashtable = super.getInfo();
        hashtable.put("Finishing time", String.valueOf(this.getFinishingTime()));
        return hashtable;
    }

    public void save(String string) throws IOException {
        Operation operation;
        Enumeration<Object> enumeration;
        Object object;
        Object object2;
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        for (int i = 0; i < this.countMachines(); ++i) {
            object2 = this.getMachine(i);
            object = (Vector)((Constraint)object2).variables().clone();
            Collections.sort(object, new OperationComparator());
            enumeration = ((Vector)object).elements();
            while (enumeration.hasMoreElements()) {
                operation = (Operation)enumeration.nextElement();
                if (operation.getAssignment() == null) continue;
                printWriter.print((operation.getJobNumber() < 10 ? " " : "") + operation.getJobNumber() + " ");
            }
            printWriter.println();
        }
        printWriter.println(";");
        Hashtable hashtable = this.getInfo();
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            enumeration = hashtable.get(object);
            printWriter.println("; " + object + ": " + enumeration);
        }
        printWriter.println(";");
        for (int i = 0; i < this.countJobs(); ++i) {
            object = this.getJob(i);
            printWriter.print("; ");
            enumeration = ((Constraint)object).variables().elements();
            while (enumeration.hasMoreElements()) {
                operation = (Operation)enumeration.nextElement();
                Location location = (Location)operation.getAssignment();
                printWriter.print((location == null ? "----" : ToolBox.trim(String.valueOf(location.getStartTime()), 4)) + " ");
            }
            printWriter.println();
        }
        printWriter.flush();
        printWriter.close();
    }

    private static class OperationComparator
    implements Comparator {
        private OperationComparator() {
        }

        public int compare(Object object, Object object2) {
            Operation operation = (Operation)object;
            Operation operation2 = (Operation)object2;
            Location location = (Location)operation.getAssignment();
            Location location2 = (Location)operation2.getAssignment();
            if (location == null) {
                if (location2 == null) {
                    return 0;
                }
                return -1;
            }
            if (location2 == null) {
                return 1;
            }
            return location.getStartTime() < location2.getStartTime() ? -1 : (location.getStartTime() == location2.getStartTime() ? 0 : 1);
        }
    }
}

