/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.jobshop;

import ifs.example.jobshop.Location;
import ifs.example.jobshop.Operation;
import ifs.model.Constraint;
import ifs.model.Value;
import java.util.Enumeration;
import java.util.Set;

public class Job
extends Constraint {
    private int iJobNumber = 0;
    private int iDueTime = -1;

    public Job(int n) {
        this.iJobNumber = n;
    }

    public void setDueTime(int n) {
        this.iDueTime = n;
    }

    public int getDueTime() {
        return this.iDueTime;
    }

    public int getJobNumner() {
        return this.iJobNumber;
    }

    public int countOperations() {
        return this.variables().size();
    }

    public Operation getOperation(int n) {
        return (Operation)this.variables().get(n);
    }

    public void computeConflicts(Value value, Set set) {
        Location location = (Location)value;
        Operation operation = (Operation)value.variable();
        Enumeration enumeration = this.assignedVariables().elements();
        while (enumeration.hasMoreElements()) {
            Operation operation2 = (Operation)enumeration.nextElement();
            if (operation2.getOperationNumber() == operation.getOperationNumber()) continue;
            Location location2 = (Location)operation2.getAssignment();
            if (operation2.getOperationNumber() < operation.getOperationNumber()) {
                if (location2.before(location)) continue;
                set.add(location2);
                continue;
            }
            if (location2.after(location)) continue;
            set.add(location2);
        }
    }

    public boolean inConflict(Value value) {
        Location location = (Location)value;
        Operation operation = (Operation)value.variable();
        Enumeration enumeration = this.assignedVariables().elements();
        while (enumeration.hasMoreElements()) {
            Operation operation2 = (Operation)enumeration.nextElement();
            if (operation2.getOperationNumber() == operation.getOperationNumber()) continue;
            Location location2 = (Location)operation2.getAssignment();
            if (!(operation2.getOperationNumber() < operation.getOperationNumber() ? !location2.before(location) : !location2.after(location))) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(Value value, Value value2) {
        Location location = (Location)value;
        Operation operation = (Operation)value.variable();
        Location location2 = (Location)value2;
        Operation operation2 = (Operation)value2.variable();
        return operation.getOperationNumber() < operation2.getOperationNumber() ? location.before(location2) : location2.before(location);
    }

    public String toString() {
        return "J" + this.iJobNumber;
    }

    public String getName() {
        return "J" + this.iJobNumber;
    }
}

