/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.csp;

import ifs.example.csp.CSPBinaryConstraint;
import ifs.example.csp.CSPVariable;
import ifs.example.csp.StructuredCSPModel;
import ifs.model.BinaryConstraint;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.Progress;
import ifs.util.ProgressWriter;
import ifs.util.ToolBox;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Test {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$csp$Test == null ? (class$ifs$example$csp$Test = Test.class$("ifs.example.csp.Test")) : class$ifs$example$csp$Test));
    static /* synthetic */ Class class$ifs$example$csp$Test;

    private static void test(DataProperties dataProperties) throws Exception {
        boolean bl = dataProperties.getPropertyBoolean("CSP.SameProblemEachStep", false);
        boolean bl2 = dataProperties.getPropertyBoolean("CSP.SameProblemEachTest", false);
        int n = dataProperties.getPropertyInt("CSP.NrVariables", 20);
        int n2 = dataProperties.getPropertyInt("CSP.NrKernels", 2);
        int n3 = dataProperties.getPropertyInt("CSP.KernelSize", 8);
        int n4 = dataProperties.getPropertyInt("CSP.NrVariablesMin", n);
        int n5 = dataProperties.getPropertyInt("CSP.NrVariablesMax", n);
        int n6 = dataProperties.getPropertyInt("CSP.NrVariablesStep", 1);
        int n7 = dataProperties.getPropertyInt("CSP.DomainSize", 10);
        double d = dataProperties.getPropertyDouble("CSP.DomainSizeRatio", -1.0);
        float f = dataProperties.getPropertyFloat("CSP.KernelTightness", 0.097f);
        float f2 = dataProperties.getPropertyFloat("CSP.KernelDensity", 0.097f);
        float f3 = dataProperties.getPropertyFloat("CSP.Tightness", 0.4f);
        float f4 = dataProperties.getPropertyFloat("CSP.TightnessMin", f3);
        float f5 = dataProperties.getPropertyFloat("CSP.TightnessMax", f3) + 1.0E-6f;
        float f6 = dataProperties.getPropertyFloat("CSP.TightnessStep", 0.1f);
        float f7 = dataProperties.getPropertyFloat("CSP.Density", 0.4f);
        float f8 = dataProperties.getPropertyFloat("CSP.DensityMin", f7);
        float f9 = dataProperties.getPropertyFloat("CSP.DensityMax", f7) + 1.0E-6f;
        float f10 = dataProperties.getPropertyFloat("CSP.DensityStep", 0.1f);
        long l = dataProperties.getPropertyLong("CSP.Seed", System.currentTimeMillis());
        int n8 = dataProperties.getPropertyInt("CPS.NrTests", 10);
        boolean bl3 = dataProperties.getPropertyBoolean("General.MPP", false);
        boolean bl4 = dataProperties.getPropertyBoolean("CSP.ForceSolutionExistance", false);
        PrintWriter printWriter = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "rcsp_" + n4 + "_" + n7 + ".csv"));
        PrintWriter printWriter2 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "avg_stat.csv"));
        PrintWriter printWriter3 = new PrintWriter(new FileWriter(dataProperties.getProperty("General.Output") + File.separator + "info.txt"));
        printWriter.println("testNr;nrVars;nrVals;density[%];tightness[%];time[s];iters;speed[it/s];unassConstr;assigned;assigned[%]" + (bl3 ? ";perts;perts[%]" : "") + ";value;totalValue");
        printWriter2.println("nrVars;nrVals;density[%];tightness[%];time[s];RMStime[s];iters;RMSiters;speed[it/s];unassConst;assigned;RMSassigned;assigned[%]" + (bl3 ? ";perts;RMSperts;perts[%]" : "") + ";value;RMSvalue;totalValue;RMStotalValue");
        System.out.println("Number of variables: " + n4 + " .. " + n5 + "  (step=" + n6 + ")");
        System.out.println("Density:             " + f8 + " .. " + f9 + "  (step=" + f10 + ")");
        System.out.println("Tightness:           " + f4 + " .. " + f5 + "  (step=" + f6 + ")");
        for (int i = n4; i <= n5; i += n6) {
            if (d > 0.0) {
                n7 = (int)Math.round(d * (double)i);
            }
            for (float f11 = f8; f11 <= f9; f11 += f10) {
                for (float f12 = f4; f12 <= f5; f12 += f6) {
                    printWriter3.println("CSP{#Var=" + i + ", #Val=" + n7 + ", P(density)=" + sDoubleFormat.format(100.0 * (double)f11) + "%, P(tighness)=" + sDoubleFormat.format(100.0 * (double)f12) + ", " + n2 + "x Kernel{#Var=" + n3 + ", P(density)=" + sDoubleFormat.format(100.0 * (double)f2) + "%, P(tighness)=" + sDoubleFormat.format(100.0 * (double)f) + "%}}");
                    double d2 = 0.0;
                    double d3 = 0.0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    for (int j = 1; j <= n8; ++j) {
                        Object object;
                        printWriter3.println("  " + j + ". test");
                        printWriter3.flush();
                        dataProperties.setProperty("CSP.NrVariables", String.valueOf(i));
                        dataProperties.setProperty("CSP.Tightness", String.valueOf(f12));
                        dataProperties.setProperty("CSP.Density", String.valueOf(f11));
                        long l2 = l * 1000000L + 1000L * (long)((double)(bl ? f8 : f11) * 1000.0) + (long)((double)(bl ? f4 : f12) * 1000.0);
                        l2 = l2 * (long)n8 + (long)(bl2 ? 0 : j - 1);
                        sLogger.debug((Object)("Seed: " + l2));
                        StructuredCSPModel structuredCSPModel = new StructuredCSPModel(dataProperties, l2);
                        Solver solver = new Solver(dataProperties);
                        solver.setInitalSolution(structuredCSPModel);
                        solver.currentSolution().clearBest();
                        solver.start();
                        try {
                            solver.getSolverThread().join();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        if (solver.lastSolution().getBestInfo() == null) {
                            sLogger.error((Object)"No solution found :-(");
                        }
                        sLogger.debug((Object)("Last solution:" + solver.lastSolution().getInfo()));
                        Solution solution = solver.lastSolution();
                        sLogger.debug((Object)("Best solution:" + solver.lastSolution().getBestInfo()));
                        solution.restoreBest();
                        int n20 = 0;
                        Enumeration enumeration = solution.getModel().assignedVariables().elements();
                        while (enumeration.hasMoreElements()) {
                            n20 += ((Variable)enumeration.nextElement()).getAssignment().toInt();
                        }
                        int n21 = n20 + solution.getModel().unassignedVariables().size() * n7;
                        sLogger.debug((Object)("Last solution:" + solution.getInfo()));
                        printWriter.println(j + ";" + i + ";" + n7 + ";" + sDoubleFormat.format(f11) + ";" + sDoubleFormat.format(f12) + ";" + sDoubleFormat.format(solution.getTime()) + ";" + solution.getIteration() + ";" + sDoubleFormat.format((double)solution.getIteration() / solution.getTime()) + ";" + solution.getModel().unassignedHardConstraints().size() + ";" + solution.getModel().assignedVariables().size() + ";" + sDoubleFormat.format(100.0 * (double)solution.getModel().assignedVariables().size() / (double)solution.getModel().variables().size()) + (bl3 ? ";" + (solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) + ";" + sDoubleFormat.format(100.0 * (double)(solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) / (double)solution.getModel().variables().size()) : "") + ";" + n20 + ";" + n21);
                        printWriter3.println("    seed:         " + l2);
                        printWriter3.println("    constraints:  " + solution.getModel().constraints().size());
                        Enumeration enumeration2 = solution.getModel().constraints().elements();
                        while (enumeration2.hasMoreElements()) {
                            object = (CSPBinaryConstraint)enumeration2.nextElement();
                            printWriter3.println("      " + ((CSPBinaryConstraint)object).getName() + " (" + ((BinaryConstraint)object).first().getName() + "," + ((BinaryConstraint)object).second().getName() + ")");
                            Enumeration enumeration3 = ((BinaryConstraint)object).first().values().elements();
                            while (enumeration3.hasMoreElements()) {
                                Value value = (Value)enumeration3.nextElement();
                                printWriter3.print("        ");
                                Enumeration enumeration4 = ((BinaryConstraint)object).second().values().elements();
                                while (enumeration4.hasMoreElements()) {
                                    Value value2 = (Value)enumeration4.nextElement();
                                    printWriter3.print(((CSPBinaryConstraint)object).isConsistent(value, value2) ? "1 " : "0 ");
                                }
                                printWriter3.println();
                            }
                        }
                        printWriter3.println("    time:         " + sDoubleFormat.format(solution.getTime()) + " s");
                        printWriter3.println("    iteration:    " + solution.getIteration());
                        printWriter3.println("    speed:        " + sDoubleFormat.format((double)solution.getIteration() / solution.getTime()) + " it/s");
                        printWriter3.println("    assigned:     " + solution.getModel().assignedVariables().size() + " (" + sDoubleFormat.format(100.0 * (double)solution.getModel().assignedVariables().size() / (double)solution.getModel().variables().size()) + "%)");
                        printWriter3.println("    total value:  " + n20);
                        if (bl3) {
                            printWriter3.println("    perturbations:" + (solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) + " (" + sDoubleFormat.format(100.0 * (double)(solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) / (double)solution.getModel().variables().size()) + "%)");
                        }
                        printWriter3.print("    solution:     ");
                        enumeration2 = solution.getModel().variables().elements();
                        while (enumeration2.hasMoreElements()) {
                            object = (CSPVariable)enumeration2.nextElement();
                            if (((Variable)object).getBestAssignment() == null) continue;
                            printWriter3.print(((CSPVariable)object).getName() + "=" + ((Variable)object).getBestAssignment().getName());
                            if (!enumeration2.hasMoreElements()) continue;
                            printWriter3.print(", ");
                        }
                        printWriter3.println();
                        d2 += solution.getTime();
                        d3 += solution.getTime() * solution.getTime();
                        n9 = (int)((long)n9 + solution.getIteration());
                        n10 = (int)((long)n10 + solution.getIteration() * solution.getIteration());
                        n11 += solution.getModel().unassignedHardConstraints().size();
                        n12 += solution.getModel().assignedVariables().size();
                        n13 += solution.getModel().assignedVariables().size() * solution.getModel().assignedVariables().size();
                        d4 += 100.0 * ((double)solution.getModel().assignedVariables().size() / (double)solution.getModel().variables().size());
                        n16 += n20;
                        n17 += n20 * n20;
                        n18 += n21;
                        n19 += n21 * n21;
                        if (bl3) {
                            n14 += solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size();
                            n15 += (solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) * (solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size());
                            d5 += 100.0 * (double)(solution.getModel().perturbVariables().size() + solution.getModel().unassignedVariables().size()) / (double)solution.getModel().variables().size();
                        }
                        printWriter3.flush();
                        printWriter.flush();
                    }
                    printWriter2.println(i + ";" + n7 + ";" + sDoubleFormat.format(f11) + ";" + sDoubleFormat.format(f12) + ";" + sDoubleFormat.format(d2 / (double)n8) + ";" + sDoubleFormat.format(ToolBox.rms(n8, d2, d3)) + ";" + sDoubleFormat.format((double)n9 / (double)n8) + ";" + sDoubleFormat.format(ToolBox.rms(n8, n9, n10)) + ";" + sDoubleFormat.format((double)n9 / d2) + ";" + sDoubleFormat.format((double)n11 / (double)n8) + ";" + sDoubleFormat.format((double)n12 / (double)n8) + ";" + sDoubleFormat.format(ToolBox.rms(n8, n12, n13)) + ";" + sDoubleFormat.format(100.0 * (double)n12 / (double)(i * n8)) + (bl3 ? ";" + sDoubleFormat.format((double)n14 / (double)n8) + ";" + sDoubleFormat.format(ToolBox.rms(n8, n14, n15)) + ";" + sDoubleFormat.format(100.0 * (double)n14 / (double)(i * n8)) : "") + ";" + sDoubleFormat.format((double)n16 / (double)(n8 * i)) + ";" + sDoubleFormat.format(ToolBox.rms(n8, (double)n16 / (double)i, (double)n17 / (double)(i * i))) + ";" + sDoubleFormat.format((double)n18 / (double)n8) + ";" + sDoubleFormat.format(ToolBox.rms(n8, n18, n19)));
                    printWriter2.flush();
                }
            }
        }
        printWriter3.flush();
        printWriter3.close();
        printWriter.flush();
        printWriter.close();
        printWriter2.flush();
        printWriter2.close();
    }

    private static void test(File file, String string, String string2, String string3, String string4) throws Exception {
        if (string3 != null) {
            String string5;
            if (string3.indexOf(59) > 0) {
                string5 = string3.substring(0, string3.indexOf(59));
                string3 = string3.substring(string3.indexOf(59) + 1);
            } else {
                string5 = string3;
                string3 = null;
            }
            if (string5.startsWith("[") && string5.endsWith("]")) {
                Test.test(file, string, string2, string3, string4);
                string5 = string5.substring(1, string5.length() - 1);
            }
            if (string5.indexOf(123) >= 0 && string5.indexOf(125) >= 0) {
                String string6 = string5.substring(0, string5.indexOf(123));
                StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(string5.indexOf(123) + 1, string5.indexOf(125)), "|");
                String string7 = string5.substring(string5.indexOf(125) + 1);
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    Test.test(file, (string == null ? "" : string + "_") + string8, (string2 == null ? "" : string2 + ";") + string6 + string8 + string7, string3, string4);
                }
            } else {
                Test.test(file, string, (string2 == null ? "" : string2 + ";") + string5, string3, string4);
            }
        } else {
            Closeable closeable;
            String string9;
            DataProperties dataProperties = ToolBox.loadProperties(file);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                string9 = stringTokenizer.nextToken();
                System.out.println("  Loading included file '" + string9 + "' ... ");
                closeable = null;
                if (new File(string9).exists()) {
                    closeable = new FileInputStream(string9);
                }
                if (new File(file.getParent() + File.separator + string9).exists()) {
                    closeable = new FileInputStream(file.getParent() + File.separator + string9);
                }
                if (closeable == null) {
                    System.err.println("Unable to find include file '" + string9 + "'.");
                }
                dataProperties.load((InputStream)closeable);
                ((FileInputStream)closeable).close();
            }
            string9 = (string4 == null ? dataProperties.getProperty("General.Output", ".") : string4) + File.separator + string + File.separator + sDateFormat.format(new Date());
            dataProperties.setProperty("General.Output", string9.toString());
            System.out.println("Output folder: " + dataProperties.getProperty("General.Output"));
            new File(string9).mkdirs();
            ToolBox.configureLogging(string9, null);
            closeable = new FileOutputStream(string9 + File.separator + "rcsp.conf");
            dataProperties.store((OutputStream)closeable, "Random CSP problem configuration file");
            ((OutputStream)closeable).flush();
            ((FileOutputStream)closeable).close();
            Test.test(dataProperties);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File file = new File(stringArray[0]);
            DataProperties dataProperties = ToolBox.loadProperties(file);
            if (dataProperties.getProperty("INCLUDE_REGEXP") != null) {
                Test.test(file, null, null, dataProperties.getProperty("INCLUDE_REGEXP"), stringArray.length > 1 ? stringArray[1] : null);
            } else {
                String string = dataProperties.getProperty("General.Output", ".") + File.separator + file.getName().substring(0, file.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
                if (stringArray.length > 1) {
                    string = stringArray[1] + File.separator + sDateFormat.format(new Date());
                }
                dataProperties.setProperty("General.Output", string.toString());
                System.out.println("Output folder: " + dataProperties.getProperty("General.Output"));
                new File(string).mkdirs();
                ToolBox.configureLogging(string, null);
                Test.test(dataProperties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

