/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.csp;

import ifs.example.csp.CSPBinaryConstraint;
import ifs.example.csp.CSPVariable;
import ifs.model.BinaryConstraint;
import ifs.model.Model;
import ifs.model.Variable;
import ifs.util.DataProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StructuredCSPModel
extends Model {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$example$csp$StructuredCSPModel == null ? (class$ifs$example$csp$StructuredCSPModel = StructuredCSPModel.class$("ifs.example.csp.StructuredCSPModel")) : class$ifs$example$csp$StructuredCSPModel));
    private DataProperties iProperties = null;
    static /* synthetic */ Class class$ifs$example$csp$StructuredCSPModel;

    public StructuredCSPModel(DataProperties dataProperties, long l) {
        this.iProperties = dataProperties;
        this.generate(l);
    }

    private void swap(Variable[][] variableArray, int n, int n2) {
        Variable[] variableArray2 = variableArray[n];
        variableArray[n] = variableArray[n2];
        variableArray[n2] = variableArray2;
    }

    private void buildBinaryConstraintGraph(Vector vector, Vector vector2, Random random) {
        Object object;
        int n = vector.size() * (vector.size() - 1) / 2;
        Variable[][] variableArray = new Variable[n][];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Variable)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Variable variable = (Variable)enumeration2.nextElement();
                if (((Variable)object).getId() >= variable.getId()) continue;
                variableArray[n2++] = new Variable[]{object, variable};
            }
        }
        n2 = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPBinaryConstraint)enumeration.nextElement();
            this.swap(variableArray, n2, n2 + (int)(random.nextDouble() * (double)(n - n2)));
            ++n2;
        }
        n2 = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPBinaryConstraint)enumeration.nextElement();
            ((BinaryConstraint)object).addVariable(variableArray[n2][0]);
            ((BinaryConstraint)object).addVariable(variableArray[n2][1]);
            ++n2;
        }
    }

    private void buildBinaryConstraintGraph2(Vector vector, int n, Vector vector2, Random random) {
        Object object;
        Variable[][] variableArray = new Variable[n][];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPVariable)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                CSPVariable cSPVariable = (CSPVariable)enumeration2.nextElement();
                if (((Variable)object).getId() >= cSPVariable.getId() || ((CSPVariable)object).getKernelId() >= 0 && ((CSPVariable)object).getKernelId() == cSPVariable.getKernelId()) continue;
                variableArray[n2++] = new Variable[]{object, cSPVariable};
            }
        }
        n2 = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPBinaryConstraint)enumeration.nextElement();
            this.swap(variableArray, n2, n2 + (int)(random.nextDouble() * (double)(n - n2)));
            ++n2;
        }
        n2 = 0;
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPBinaryConstraint)enumeration.nextElement();
            ((BinaryConstraint)object).addVariable(variableArray[n2][0]);
            ((BinaryConstraint)object).addVariable(variableArray[n2][1]);
            ++n2;
        }
    }

    private void generate(long l) {
        int n;
        int n2;
        int n3 = this.iProperties.getPropertyInt("CSP.NrVariables", 60);
        int n4 = this.iProperties.getPropertyInt("CSP.DomainSize", 15);
        int n5 = this.iProperties.getPropertyInt("CSP.NrKernels", 2);
        int n6 = this.iProperties.getPropertyInt("CSP.KernelSize", 8);
        int n7 = n4 * n4;
        float f = this.iProperties.getPropertyFloat("CSP.Tightness", 0.01f);
        float f2 = this.iProperties.getPropertyFloat("CSP.KernelTightness", 0.097f);
        int n8 = (int)Math.round((1.0 - (double)f) * (double)n7);
        int n9 = (int)Math.round((1.0 - (double)f2) * (double)n7);
        int n10 = n3 * (n3 - 1) / 2;
        int n11 = n6 * (n6 - 1) / 2;
        float f3 = this.iProperties.getPropertyFloat("CSP.Density", 0.01f);
        float f4 = this.iProperties.getPropertyFloat("CSP.KernelDensity", 0.097f);
        int n12 = Math.round(f3 * (float)(n10 -= n5 * n11));
        int n13 = Math.round(f4 * (float)n11);
        Random random = new Random(l);
        Vector<CSPVariable> vector = new Vector<CSPVariable>(n3 - n5 * n6);
        int n14 = 1;
        for (int i = 0; i < n3 - n5 * n6; ++i) {
            CSPVariable cSPVariable = new CSPVariable(n14++, n4);
            vector.addElement(cSPVariable);
            this.addVariable(cSPVariable);
        }
        sLogger.debug((Object)("Created " + vector.size() + " general variables."));
        Vector[] vectorArray = new Vector[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            vectorArray[n2] = new Vector(n6);
            for (int i = 0; i < n6; ++i) {
                CSPVariable cSPVariable = new CSPVariable(n14++, n4, n2);
                vectorArray[n2].addElement(cSPVariable);
                this.addVariable(cSPVariable);
            }
            if (n2 != 0) continue;
            sLogger.debug((Object)("Created " + vectorArray[0].size() + " kernel variables (per kernel)."));
        }
        sLogger.debug((Object)("Created " + this.variables().size() + " variables at total."));
        n2 = 1;
        Vector<CSPBinaryConstraint> vector2 = new Vector<CSPBinaryConstraint>(n12);
        for (int i = 0; i < n12; ++i) {
            CSPBinaryConstraint cSPBinaryConstraint = new CSPBinaryConstraint(n2++, n8);
            vector2.addElement(cSPBinaryConstraint);
            this.addConstraint(cSPBinaryConstraint);
        }
        sLogger.debug((Object)("Created " + vector2.size() + " general constraints (tightness=" + f + ")."));
        Vector[] vectorArray2 = new Vector[n5];
        for (n = 0; n < n5; ++n) {
            vectorArray2[n] = new Vector(n13);
            for (int i = 0; i < n13; ++i) {
                CSPBinaryConstraint cSPBinaryConstraint = new CSPBinaryConstraint(n2++, n9);
                vectorArray2[n].addElement(cSPBinaryConstraint);
                this.addConstraint(cSPBinaryConstraint);
            }
            if (n != 0) continue;
            sLogger.debug((Object)("Created " + vectorArray2[0].size() + " kernel constraints (per kernel, tightness=" + f2 + ")."));
        }
        sLogger.debug((Object)("Created " + this.constraints().size() + " constraints at total."));
        for (n = 0; n < n5; ++n) {
            this.buildBinaryConstraintGraph(vectorArray[n], vectorArray2[n], random);
        }
        this.buildBinaryConstraintGraph2(this.variables(), n10, vector2, random);
        Enumeration enumeration = this.constraints().elements();
        while (enumeration.hasMoreElements()) {
            CSPBinaryConstraint cSPBinaryConstraint = (CSPBinaryConstraint)enumeration.nextElement();
            cSPBinaryConstraint.init(random);
        }
        if (this.iProperties.getPropertyBoolean("General.MPP", false)) {
            enumeration = this.variables().elements();
            while (enumeration.hasMoreElements()) {
                CSPVariable cSPVariable = (CSPVariable)enumeration.nextElement();
                cSPVariable.generateInitialValue(random);
            }
        }
    }

    public Hashtable getInfo() {
        Hashtable hashtable = super.getInfo();
        hashtable.put("Solution value", String.valueOf(this.getTotalValue()));
        return hashtable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

