/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.csp;

import ifs.example.csp.CSPBinaryConstraint;
import ifs.example.csp.CSPVariable;
import ifs.model.BinaryConstraint;
import ifs.model.Constraint;
import ifs.model.Model;
import ifs.model.Variable;
import java.util.Enumeration;
import java.util.Random;

public class CSPModel
extends Model {
    public CSPModel(int n, int n2, int n3, int n4, long l) {
        this.generate(n, n2, n3, n4, l);
    }

    private void swap(Variable[][] variableArray, int n, int n2) {
        Variable[] variableArray2 = variableArray[n];
        variableArray[n] = variableArray[n2];
        variableArray[n2] = variableArray2;
    }

    private void buildBinaryConstraintGraph(Random random) {
        Object object;
        int n = this.variables().size() * (this.variables().size() - 1) / 2;
        Variable[][] variableArray = new Variable[n][];
        int n2 = 0;
        Enumeration enumeration = this.variables().elements();
        while (enumeration.hasMoreElements()) {
            object = (Variable)enumeration.nextElement();
            Enumeration enumeration2 = this.variables().elements();
            while (enumeration2.hasMoreElements()) {
                Variable variable = (Variable)enumeration2.nextElement();
                if (((Variable)object).getId() >= variable.getId()) continue;
                variableArray[n2++] = new Variable[]{object, variable};
            }
        }
        n2 = 0;
        enumeration = this.constraints().elements();
        while (enumeration.hasMoreElements()) {
            object = (CSPBinaryConstraint)enumeration.nextElement();
            this.swap(variableArray, n2, n2 + (int)(random.nextDouble() * (double)(n - n2)));
            ((BinaryConstraint)object).addVariable(variableArray[n2][0]);
            ((BinaryConstraint)object).addVariable(variableArray[n2][1]);
            ((CSPBinaryConstraint)object).init(random);
            ++n2;
        }
    }

    private void generate(int n, int n2, int n3, int n4, long l) {
        Object object;
        int n5;
        Random random = new Random(l);
        for (n5 = 0; n5 < n; ++n5) {
            object = new CSPVariable(n5 + 1, n2);
            this.addVariable((Variable)object);
        }
        for (n5 = 0; n5 < n3; ++n5) {
            object = new CSPBinaryConstraint(n5 + 1, n4);
            this.addConstraint((Constraint)object);
        }
        this.buildBinaryConstraintGraph(random);
    }
}

