/*
 * Decompiled with CFR 0.152.
 */
package ifs.example.csp;

import ifs.example.csp.CSPValue;
import ifs.model.BinaryConstraint;
import ifs.model.Value;
import java.util.Enumeration;
import java.util.Random;
import java.util.Set;

public class CSPBinaryConstraint
extends BinaryConstraint {
    private int iId = 0;
    private boolean[][] iIsConsistent = null;
    private int iNrCompatiblePairs;

    public CSPBinaryConstraint(int n, int n2) {
        this.iId = n;
        this.iNrCompatiblePairs = n2;
    }

    private void swap(int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = nArray2;
    }

    public void init(Random random) {
        int n = this.first().values().size() * this.second().values().size();
        int[][] nArrayArray = new int[n][];
        int n2 = 0;
        this.iIsConsistent = new boolean[this.first().values().size()][this.second().values().size()];
        Enumeration enumeration = this.first().values().elements();
        while (enumeration.hasMoreElements()) {
            CSPValue cSPValue = (CSPValue)enumeration.nextElement();
            Enumeration enumeration2 = this.second().values().elements();
            while (enumeration2.hasMoreElements()) {
                CSPValue cSPValue2 = (CSPValue)enumeration2.nextElement();
                this.iIsConsistent[cSPValue.toInt()][cSPValue2.toInt()] = false;
                nArrayArray[n2++] = new int[]{cSPValue.toInt(), cSPValue2.toInt()};
            }
        }
        for (int i = 0; i < this.iNrCompatiblePairs; ++i) {
            this.swap(nArrayArray, i, i + (int)(random.nextDouble() * (double)(n - i)));
            this.iIsConsistent[nArrayArray[i][0]][nArrayArray[i][1]] = true;
        }
    }

    public boolean isConsistent(Value value, Value value2) {
        if (value == null || value2 == null) {
            return true;
        }
        if (this.isFirst(value.variable())) {
            return this.iIsConsistent[value.toInt()][value2.toInt()];
        }
        return this.iIsConsistent[value2.toInt()][value.toInt()];
    }

    public void computeConflicts(Value value, Set set) {
        if (this.isFirst(value.variable())) {
            if (!this.isConsistent(value, this.second().getAssignment())) {
                set.add(this.second().getAssignment());
            }
        } else if (!this.isConsistent(this.first().getAssignment(), value)) {
            set.add(this.first().getAssignment());
        }
    }

    public String getName() {
        return "C" + this.getId();
    }
}

