/*
 * Decompiled with CFR 0.152.
 */
package ifs.dbt;

import ifs.dbt.DbtPropagation;
import ifs.extension.Extension;
import ifs.heuristics.VariableSelection;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import java.util.Enumeration;

public class DbtVariableSelection
implements VariableSelection {
    private DbtPropagation iProp = null;

    public DbtVariableSelection(DataProperties dataProperties) {
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (!(extension instanceof DbtPropagation)) continue;
            this.iProp = (DbtPropagation)extension;
        }
    }

    public Variable selectVariable(Solution solution) {
        if (solution.getModel().unassignedVariables().isEmpty()) {
            return null;
        }
        if (this.iProp != null) {
            Enumeration enumeration = solution.getModel().unassignedVariables().elements();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                if (!this.iProp.goodValues(variable).isEmpty()) continue;
                return variable;
            }
        }
        return (Variable)solution.getModel().unassignedVariables().firstElement();
    }
}

