/*
 * Decompiled with CFR 0.152.
 */
package ifs.dbt;

import ifs.dbt.DbtPropagation;
import ifs.extension.Extension;
import ifs.extension.ViolatedInitials;
import ifs.heuristics.ValueSelection;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solution.Solution;
import ifs.solver.Solver;
import ifs.util.DataProperties;
import ifs.util.FastVector;
import ifs.util.ToolBox;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DbtValueSelection
implements ValueSelection {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$heuristics$GeneralValueSelection == null ? (class$ifs$heuristics$GeneralValueSelection = DbtValueSelection.class$("ifs.heuristics.GeneralValueSelection")) : class$ifs$heuristics$GeneralValueSelection));
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightNrAssignments = 0.5;
    private double iWeightValue = 0.0;
    private boolean iMPP = false;
    private DbtPropagation iProp = null;
    private ViolatedInitials iViolatedInitials = null;
    static /* synthetic */ Class class$ifs$heuristics$GeneralValueSelection;

    public DbtValueSelection(DataProperties dataProperties) {
        this.iMPP = dataProperties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = dataProperties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = dataProperties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = dataProperties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iRandomWalkProb = dataProperties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightNrAssignments = dataProperties.getPropertyDouble("Value.WeightNrAssignments", 0.5);
        this.iWeightValue = dataProperties.getPropertyDouble("Value.WeightValue", 0.0);
    }

    public void init(Solver solver) {
        Enumeration enumeration = solver.getExtensions().elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            if (extension instanceof DbtPropagation) {
                this.iProp = (DbtPropagation)extension;
            }
            if (!(extension instanceof ViolatedInitials)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public Value selectValue(Solution solution, Variable variable) {
        Object object;
        Object object2;
        Value value;
        Enumeration enumeration;
        FastVector fastVector = null;
        if (this.iProp != null) {
            fastVector = new FastVector(this.iProp.goodValues(variable).size());
            enumeration = variable.values().elements();
            while (enumeration.hasMoreElements()) {
                value = (Value)enumeration.nextElement();
                if (!this.iProp.isGood(value)) continue;
                Set set = solution.getModel().conflictValues(value);
                if (!set.isEmpty()) {
                    object2 = new HashSet(2 * set.size());
                    object = set.iterator();
                    while (object.hasNext()) {
                        ((HashSet)object2).add((Value)object.next());
                    }
                    this.iProp.setNoGood(value, (Set)object2);
                    sLogger.debug((Object)(value + " become nogood (" + object2 + ")"));
                    continue;
                }
                if (solution.isBestComplete() && solution.getBestValue() <= solution.getModel().getTotalValue() + value.toInt()) continue;
                fastVector.add(value);
            }
        } else {
            fastVector = new FastVector(variable.values().size());
            enumeration = variable.values().elements();
            while (enumeration.hasMoreElements()) {
                value = (Value)enumeration.nextElement();
                if (!solution.getModel().conflictValues(value).isEmpty() || !solution.isBestComplete() || solution.getBestValue() <= solution.getModel().getTotalValue() + value.toInt()) continue;
                fastVector.add(value);
            }
        }
        if (fastVector.isEmpty()) {
            return null;
        }
        if (this.iMPP) {
            if (this.iMPPLimit >= 0 && solution.isBestComplete() && solution.getBestPertirbations() >= 0 && solution.getBestPertirbations() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getBestPertirbations() - 1;
                sLogger.debug((Object)("MPP Limit decreased to " + this.iMPPLimit));
            }
            int n = solution.getModel().perturbVariables().size();
            if (this.iMPPLimit >= 0 && this.iMPPLimit < n) {
                return null;
            }
            if (this.iMPPLimit >= 0 && this.iMPPLimit == n && variable.getInitialAssignment() != null) {
                if (fastVector.contains(variable.getInitialAssignment())) {
                    return variable.getInitialAssignment();
                }
                return null;
            }
            if (variable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && fastVector.contains(variable.getInitialAssignment())) {
                return variable.getInitialAssignment();
            }
        }
        if (fastVector.size() == 1) {
            return (Value)fastVector.firstElement();
        }
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return (Value)ToolBox.random(fastVector);
        }
        Vector vector = null;
        double d = 0.0;
        if (this.iWeightDeltaInitialAssignment == 0.0 && this.iWeightNrAssignments == 0.0 && this.iWeightValue == 0.0) {
            return (Value)ToolBox.random(fastVector);
        }
        object2 = ((Vector)fastVector).elements();
        while (object2.hasMoreElements()) {
            object = (Value)object2.nextElement();
            long l = 0L;
            if (this.iWeightDeltaInitialAssignment != 0.0) {
                Set set;
                if (this.iViolatedInitials != null && (set = this.iViolatedInitials.getViolatedInitials((Value)object)) != null) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Value value2 = (Value)iterator.next();
                        if (value2.variable().getAssignment() != null && !value2.variable().getAssignment().equals(value2)) continue;
                        l += 2L;
                    }
                }
                if (variable.getInitialAssignment() != null && !variable.getInitialAssignment().equals(object)) {
                    ++l;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables().size() + l > (long)this.iMPPLimit) continue;
            }
            double d2 = this.iWeightDeltaInitialAssignment * (double)l + this.iWeightNrAssignments * (double)((Value)object).countAssignments() + this.iWeightValue * (double)((Value)object).toInt();
            if (vector == null || d > d2) {
                d = d2;
                if (vector == null) {
                    vector = new FastVector();
                } else {
                    vector.clear();
                }
                vector.addElement(object);
                continue;
            }
            if (d != d2) continue;
            vector.addElement(object);
        }
        return vector == null ? null : (Value)ToolBox.random(vector);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

