/*
 * Decompiled with CFR 0.152.
 */
package ifs.dbt;

import ifs.extension.MacPropagation;
import ifs.model.Value;
import ifs.model.Variable;
import ifs.solver.Solver;
import ifs.solver.SolverListener;
import ifs.util.DataProperties;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class DbtPropagation
extends MacPropagation
implements SolverListener {
    private static Logger sLogger = Logger.getLogger((Class)(class$ifs$dbt$DbtPropagation == null ? (class$ifs$dbt$DbtPropagation = DbtPropagation.class$("ifs.dbt.DbtPropagation")) : class$ifs$dbt$DbtPropagation));
    static /* synthetic */ Class class$ifs$dbt$DbtPropagation;

    public DbtPropagation(Solver solver, DataProperties dataProperties) {
        super(solver, dataProperties);
        solver.addSolverListener(this);
    }

    public void afterAssigned(long l, Value value) {
        this.iIteration = l;
        if (!this.isGood(value)) {
            sLogger.warn((Object)(value.variable().getName() + " = " + value.getName() + " -- not good value assigned (noGood:" + this.noGood(value) + ")"));
            this.setGood(value);
        }
        HashSet<Value> hashSet = new HashSet<Value>(1);
        hashSet.add(value);
        Enumeration enumeration = value.variable().values().elements();
        while (enumeration.hasMoreElements()) {
            Value value2 = (Value)enumeration.nextElement();
            if (value2.equals(value) || !this.isGood(value2)) continue;
            this.setNoGood(value2, hashSet);
        }
        this.propagate(value.variable());
    }

    public void afterUnassigned(long l, Value value) {
        this.iIteration = l;
        if (!this.isGood(value)) {
            sLogger.error((Object)(value.variable().getName() + " = " + value.getName() + " -- not good value unassigned (noGood:" + this.noGood(value) + ")"));
        }
        this.undoPropagate(value.variable());
    }

    public boolean variableSelected(long l, Variable variable) {
        if (variable == null) {
            Object object;
            sLogger.debug((Object)"No variable selected -> backtrack.");
            Variable variable2 = null;
            Object object2 = this.getModel().assignedVariables().elements();
            while (object2.hasMoreElements()) {
                object = (Variable)object2.nextElement();
                if (variable2 != null && variable2.getAssignment().lastAssignmentIteration() >= ((Variable)object).getAssignment().lastAssignmentIteration()) continue;
                variable2 = object;
            }
            if (variable2 == null) {
                sLogger.error((Object)"No assignment -> fail");
                this.getSolver().stopSolver();
                return false;
            }
            sLogger.debug((Object)("Unassign:" + variable2.getName()));
            object2 = new HashSet();
            object = this.getModel().assignedVariables().elements();
            while (object.hasMoreElements()) {
                Variable variable3 = (Variable)object.nextElement();
                if (variable3.equals(variable2)) continue;
                ((HashSet)object2).add(variable3.getAssignment());
            }
            object = variable2.getAssignment();
            variable2.unassign(l);
            this.setNoGood((Value)object, (Set)object2);
            return false;
        }
        if (variable.getAssignment() != null) {
            sLogger.error((Object)"Assigned value selected -- not supported by DBT.");
            return false;
        }
        return true;
    }

    public boolean valueSelected(long l, Variable variable, Value value) {
        if (variable != null && value == null) {
            Object object;
            HashSet hashSet = new HashSet();
            Object object2 = variable.values().elements();
            while (object2.hasMoreElements()) {
                object = (Value)object2.nextElement();
                if (this.noGood((Value)object) == null) continue;
                hashSet.addAll(this.noGood((Value)object));
            }
            if (hashSet.isEmpty()) {
                sLogger.debug((Object)"Fail");
                this.getSolver().stopSolver();
                return false;
            }
            object2 = null;
            object = hashSet.iterator();
            while (object.hasNext()) {
                Value value2 = (Value)object.next();
                Variable variable2 = value2.variable();
                if (object2 != null && ((Variable)object2).getAssignment().lastAssignmentIteration() >= variable2.getAssignment().lastAssignmentIteration()) continue;
                object2 = variable2;
            }
            object = ((Variable)object2).getAssignment();
            hashSet.remove(object);
            ((Variable)object2).unassign(l);
            this.setNoGood((Value)object, hashSet);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

