/*
 * Decompiled with CFR 0.152.
 */
package timetable.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import timetable.util.Loc;

public class MessageTableDlg
extends JDialog {
    public static int OK = 1;
    public static int CANCEL = 2;
    public static int YES = 4;
    public static int NO = 8;
    public static int OKCANCEL = OK + CANCEL;
    public static int YESNO = YES + NO;
    protected int returnStatus = 0;
    private JPanel buttonPanel;
    private JButton yesButton;
    private JButton noButton;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane tableArea;
    private JTextArea msgArea;

    public MessageTableDlg(Frame parent, String title, String message, int buttons, JTable table) {
        super(parent, true);
        this.initComponents();
        this.pack();
        if ((buttons & OK) == 0) {
            this.buttonPanel.remove(this.okButton);
        }
        if ((buttons & CANCEL) == 0) {
            this.buttonPanel.remove(this.cancelButton);
        }
        if ((buttons & YES) == 0) {
            this.buttonPanel.remove(this.yesButton);
        }
        if ((buttons & NO) == 0) {
            this.buttonPanel.remove(this.noButton);
        }
        this.msgArea.setText(message);
        this.tableArea.setViewportView(table);
        this.setTitle(title);
        ((Component)this).setSize(335, 400);
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public MessageTableDlg(String title, String message, int buttons, JTable table) {
        this(new JFrame(), title, message, buttons, table);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.yesButton = new JButton();
        this.noButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tableArea = new JScrollPane();
        this.msgArea = new JTextArea();
        this.getContentPane().setLayout(null);
        this.setName("messageDlg");
        this.setModal(true);
        this.setTitle(Loc.get("timetable.util.messagedlg.title"));
        this.setResizable(false);
        this.addComponentListener(new 1());
        this.addWindowListener(new 2());
        this.yesButton.setText(Loc.get("timetable.button.yes"));
        this.yesButton.addActionListener(new 3());
        this.buttonPanel.add(this.yesButton);
        this.noButton.setText(Loc.get("timetable.button.no"));
        this.noButton.addActionListener(new 4());
        this.buttonPanel.add(this.noButton);
        this.okButton.setText(Loc.get("timetable.button.ok"));
        this.okButton.addActionListener(new 5());
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText(Loc.get("timetable.button.cancel"));
        this.cancelButton.addActionListener(new 6());
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add(this.buttonPanel);
        this.buttonPanel.setLocation(70, 330);
        this.buttonPanel.setSize(this.buttonPanel.getPreferredSize());
        this.tableArea.setPreferredSize(new Dimension(200, 170));
        this.tableArea.setMinimumSize(new Dimension(190, 250));
        this.getContentPane().add(this.tableArea);
        this.tableArea.setBounds(10, 50, 310, 270);
        this.msgArea.setWrapStyleWord(true);
        this.msgArea.setPreferredSize(new Dimension(190, 48));
        this.msgArea.setLineWrap(true);
        this.msgArea.setEditable(false);
        this.msgArea.setRows(3);
        this.msgArea.setBackground(new Color(205, 205, 205));
        this.getContentPane().add(this.msgArea);
        this.msgArea.setBounds(10, 10, 320, 30);
    }

    private void formComponentResized(ComponentEvent evt) {
    }

    private void noButtonActionPerformed(ActionEvent evt) {
        this.doClose(NO);
    }

    private void yesButtonActionPerformed(ActionEvent evt) {
        this.doClose(YES);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(CANCEL);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(OK);
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void doClose(int code) {
        this.returnStatus = code;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent evt) {
            MessageTableDlg.this.formComponentResized(evt);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            MessageTableDlg.this.closeDialog(evt);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MessageTableDlg.this.yesButtonActionPerformed(evt);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MessageTableDlg.this.noButtonActionPerformed(evt);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MessageTableDlg.this.okButtonActionPerformed(evt);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            MessageTableDlg.this.cancelButtonActionPerformed(evt);
        }

        /* synthetic */ 6() {
        }
    }
}

