/*
 * Decompiled with CFR 0.152.
 */
package timetable.solver.strategy.value;

import timetable.data.Activity;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.solver.strategy.Top10Value;
import timetable.solver.strategy.price.SingleActivityEvaluationInterface;
import timetable.solver.strategy.value.AbstractValueSelection;
import timetable.solver.strategy.value.HumanValueSelectionDlg;
import timetable.util.Config;
import timetable.util.TimetableException;

public class HumanValueSelection
extends AbstractValueSelection {
    protected int TOP10MAX = 50;
    Top10Value top10 = new Top10Value(this.TOP10MAX);
    int selected = 0;

    public HumanValueSelection(Config config, SingleActivityEvaluationInterface evaluation) throws TimetableException {
        super(config, evaluation);
    }

    public void reset(Activity activity) {
        this.top10.reset();
        this.activity = activity;
    }

    public void addValue(int slot, ActivityResources selectedResources, ActivityDependenceGroup dependences, ActivityGroup conflictActivities) throws TimetableException {
        int adept = this.evaluation.value(this.activity, slot, selectedResources, dependences, conflictActivities);
        this.config.log("      VALUE=" + adept);
        if (this.top10.willBeAdded(adept)) {
            this.top10.add(adept, slot, (ActivityResources)selectedResources.clone(), conflictActivities);
            this.config.log("        ADDED");
        }
    }

    public void select() throws TimetableException {
        if (this.top10.size() == 0) {
            this.selected = -1;
            return;
        }
        HumanValueSelectionDlg dlg = new HumanValueSelectionDlg(null, this.config);
        int i = 0;
        while (i < this.top10.size()) {
            dlg.addAdept(this.top10.slot(i), this.top10.resources(i).toString(), this.top10.activities(i).toString());
            ++i;
        }
        dlg.show();
        this.selected = dlg.getSelected();
    }

    public int selectedSlot() {
        if (this.selected < 0) {
            return -1;
        }
        return this.top10.slot(this.selected);
    }

    public ActivityResources selectedResources() {
        if (this.selected < 0) {
            return null;
        }
        return this.top10.resources(this.selected);
    }

    public ActivityGroup selectedConflictActivities() {
        if (this.selected < 0) {
            return null;
        }
        return this.top10.activities(this.selected);
    }
}

