/*
 * Decompiled with CFR 0.152.
 */
package timetable.school;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import timetable.data.Resource;
import timetable.data.TimePreference;
import timetable.gui.TimePreferencePanel;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.Math;
import timetable.util.TimetableException;

public class EditResourceDlg
extends JDialog {
    private boolean returnStatus = false;
    private TimePreference preference;
    private Resource resource;
    private JPanel commandPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane dataTab;
    private JPanel dataPanel;
    private JLabel jLabel3;
    private JTextField shortCutLabel;
    private JLabel jLabel4;
    private JTextField nameLabel;
    private JLabel jLabel5;
    private JTextArea noteArea;
    private JLabel jLabel1;

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public EditResourceDlg(Frame parent, String title, Config config, Resource resource) throws TimetableException {
        super(parent == null ? new JFrame() : parent, true);
        this.resource = resource;
        if (resource == null) {
            return;
        }
        this.initComponents();
        this.dataTab.setTitleAt(0, Loc.get("timetable.school.gui.tab.general"));
        this.pack();
        this.setTitle(title);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.ipady = 3;
        c.ipadx = 3;
        this.preference = (TimePreference)resource.getPreference().clone();
        TimePreferencePanel tpp = new TimePreferencePanel(config, this.preference);
        this.dataPanel.add((Component)tpp, c);
        ((Component)this).setSize(Math.max2(200, 20 * (config.getInt(Config.NR_SLOTS) / config.getInt(Config.NR_DAYS))) + 155, 360);
        this.shortCutLabel.setText(resource.shortCut);
        this.nameLabel.setText(resource.name);
        this.noteArea.setText(resource.note);
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public void show() {
        if (this.resource != null) {
            super.show();
        }
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.dataTab = new JTabbedPane();
        this.dataPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.shortCutLabel = new JTextField();
        this.jLabel4 = new JLabel();
        this.nameLabel = new JTextField();
        this.jLabel5 = new JLabel();
        this.noteArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditResourceDlg.this.closeDialog(evt);
            }
        });
        this.commandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton.setLabel(Loc.get("timetable.button.ok"));
        this.okButton.setText(Loc.get("timetable.button.ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResourceDlg.this.okButtonActionPerformed(evt);
            }
        });
        this.commandPanel.add(this.okButton);
        this.cancelButton.setLabel(Loc.get("timetable.button.cancel"));
        this.cancelButton.setText(Loc.get("timetable.button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditResourceDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        this.commandPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.commandPanel, "South");
        this.dataPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText(Loc.get("timetable.school.model.shortcut"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel3, gridBagConstraints1);
        this.shortCutLabel.setPreferredSize(new Dimension(80, 20));
        this.shortCutLabel.setText("jTextField3");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.shortCutLabel, gridBagConstraints1);
        this.jLabel4.setText(Loc.get("timetable.school.model.name"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel4, gridBagConstraints1);
        this.nameLabel.setPreferredSize(new Dimension(200, 20));
        this.nameLabel.setText("jTextField4");
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.nameLabel, gridBagConstraints1);
        this.jLabel5.setText(Loc.get("timetable.school.model.note"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel5, gridBagConstraints1);
        this.noteArea.setPreferredSize(new Dimension(200, 50));
        this.noteArea.setBorder(new EtchedBorder());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.noteArea, gridBagConstraints1);
        this.jLabel1.setText(Loc.get("timetable.school.model.timepreference"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel1, gridBagConstraints1);
        this.dataTab.addTab("Z\u00e1kladn\u00ed \u00fadaje", this.dataPanel);
        this.getContentPane().add((Component)this.dataTab, "Center");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.resource.name = this.nameLabel.getText();
        this.resource.shortCut = this.shortCutLabel.getText();
        this.resource.note = this.noteArea.getText();
        this.resource.setPreference(this.preference);
        this.returnStatus = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

