/*
 * Decompiled with CFR 0.152.
 */
package timetable.school;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import timetable.data.ActivityDependenceInterface;
import timetable.school.data.SchoolProblem;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.MessageDlg;
import timetable.util.TimetableException;

public class EditDependenceDlg
extends JDialog {
    private boolean returnStatus = false;
    private ActivityDependenceInterface dependence;
    private SchoolProblem problem;
    private JPanel commandPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane dataTab;
    private JPanel dataPanel;
    private JLabel jLabel3;
    private JComboBox firstActivityCombo;
    private JLabel jLabel4;
    private JComboBox secondActivityCombo;
    private JLabel jLabel5;
    private JComboBox typeCombo;

    public boolean getReturnStatus() {
        return this.returnStatus;
    }

    public EditDependenceDlg(Frame parent, String title, Config config, ActivityDependenceInterface dependence, SchoolProblem problem) throws TimetableException {
        super(parent == null ? new JFrame() : parent, true);
        this.dependence = dependence;
        this.problem = problem;
        if (dependence == null) {
            return;
        }
        this.initComponents();
        this.dataTab.setTitleAt(0, Loc.get("timetable.school.gui.tab.general"));
        this.pack();
        this.setTitle(title);
        ((Component)this).setSize(295, 195);
        int i = 0;
        while (i < problem.activities.size()) {
            this.firstActivityCombo.addItem(problem.activities.get((int)i).name);
            this.secondActivityCombo.addItem(problem.activities.get((int)i).name);
            ++i;
        }
        String[] types = dependence.getTypes();
        int i2 = 0;
        while (i2 < types.length) {
            this.typeCombo.addItem(types[i2]);
            ++i2;
        }
        this.firstActivityCombo.setSelectedIndex(problem.activities.indexOf(dependence.getFirstActivity()));
        this.secondActivityCombo.setSelectedIndex(problem.activities.indexOf(dependence.getSecondActivity()));
        this.typeCombo.setSelectedIndex(dependence.getType());
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 2);
    }

    public void show() {
        if (this.dependence != null) {
            super.show();
        }
    }

    private void initComponents() {
        this.commandPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.dataTab = new JTabbedPane();
        this.dataPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.firstActivityCombo = new JComboBox();
        this.jLabel4 = new JLabel();
        this.secondActivityCombo = new JComboBox();
        this.jLabel5 = new JLabel();
        this.typeCombo = new JComboBox();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditDependenceDlg.this.closeDialog(evt);
            }
        });
        this.commandPanel.setLayout(new FlowLayout(2, 5, 5));
        this.okButton.setText(Loc.get("timetable.button.ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditDependenceDlg.this.okButtonActionPerformed(evt);
            }
        });
        this.commandPanel.add(this.okButton);
        this.cancelButton.setText(Loc.get("timetable.button.cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditDependenceDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        this.commandPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.commandPanel, "South");
        this.dataPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText(Loc.get("timetable.school.model.firstact"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel3, gridBagConstraints1);
        this.firstActivityCombo.setPreferredSize(new Dimension(150, 25));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.firstActivityCombo, gridBagConstraints1);
        this.jLabel4.setText(Loc.get("timetable.school.model.secondact"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel4, gridBagConstraints1);
        this.secondActivityCombo.setPreferredSize(new Dimension(150, 25));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.secondActivityCombo, gridBagConstraints1);
        this.jLabel5.setText(Loc.get("timetable.school.model.param"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 3;
        gridBagConstraints1.ipady = 3;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.jLabel5, gridBagConstraints1);
        this.typeCombo.setPreferredSize(new Dimension(150, 25));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.dataPanel.add((Component)this.typeCombo, gridBagConstraints1);
        this.dataTab.addTab("Z\u00e1kladn\u00ed \u00fadaje", this.dataPanel);
        this.getContentPane().add((Component)this.dataTab, "Center");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String msg = null;
        if (this.typeCombo.getSelectedIndex() < 0) {
            msg = "Nezad\u00e1n parametr.";
        } else if (this.firstActivityCombo.getSelectedIndex() < 0) {
            msg = "Nezad\u00e1n prvn\u00ed p\u0159edm\u011bt.";
        } else if (this.secondActivityCombo.getSelectedIndex() < 0) {
            msg = "Nezad\u00e1n druh\u00fd p\u0159edm\u011bt.";
        }
        if (msg != null) {
            new MessageDlg("Chyba", msg, MessageDlg.OK).show();
            return;
        }
        this.dependence.setType(this.typeCombo.getSelectedIndex());
        this.dependence.setFirstActivity(this.problem.activities.get(this.firstActivityCombo.getSelectedIndex()));
        this.dependence.setSecondActivity(this.problem.activities.get(this.secondActivityCombo.getSelectedIndex()));
        this.returnStatus = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.returnStatus = false;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

