/*
 * Decompiled with CFR 0.152.
 */
package timetable.mff;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import timetable.data.Activity;
import timetable.data.ActivityGroup;
import timetable.data.Problem;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.school.data.SchoolProblem;
import timetable.util.Config;

public class MffTimetableEvaluator {
    Problem problem = null;

    public MffTimetableEvaluator(Problem problem) {
        this.problem = problem;
    }

    public void printAll(BufferedWriter w) throws Exception {
        w.write("<html><head><title>Rozvrh</title></head><body bgcolor=white>\n");
        w.write("<a href=\"#Rozvrh okruh\u016f\" >Rozvrh okruh\u016f</a>\n");
        w.write("&nbsp;&nbsp;<a href=\"#Rozvrh vyu\u010duj\u00edc\u00edch\" >Rozvrh vyu\u010duj\u00edc\u00edch</a>\n");
        w.write("&nbsp;&nbsp;<a href=\"#Rozvrh u\u010deben\" >Rozvrh u\u010deben</a>\n");
        w.write("&nbsp;&nbsp;<a href=\"#aktivity\" >Aktivity</a>\n");
        w.write("&nbsp;&nbsp;<a href=\"#statistika\" >Statistika</a>\n");
        w.write("<BR><BR>\n");
        this.printTable(w, 0, "Rozvrh okruh\u016f", "Okruh");
        w.write("<BR><BR>\n");
        this.printTable(w, 1, "Rozvrh vyu\u010duj\u00edc\u00edch", "Vyu\u010duj\u00edc\u00ed");
        w.write("<BR><BR>\n");
        this.printTable(w, 2, "Rozvrh u\u010deben", "U\u010debna");
        w.write("<BR><BR>\n");
        this.printActivityTable(w);
        w.write("<BR><BR>\n");
        this.printQuality(System.out, w);
        w.write("</body></html>");
    }

    public void printActivityTable(BufferedWriter w) throws Exception {
        int slots = this.problem.config.getInt(Config.NR_SLOTS);
        int days = this.problem.config.getInt(Config.NR_DAYS);
        int slotsPerDay = slots / days;
        w.write("<h2><a name=\"aktivity\">Aktivity</a></h2>\n");
        w.write("<table border=2 width=2000>\n");
        w.write("<tr><th rowspan=2 bgcolor=b0b0ff width=100>Zkratka</th><th rowspan=2 bgcolor=b0b0ff width=500>Jm\u00e9no</th><th rowspan=2 bgcolor=b0b0ff>D\u00e9lka</th><th colspan=4 bgcolor=b0b0ff>Rozvrh</th></tr>");
        w.write("<tr><th bgcolor=b0b0ff width=80>\u010cas</th><th bgcolor=b0b0ff>U\u010debna</th><th bgcolor=b0b0ff>Vyu\u010duj\u00edc\u00ed</th><th bgcolor=b0b0ff>Okruhy</th>\n");
        ActivityGroup activities = this.problem.activities;
        int i = 0;
        while (i < activities.size()) {
            Activity a = activities.get(i);
            if (a.isScheduled()) {
                w.write("<tr><td bgcolor=d0d0ff><a name=\"" + a.shortCut + "\">" + a.shortCut + "</a></td><td>" + a.name + "</td><td>" + a.length + (a.note != null && a.note.length() > 1 && a.note.charAt(1) != ';' ? a.note.substring(1, 2) : " ") + "</td><td>" + Config.DAY_OF_WEEK[a.start / slotsPerDay] + " " + (a.start % slotsPerDay + 1) + "</td>");
                int j = 2;
                while (j >= 0) {
                    w.write("<td>");
                    if (a.selectedResources.isGroup(j)) {
                        ResourceGroup rg = a.selectedResources.getResources(j);
                        int iRG = 0;
                        while (iRG < rg.size()) {
                            w.write((iRG == 0 ? "" : "; ") + "<a href=\"#" + rg.get((int)iRG).shortCut + "\">" + (j == 1 ? rg.get((int)iRG).name : rg.get((int)iRG).shortCut) + "</a>");
                            ++iRG;
                        }
                    } else {
                        w.write("<a href=\"#" + a.selectedResources.getResource((int)j).shortCut + "\">" + a.selectedResources.getResource((int)j).shortCut + "</a>");
                    }
                    if (j == 0 && a.paralelActivities != null && a.paralelActivities.size() > 0) {
                        ResourceGroup cRes = null;
                        if (!a.resources.getResources((int)0).conjunctive) {
                            cRes = a.resources.getResources(0);
                        } else if (a.corespondingResources != null && a.corespondingResources.size() > 0) {
                            cRes = a.corespondingResources;
                        }
                        int iR = 0;
                        while (iR < cRes.size()) {
                            Resource r = cRes.get(iR);
                            if (a.selectedResources.contains(r) < 0 && (r.isFreeAt(a.start, a.length) || r.getActivityAt(a.start) == a)) {
                                w.write("; <a href=\"#" + r.shortCut + "\">" + r.shortCut + "</a>");
                            }
                            ++iR;
                        }
                    }
                    w.write("</td>");
                    --j;
                }
                w.write("</tr>\n");
            }
            ++i;
        }
        w.write("</table>\n");
    }

    public void printTable(BufferedWriter w, int resNo, String title, String resName) throws Exception {
        int slots = this.problem.config.getInt(Config.NR_SLOTS);
        int days = this.problem.config.getInt(Config.NR_DAYS);
        int slotsPerDay = slots / days;
        w.write("<h2><a name=\"" + title + "\">" + title + "</h2>\n");
        w.write("<table border=2 width=" + (slots * 100 + days * 200 + 200) + ">\n");
        ResourceGroup resources = this.problem.resources[resNo];
        int i = 0;
        while (i < resources.size()) {
            if (i % 10 == 0) {
                w.write("<tr>");
                int d = 0;
                while (d < days) {
                    w.write("<th bgcolor=b0b0ff width=200>" + resName + "</th>");
                    int h = 0;
                    while (h < slotsPerDay) {
                        w.write("<th width=100 bgcolor=b0b0ff>" + Config.DAY_OF_WEEK[d] + " " + (h + 1) + "</th>");
                        ++h;
                    }
                    ++d;
                }
                w.write("</tr>\n");
            }
            Resource res = resources.get(i);
            w.write("<tr>");
            int s = 0;
            while (s < slots) {
                Activity a;
                if (s % slotsPerDay == 0) {
                    if (s == 0) {
                        w.write("<td bgcolor=d0d0ff><a name=\"" + res.shortCut + "\">&nbsp;<br>" + (resNo == 1 ? res.name : res.shortCut) + "<br>&nbsp;</a></td>");
                    } else {
                        w.write("<td bgcolor=d0d0ff>&nbsp;<br>" + (resNo == 1 ? res.name : res.shortCut) + "<br>&nbsp;</td>");
                    }
                }
                if ((a = res.getActivityAt(s)) == null) {
                    if (res.getPreference().isHARD(s)) {
                        w.write("<td bgcolor=ffd0d0>&nbsp;</td>");
                    } else {
                        w.write("<td bgcolor=ffffff>&nbsp;</td>");
                    }
                } else if (a.start == s) {
                    w.write("<td colspan=" + a.length + " bgcolor=e0e0e0>");
                    w.write("<a href=\"#" + a.shortCut + "\">" + a.shortCut + "</a>");
                    int j = 0;
                    while (j < 3) {
                        if (j != resNo) {
                            if (a.selectedResources.isGroup(j)) {
                                w.write("<br>");
                                ResourceGroup rg = a.selectedResources.getResources(j);
                                int iRG = 0;
                                while (iRG < rg.size()) {
                                    w.write((iRG == 0 ? "" : "; ") + "<a href=\"#" + rg.get((int)iRG).shortCut + "\">" + (j == 1 ? rg.get((int)iRG).name : rg.get((int)iRG).shortCut) + "</a>");
                                    ++iRG;
                                }
                            } else {
                                w.write("<br><a href=\"#" + a.selectedResources.getResource((int)j).shortCut + "\">" + a.selectedResources.getResource((int)j).shortCut + "</a>");
                            }
                        }
                        ++j;
                    }
                    w.write("</td>");
                }
                ++s;
            }
            w.write("</tr>\n");
            ++i;
        }
        w.write("</table>\n");
    }

    public void printQuality(PrintStream s, BufferedWriter w) throws Exception {
        Config config = this.problem.config;
        int slots = config.getInt(Config.NR_SLOTS);
        int days = config.getInt(Config.NR_DAYS);
        int slotsPerDay = slots / days;
        w.write("<h2><a name=\"statistika\">Statistika</h2>\n");
        this.problem.checkConsistency();
        w.write("Celkem aktivit: " + this.problem.activities.size() + "<br>\n");
        w.write("Celkem okruh\u016f: " + this.problem.resources[0].size() + "<br>\n");
        w.write("Celkem vyu\u010duj\u00edc\u00edch: " + this.problem.resources[1].size() + "<br>\n");
        w.write("Celkem u\u010deben: " + this.problem.resources[2].size() + "<br>\n");
        w.write("Nerozvr\u017een\u00fdch aktivit: " + this.problem.unscheduledActivities().size() + "<br><br>\n");
        w.write("<b>\u010casov\u00e9 preference: </b><br>\n");
        s.println("Total lectures: " + this.problem.activities.size());
        s.println("Total classes: " + this.problem.resources[0].size());
        s.println("Total teachers: " + this.problem.resources[1].size());
        s.println("Total classrooms: " + this.problem.resources[2].size());
        s.println("Unscheduled lectures: " + this.problem.unscheduledActivities().size());
        s.println("Time preferences: ");
        int softTotal = 0;
        int i = 0;
        while (i < this.problem.activities.size()) {
            Activity a = this.problem.activities.get(i);
            if (a.isScheduled()) {
                softTotal += a.getPreference().countViolatedSOFT(a.start, a.length);
            }
            ++i;
        }
        s.println("  Violated soft constraints: " + softTotal);
        w.write("&nbsp;&nbsp;Po\u010det poru\u0161en\u00fdch slab\u00fdch podm\u00ednek: " + softTotal + "<br><br>\n");
        ResourceGroup classes = this.problem.resources[0];
        int diffBuildings = 0;
        int diffBuildingsNoBrake = 0;
        int manyHoursNoBrake = 0;
        int manyHours = 0;
        int totalBrakes = 0;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < classes.size()) {
            Resource cls = classes.get(i2);
            int day = 0;
            while (day < days) {
                char building = '?';
                boolean brake = true;
                int hours = 0;
                int hoursNoBrake = 0;
                boolean first = true;
                int hour = 0;
                while (hour < slotsPerDay) {
                    int slot = day * slotsPerDay + hour;
                    if (cls.getActivityAt(slot) != null) {
                        if (first) {
                            first = false;
                        } else if (brake) {
                            ++totalBrakes;
                        }
                        ++hours;
                        ++hoursNoBrake;
                        Activity a = cls.getActivityAt(slot);
                        if (a.selectedResources.getResource(2) != null && building == '?') {
                            building = a.selectedResources.getResource((int)2).note.charAt(0);
                        }
                        if (a.selectedResources.getResource(2) != null && building != a.selectedResources.getResource((int)2).note.charAt(0)) {
                            ++diffBuildings;
                            if (!brake) {
                                s.println("      Different building (without any brake) for class " + cls.shortCut + ", lecture " + a.shortCut + ", bulding " + building + "->" + a.selectedResources.getResource((int)2).note.charAt(0) + " .");
                                ++diffBuildingsNoBrake;
                                if (buffer.toString().length() > 0) {
                                    buffer.append("; ");
                                }
                                buffer.append("t\u0159\u00edda " + cls.shortCut + ", \u010das " + Config.DAY_OF_WEEK[a.start / slotsPerDay] + " " + (a.start % slotsPerDay + 1) + ", budova " + building + "->" + a.selectedResources.getResource((int)2).note.charAt(0));
                            }
                            building = a.selectedResources.getResource((int)2).note.charAt(0);
                        }
                        brake = false;
                    } else {
                        if (hoursNoBrake > 6) {
                            ++manyHoursNoBrake;
                        }
                        hoursNoBrake = 0;
                        brake = true;
                    }
                    ++hour;
                }
                if (hoursNoBrake > 6) {
                    ++manyHoursNoBrake;
                }
                if (hours > 10) {
                    ++manyHours;
                }
                ++day;
            }
            ++i2;
        }
        s.println("  Soft time preferences: classes");
        s.println("    Building changes without free hour between: " + diffBuildingsNoBrake);
        s.println("    Total building changes: " + diffBuildings);
        s.println("    Days with more than 10 hours: " + manyHours);
        s.println("    Days with more than 6 hours without brake: " + manyHoursNoBrake);
        s.println("    Total number of brakes (free hours between scheduled lectures): " + totalBrakes);
        w.write("&nbsp;&nbsp;Slab\u00e9 \u010dasov\u00e9 preference: <b>okruhy</b><br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det p\u0159ejezd\u016f (bez voln\u00e9 hodiny): " + diffBuildingsNoBrake + (diffBuildingsNoBrake > 0 ? " (" + buffer.toString() + ")" : "") + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det p\u0159ejezd\u016f celkem: " + diffBuildings + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det dn\u016f s v\u00edce ne\u017e 10 hodinami: " + manyHours + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det dn\u016f s v\u00edce ne\u017e 6 hodinami bez p\u0159est\u00e1vky: " + manyHoursNoBrake + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Celkem po\u010det p\u0159est\u00e1vek (voln\u00fdch hodin mezi napl\u00e1novan\u00fdmi aktivitami): " + totalBrakes + "<br><br>\n");
        buffer = new StringBuffer();
        ResourceGroup teachers = this.problem.resources[1];
        diffBuildings = 0;
        diffBuildingsNoBrake = 0;
        manyHoursNoBrake = 0;
        manyHours = 0;
        totalBrakes = 0;
        int sameBuilding = 0;
        int diffBuilding = 0;
        int i3 = 0;
        while (i3 < teachers.size()) {
            Resource cls = teachers.get(i3);
            char teachBuilding = '?';
            if (cls.note != null && cls.note.length() > 0) {
                teachBuilding = cls.note.charAt(0);
            }
            int day = 0;
            while (day < days) {
                char building = '?';
                boolean brake = true;
                int hours = 0;
                int hoursNoBrake = 0;
                boolean first = true;
                int hour = 0;
                while (hour < slotsPerDay) {
                    int slot = day * slotsPerDay + hour;
                    if (cls.getActivityAt(slot) != null) {
                        if (first) {
                            first = false;
                        } else if (brake) {
                            ++totalBrakes;
                        }
                        ++hours;
                        ++hoursNoBrake;
                        Activity a = cls.getActivityAt(slot);
                        if (a.selectedResources.getResource(2) != null && building == '?') {
                            building = a.selectedResources.getResource((int)2).note.charAt(0);
                        }
                        if (a.selectedResources.getResource(2) != null && building != a.selectedResources.getResource((int)2).note.charAt(0)) {
                            ++diffBuildings;
                            if (!brake) {
                                s.println("      Different building (without any brake) for teacher " + cls.shortCut + ", lecture " + a.shortCut + " .");
                                if (buffer.toString().length() > 0) {
                                    buffer.append("; ");
                                }
                                buffer.append("vyu\u010duj\u00edc\u00ed " + cls.shortCut + ", \u010das " + Config.DAY_OF_WEEK[a.start / slotsPerDay] + " " + (a.start % slotsPerDay + 1) + ", budova " + building + "->" + a.selectedResources.getResource((int)2).note.charAt(0));
                                ++diffBuildingsNoBrake;
                            }
                            building = a.selectedResources.getResource((int)2).note.charAt(0);
                        }
                        if (building != '?' && teachBuilding != '?' && a.start == slot) {
                            if (building == teachBuilding) {
                                ++sameBuilding;
                            } else {
                                ++diffBuilding;
                            }
                        }
                        brake = false;
                    } else {
                        if (hoursNoBrake > 6) {
                            ++manyHoursNoBrake;
                        }
                        hoursNoBrake = 0;
                        brake = true;
                    }
                    ++hour;
                }
                if (hoursNoBrake > 6) {
                    ++manyHoursNoBrake;
                }
                if (hours > 8) {
                    ++manyHours;
                }
                ++day;
            }
            ++i3;
        }
        s.println("  Soft time preferences: teachers");
        s.println("    Building changes without free hour between: " + diffBuildingsNoBrake);
        s.println("    Total building changes: " + diffBuildings);
        s.println("    Days with more than 8 hours: " + manyHours);
        s.println("    Days with more than 6 hours without brake: " + manyHoursNoBrake);
        s.println("    Total number of brakes (free hours between scheduled lectures): " + totalBrakes);
        w.write("&nbsp;&nbsp;Slab\u00e9 \u010dasov\u00e9 preference: <b>vyu\u010duj\u00edc\u00ed</b><br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det p\u0159ejezd\u016f (bez voln\u00e9 hodiny): " + diffBuildingsNoBrake + (diffBuildingsNoBrake > 0 ? " (" + buffer.toString() + ")" : "") + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det p\u0159ejezd\u016f celkem: " + diffBuildings + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det dn\u016f s v\u00edce ne\u017e 8 hodinami: " + manyHours + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det dn\u016f s v\u00edce ne\u017e 6 hodinami bez p\u0159est\u00e1vky: " + manyHoursNoBrake + "<br>\n");
        w.write("&nbsp;&nbsp;&nbsp;&nbsp;Celkem po\u010det p\u0159est\u00e1vek (voln\u00fdch hodin mezi napl\u00e1novan\u00fdmi aktivitami): " + totalBrakes + "<br><br>\n");
        ResourceGroup rooms = this.problem.resources[2];
        int unsatisfiedPrepareActivities = 0;
        int prepareActivities = 0;
        int i4 = 0;
        while (i4 < rooms.size()) {
            Resource rm = rooms.get(i4);
            int day = 0;
            while (day < days) {
                int hour = 0;
                while (hour < slotsPerDay) {
                    int slot = day * slotsPerDay + hour;
                    if (rm.getActivityAt(slot) != null) {
                        Activity a = rm.getActivityAt(slot);
                        if (slot == a.start && a.note != null && a.note.length() >= 2 && a.note.charAt(1) == 'P') {
                            ++prepareActivities;
                            if (hour == 0 || rm.getActivityAt(slot - 1) != null) {
                                System.err.println("No prepare time for " + a.shortCut + " at =" + Config.DAY_OF_WEEK[a.start / slotsPerDay] + " " + (a.start % slotsPerDay + 1) + " (room=" + rm.shortCut);
                                ++unsatisfiedPrepareActivities;
                            }
                        }
                    }
                    ++hour;
                }
                ++day;
            }
            ++i4;
        }
        s.println("  Lectures with extra prepare time (room duration +1)");
        s.println("    Unsatisfied lectures with extra prepare time: " + unsatisfiedPrepareActivities);
        s.println("    Total lectures with extra prepare time: " + prepareActivities);
        if (config.getGlobalPref() != null) {
            int i5;
            int[] usedSlots = new int[slots];
            int i6 = 0;
            while (i6 < slots) {
                usedSlots[i6] = 0;
                ++i6;
            }
            int i7 = 0;
            while (i7 < this.problem.activities.size()) {
                Activity a = this.problem.activities.get(i7);
                if (a.isScheduled()) {
                    int sl = a.start;
                    while (sl < a.start + a.length) {
                        int n = sl++;
                        usedSlots[n] = usedSlots[n] + 1;
                    }
                }
                ++i7;
            }
            s.println("  Global time preferences:");
            w.write("<b>&nbsp;&nbsp;Glob\u00e1ln\u00ed \u010dasov\u00e9 preference:</b><br>\n");
            int pref = -4;
            while (pref <= 4) {
                int sum = 0;
                i5 = 0;
                while (i5 < slots) {
                    if (config.getGlobalPref()[i5] == pref) {
                        sum += usedSlots[i5];
                    }
                    ++i5;
                }
                if (sum != 0) {
                    s.println("    Number of used slots with preference " + pref + ": " + sum);
                    w.write("&nbsp;&nbsp;&nbsp;&nbsp;Po\u010det pou\u017eit\u00fdch \u010dasov\u00fdch slot\u016f s preferenc\u00ed " + pref + ": " + sum + "<br>\n");
                }
                ++pref;
            }
            int total = 0;
            i5 = 0;
            while (i5 < slots) {
                total += usedSlots[i5];
                ++i5;
            }
            s.println("    Total used slots: " + total);
            w.write("&nbsp;&nbsp;&nbsp;&nbsp;Celkem pou\u017eit\u00fdch \u010dasov\u00fdch slot\u016f: " + total + "<br><br>\n");
        }
        int nrPossibilities = 0;
        int nrInpossibilities = 0;
        int nrHyperInpossibilities = 0;
        int countPos = 0;
        int iA = 0;
        while (iA < this.problem.activities.size()) {
            Activity activity = this.problem.activities.get(iA);
            if (activity.isScheduled() && activity.paralelActivities != null && activity.paralelActivities.size() > 0) {
                ActivityGroup pAct = activity.paralelActivities;
                ResourceGroup cRes = null;
                if (!activity.resources.getResources((int)0).conjunctive) {
                    cRes = activity.resources.getResources(0);
                } else if (activity.corespondingResources != null && activity.corespondingResources.size() > 0) {
                    cRes = activity.corespondingResources;
                }
                if (cRes != null) {
                    int iR = 0;
                    while (iR < cRes.size()) {
                        Resource r = cRes.get(iR);
                        if (r.isFreeAt(activity.start, activity.length)) {
                            ++nrPossibilities;
                        } else {
                            Activity a = r.getActivityAt(activity.start);
                            if (a != null && a.start == activity.start && pAct.indexOf(a) >= 0) {
                                ++nrPossibilities;
                            } else {
                                boolean possible = false;
                                int iAct = 0;
                                while (iAct < pAct.size()) {
                                    Activity eAct = pAct.get(iAct);
                                    if (!eAct.isScheduled() || r.isFreeAt(eAct.start, eAct.length) || r.getActivityAt(eAct.start) == eAct) {
                                        possible = true;
                                    }
                                    ++iAct;
                                }
                                ++nrInpossibilities;
                                if (!possible) {
                                    ++nrHyperInpossibilities;
                                    s.println("      Class " + r.shortCut + " can not attend " + activity.shortCut + " from " + pAct + " .");
                                }
                            }
                        }
                        ++countPos;
                        ++iR;
                    }
                }
            }
            ++iA;
        }
        s.println("Alternative lectures: ");
        s.println("  Average number of possibilities: " + 100 * nrPossibilities / countPos + "%");
        s.println("  Number of possibilities: " + nrPossibilities);
        s.println("  Number of inpossibilities: " + nrInpossibilities);
        s.println("  Number of total inpossibilities: " + nrHyperInpossibilities);
        w.write("<b>Alternativn\u00ed aktivity: </b><br>\n");
        w.write("&nbsp;&nbsp;Pr\u016fm\u011brn\u00fd po\u010det mo\u017enost\u00ed: " + 100 * nrPossibilities / countPos + "%<br>\n");
        w.write("&nbsp;&nbsp;Po\u010det dostupn\u00fdch alternativ (dan\u00fd okruh m\u016f\u017ee doch\u00e1zet na jednu z alternativ): " + nrPossibilities + "<br>\n");
        w.write("&nbsp;&nbsp;Po\u010det nedostupn\u00fdch alternativ (dan\u00fd okruh nem\u016f\u017ee doch\u00e1zet na jednu z alternativ): " + nrInpossibilities + "<br>\n");
        w.write("&nbsp;&nbsp;Po\u010det chyb (dan\u00fd okruh nem\u016f\u017ee doch\u00e1zet na \u017e\u00e1dnou z alternativ): " + nrHyperInpossibilities + "<br><br>\n");
        w.write("<b>Vazba vyu\u010duj\u00edc\u00edch na budovy</b><br>\n");
        w.write("&nbsp;&nbsp;Po\u010det aktivit vyu\u010dovan\u00fdch v budov\u011b, kde s\u00eddl\u00ed vyu\u010duj\u00edc\u00ed: " + sameBuilding + "<br>\n");
        w.write("&nbsp;&nbsp;Po\u010det aktivit vyu\u010dovan\u00fdch v jin\u00e9 budov\u011b, ne\u017e s\u00eddl\u00ed vyu\u010duj\u00edc\u00ed: " + diffBuilding + "<br>\n");
        w.write("&nbsp;&nbsp;\u00dasp\u011b\u0161nost: " + 100 * sameBuilding / (sameBuilding + diffBuilding) + "%<br>\n");
    }

    public static void main(String[] args) {
        try {
            Problem p = SchoolProblem.load("mff.shd");
            MffTimetableEvaluator e = new MffTimetableEvaluator(p);
            BufferedWriter w = new BufferedWriter(new FileWriter("rozvrh.html"));
            e.printAll(w);
            w.flush();
            w.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }
}

