/*
 * Decompiled with CFR 0.152.
 */
package timetable.mff;

import timetable.data.Activity;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.school.solver.strategy.price.SchoolSingleActivityEvaluation;
import timetable.util.Config;
import timetable.util.Math;
import timetable.util.TimetableException;

public class MffActivityEvaluation
extends SchoolSingleActivityEvaluation {
    public static int MANY_HOURS_PENALTY = 75;
    public static int MANY_HOURS_WITHOUT_BRAKE_PENALTY = 75;
    public static int CROSSING_PENALTY = 30;
    public static int NOTCONNECT_PENALTY = 5;
    public static int CROSING_NO_BRAKE_PENALTY = 200;
    public static int PARALLEL_POSSIBILITIES = -10;
    public static int PARALLEL_INPOSSIBILITIES = 100;
    public static int PREPARE_PENALTY = 500;
    public static int SAME_BUILDING_BONUS = -40;

    public MffActivityEvaluation(Config config) throws TimetableException {
        super(config);
    }

    public int value(Activity activity, int slot, ActivityResources selectedResources, ActivityDependenceGroup dependences, ActivityGroup conflictActivities) throws TimetableException {
        int sum = 0;
        try {
            Resource r;
            int s;
            Activity a;
            int slots = this.config.getInt(Config.NR_SLOTS);
            int days = this.config.getInt(Config.NR_DAYS);
            int slotsPerDay = slots / days;
            int day = slot / slotsPerDay;
            ResourceGroup paralelClasses = new ResourceGroup();
            int nrInpossibilities = 0;
            int nrPossibilities = 0;
            Activity badActivity = null;
            boolean paralel = false;
            if (activity.paralelActivities != null && activity.paralelActivities.size() > 0) {
                ActivityGroup pAct = activity.paralelActivities;
                ResourceGroup cRes = null;
                if (!activity.resources.getResources((int)0).conjunctive) {
                    cRes = activity.resources.getResources(0);
                } else if (activity.corespondingResources != null && activity.corespondingResources.size() > 0) {
                    cRes = activity.corespondingResources;
                }
                if (cRes != null) {
                    paralel = true;
                    int i = 0;
                    while (i < cRes.size()) {
                        Resource r2 = cRes.get(i);
                        if (r2.isFreeAt(slot, activity.length, conflictActivities)) {
                            ++nrPossibilities;
                            paralelClasses.add(r2);
                        } else {
                            a = r2.getActivityAt(slot);
                            if (a != null && a.start == slot && pAct.indexOf(a) >= 0) {
                                ++nrPossibilities;
                            } else {
                                ++nrInpossibilities;
                            }
                        }
                        ++i;
                    }
                    if (nrInpossibilities > 0) {
                        int nrNotScheduled = 0;
                        int i2 = 0;
                        while (i2 < pAct.size()) {
                            if (!pAct.get(i2).isScheduled() || conflictActivities.indexOf(pAct.get(i2)) >= 0) {
                                ++nrNotScheduled;
                            }
                            ++i2;
                        }
                        if (nrNotScheduled > 1) {
                            nrInpossibilities = 0;
                        }
                    }
                    if (nrInpossibilities > 0) {
                        while (badActivity == null || badActivity == activity) {
                            badActivity = pAct.get(Math.random(pAct.size()));
                        }
                    }
                }
            }
            if (paralel) {
                sum += nrPossibilities * PARALLEL_POSSIBILITIES;
                sum += nrInpossibilities * PARALLEL_INPOSSIBILITIES;
                if (badActivity != null) {
                    conflictActivities.addIfIsNot(badActivity);
                }
            }
            if (slot % slotsPerDay == 0 && activity.note != null && activity.note.length() >= 2 && activity.note.charAt(1) == 'P') {
                sum += PREPARE_PENALTY;
            }
            ResourceGroup crm = null;
            if (selectedResources.isGroup(2)) {
                crm = selectedResources.getResources(2);
            } else {
                crm = new ResourceGroup();
                crm.add(selectedResources.getResource(2));
            }
            if (slot % slotsPerDay != 0 && activity.note != null && activity.note.length() >= 2 && activity.note.charAt(1) == 'P') {
                int iR = 0;
                while (iR < crm.size()) {
                    Resource room = crm.get(iR);
                    if (room.getActivityAt(slot - 1) != null) {
                        conflictActivities.addIfIsNot(room.getActivityAt(slot - 1));
                    }
                    ++iR;
                }
            }
            if ((slot + activity.length) % slotsPerDay != 0) {
                int iR = 0;
                while (iR < crm.size()) {
                    Resource room = crm.get(iR);
                    if (room.getActivityAt(slot + activity.length) != null) {
                        a = room.getActivityAt(slot + activity.length);
                        if (a.note != null && a.note.length() >= 2 && a.note.charAt(1) == 'P') {
                            conflictActivities.addIfIsNot(a);
                        }
                    }
                    ++iR;
                }
            }
            int manyHours = 0;
            int manyHoursWithoutBrake = 0;
            int nrCrossings = 0;
            int nrCrossingsNoBrake = 0;
            int nrNotConnect = 0;
            boolean info = false;
            ResourceGroup classes = selectedResources.getResources(0);
            int i = 0;
            while (i < (classes == null ? 1 : classes.size())) {
                char building;
                Resource cls = classes == null ? selectedResources.getResource(0) : classes.get(i);
                boolean brake = false;
                int hours = activity.length;
                int hoursNoBrake = activity.length;
                boolean diffBuilding = false;
                char c = building = selectedResources.getResource(2) != null ? (char)selectedResources.getResource((int)2).note.charAt(0) : (char)'?';
                if (slot == 0 || cls.getActivityAt(slot - 1) == null || conflictActivities.indexOf(cls.getActivityAt(slot - 1)) > 0) {
                    ++nrNotConnect;
                }
                if ((slot + activity.length) % slotsPerDay == 0 || cls.getActivityAt(slot + activity.length) == null || conflictActivities.indexOf(cls.getActivityAt(slot + activity.length)) > 0) {
                    ++nrNotConnect;
                }
                int s2 = slot - 1;
                while (s2 >= day * slotsPerDay) {
                    Activity a2 = cls.getActivityAt(s2);
                    if (a2 == null || conflictActivities.indexOf(a2) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource r3;
                            Resource resource = r3 = a2.selectedResources.getResource(2) != null ? a2.selectedResources.getResource(2) : null;
                            if (r3 != null && r3.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    --s2;
                }
                diffBuilding = false;
                brake = false;
                s = slot + activity.length;
                while (s < (day + 1) * slotsPerDay) {
                    Activity a3 = cls.getActivityAt(s);
                    if (a3 == null || conflictActivities.indexOf(a3) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource resource = r = a3.selectedResources.getResource(2) != null ? a3.selectedResources.getResource(2) : null;
                            if (r != null && r.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    ++s;
                }
                if (hours > 10) {
                    ++manyHours;
                }
                if (hoursNoBrake > 6) {
                    ++manyHoursWithoutBrake;
                }
                ++i;
            }
            classes = paralelClasses;
            int i3 = 0;
            while (i3 < (classes == null ? 1 : classes.size())) {
                char building;
                Resource cls = classes == null ? selectedResources.getResource(0) : classes.get(i3);
                boolean brake = false;
                int hours = activity.length;
                int hoursNoBrake = activity.length;
                boolean diffBuilding = false;
                char c = building = selectedResources.getResource(2) != null ? (char)selectedResources.getResource((int)2).note.charAt(0) : (char)'?';
                if (slot == 0 || cls.getActivityAt(slot - 1) == null || conflictActivities.indexOf(cls.getActivityAt(slot - 1)) > 0) {
                    ++nrNotConnect;
                }
                if ((slot + activity.length) % slotsPerDay == 0 || cls.getActivityAt(slot + activity.length) == null || conflictActivities.indexOf(cls.getActivityAt(slot + activity.length)) > 0) {
                    ++nrNotConnect;
                }
                s = slot - 1;
                while (s >= day * slotsPerDay) {
                    Activity a4 = cls.getActivityAt(s);
                    if (a4 == null || conflictActivities.indexOf(a4) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource resource = r = a4.selectedResources.getResource(2) != null ? a4.selectedResources.getResource(2) : null;
                            if (r != null && r.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    --s;
                }
                diffBuilding = false;
                brake = false;
                int s3 = slot + activity.length;
                while (s3 < (day + 1) * slotsPerDay) {
                    Activity a5 = cls.getActivityAt(s3);
                    if (a5 == null || conflictActivities.indexOf(a5) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource r4;
                            Resource resource = r4 = a5.selectedResources.getResource(2) != null ? a5.selectedResources.getResource(2) : null;
                            if (r4 != null && r4.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    ++s3;
                }
                if (hours > 10) {
                    ++manyHours;
                }
                if (hoursNoBrake > 6) {
                    ++manyHoursWithoutBrake;
                }
                ++i3;
            }
            classes = selectedResources.getResources(1);
            int sameBuilding = 0;
            int i4 = 0;
            while (i4 < (classes == null ? 1 : classes.size())) {
                char building;
                Resource cls = classes == null ? selectedResources.getResource(1) : classes.get(i4);
                char tchBuild = '?';
                if (cls.note != null && cls.note.length() > 0) {
                    tchBuild = cls.note.charAt(0);
                }
                boolean brake = false;
                int hours = activity.length;
                int hoursNoBrake = activity.length;
                boolean diffBuilding = false;
                char c = building = selectedResources.getResource(2) != null ? (char)selectedResources.getResource((int)2).note.charAt(0) : (char)'?';
                if (tchBuild != '?' && building != '?' && building == tchBuild) {
                    ++sameBuilding;
                }
                int s4 = slot - 1;
                while (s4 >= day * slotsPerDay) {
                    Activity a6 = cls.getActivityAt(s4);
                    if (a6 == null || conflictActivities.indexOf(a6) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource r5;
                            Resource resource = r5 = a6.selectedResources.getResource(2) != null ? a6.selectedResources.getResource(2) : null;
                            if (r5 != null && r5.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    --s4;
                }
                diffBuilding = false;
                brake = false;
                int s5 = slot + activity.length;
                while (s5 < (day + 1) * slotsPerDay) {
                    Activity a7 = cls.getActivityAt(s5);
                    if (a7 == null || conflictActivities.indexOf(a7) >= 0) {
                        brake = true;
                    } else {
                        ++hours;
                        if (!brake) {
                            ++hoursNoBrake;
                        }
                        if (!diffBuilding) {
                            Resource r6;
                            Resource resource = r6 = a7.selectedResources.getResource(2) != null ? a7.selectedResources.getResource(2) : null;
                            if (r6 != null && r6.note.charAt(0) != building) {
                                diffBuilding = true;
                                ++nrCrossings;
                                if (!brake) {
                                    ++nrCrossingsNoBrake;
                                }
                            }
                        }
                    }
                    ++s5;
                }
                if (hours > 8) {
                    ++manyHours;
                }
                if (hoursNoBrake > 6) {
                    ++manyHoursWithoutBrake;
                }
                ++i4;
            }
            sum += manyHours * MANY_HOURS_PENALTY;
            sum += manyHoursWithoutBrake * MANY_HOURS_WITHOUT_BRAKE_PENALTY;
            sum += nrCrossings * CROSSING_PENALTY;
            sum += nrCrossingsNoBrake * CROSING_NO_BRAKE_PENALTY;
            sum += nrNotConnect * NOTCONNECT_PENALTY;
            sum += sameBuilding * SAME_BUILDING_BONUS;
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
        return sum + super.value(activity, slot, selectedResources, dependences, conflictActivities);
    }
}

