/*
 * Decompiled with CFR 0.152.
 */
package timetable.mff;

import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import timetable.data.Activity;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.data.Resource;
import timetable.data.ResourceGroup;
import timetable.data.TimeActivityDependence;
import timetable.data.TimePreference;
import timetable.mff.DataRetriever;
import timetable.school.data.SchoolProblem;
import timetable.util.Config;

public class DataMiner {
    static int YEAR = 2001;
    static int SEM = 1;
    static int HOURSPERDAY = 15;
    static int NRSLOTS = 75;
    static int NRDAYS = 5;
    DataRetriever dtr;
    Config config = null;
    ResourceGroup classes = new ResourceGroup();
    ActivityResources groupsOfClasses = new ActivityResources();
    ResourceGroup classrooms = new ResourceGroup();
    ResourceGroup allClassrooms = new ResourceGroup();
    ResourceGroup teachers = new ResourceGroup();
    ActivityGroup lectures = new ActivityGroup();
    ActivityGroup groupOfParalelActivities = new ActivityGroup();
    ActivityDependenceGroup dependences = new ActivityDependenceGroup();
    Hashtable departments = new Hashtable();

    public DataMiner(Config config) {
        this.config = config;
        try {
            this.dtr = new DataRetriever();
        }
        catch (Exception e) {
            System.err.println("DM Error: " + e.getMessage());
            this.dtr = null;
        }
    }

    private String getSpaces(int cnt) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < cnt) {
            b.append("  ");
            ++i;
        }
        return b.toString();
    }

    public void close() {
        try {
            this.dtr.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    private int str2int(Object s) {
        return Integer.parseInt((String)s);
    }

    /*
     * WARNING - void declaration
     */
    private Vector getClassChilds(String kod) {
        try {
            void e;
            Vector data = new Vector();
            this.dtr.query("select KOD, NADOKRUH, NAZEV from OKRUH where OSKR=" + YEAR + " and OSEM=" + SEM + " and NADOKRUH" + (kod == null ? " is null" : "='" + kod + "'") + " order by KOD", data);
            return e;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return null;
        }
    }

    private Vector getClass(String kod) {
        try {
            Vector data = new Vector();
            this.dtr.query("select KOD, NADOKRUH, NAZEV from OKRUH where OSKR=" + YEAR + " and OSEM=" + SEM + " and KOD='" + kod + "'" + " order by KOD", data);
            return data.size() == 1 ? (Vector)data.get(0) : null;
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return null;
        }
    }

    private ResourceGroup readClasses(String code, int i) throws Exception {
        Vector data = this.getClassChilds(code);
        if (data.size() == 0) {
            Vector it = this.getClass(code);
            Resource res = new Resource(this.config);
            res.name = (String)it.get(2);
            res.note = (String)it.get(0);
            res.shortCut = (String)it.get(0);
            this.classes.add(res);
            ResourceGroup rg = new ResourceGroup();
            rg.conjunctive = true;
            rg.name = res.name;
            rg.shortCut = res.shortCut;
            rg.note = res.note;
            Vector poz = new Vector();
            this.dtr.query("select POZDEN, POZHOD, POZNELZE from OKRUHPOZ where POZSKR=" + YEAR + " and POZSEM=" + SEM + " and POZOKRUH='" + res.shortCut + "'", poz);
            int rp = 0;
            while (rp < poz.size()) {
                Vector pozl = (Vector)poz.get(rp);
                int slot = (this.str2int(pozl.get(0)) - 1) * HOURSPERDAY + this.str2int(pozl.get(1)) - 1;
                int con = this.str2int(pozl.get(2));
                if (con == 2) {
                    res.getPreference().setHARD(slot);
                } else if (con == 1) {
                    res.getPreference().setSOFT(slot);
                } else {
                    res.getPreference().setFREE(slot);
                }
                ++rp;
            }
            rg.add(res);
            this.groupsOfClasses.add(rg);
            return rg;
        }
        Vector it = this.getClass(code);
        ResourceGroup res = new ResourceGroup();
        res.conjunctive = true;
        res.name = (String)it.get(2);
        res.note = (String)it.get(0);
        res.shortCut = (String)it.get(0);
        int r = 0;
        while (r < data.size()) {
            ResourceGroup rg = this.readClasses((String)((Vector)data.get(r)).get(0), i + 0);
            int j = 0;
            while (j < rg.size()) {
                res.add(rg.get(j));
                ++j;
            }
            ++r;
        }
        this.groupsOfClasses.add(res);
        return res;
    }

    public void readClasses() throws Exception {
        System.out.print("Reading classes ");
        Vector data = this.getClassChilds(null);
        int r = 0;
        while (r < data.size()) {
            System.out.print(".");
            this.readClasses((String)((Vector)data.get(r)).get(0), 1);
            ++r;
        }
        System.out.println(" done");
    }

    public void readDepartments() throws Exception {
        BufferedReader br = new BufferedReader(new FileReader("c:\\departments.txt"));
        while (br.ready()) {
            String line = br.readLine();
            if (line == null || line.length() <= 0 || line.charAt(0) == ';' || line.indexOf(44) <= 0) continue;
            this.departments.put(line.substring(0, line.indexOf(44)), line.substring(line.indexOf(44) + 1));
        }
        br.close();
    }

    public void readClassrooms() throws Exception {
        System.out.print("Reading classrooms ");
        Vector data = new Vector();
        this.dtr.query("select KOD, NAZEV, BUDOVA, KAPACITA from RUCEBNA where PRIDEL!=0 order by KOD", data);
        int r = 0;
        while (r < data.size()) {
            Vector col = (Vector)data.get(r);
            Resource res = new Resource(this.config);
            res.shortCut = (String)col.get(0);
            res.name = res.shortCut + " (" + col.get(1) + ")";
            res.note = (String)col.get(2);
            res.note = col.get(3) != null ? res.note + "," + col.get(3) : res.note + ",15";
            this.classrooms.add(res);
            this.allClassrooms.add(res);
            System.out.print(".");
            ++r;
        }
        this.dtr.query("select distinct u.KOD, u.NAZEV, u.BUDOVA, u.KAPACITA from RUCEBNA u, ROZVRH r where (r.RSKR=" + YEAR + " and r.RSEM=" + SEM + " and (r.RROZVRH='C' or r.RROZVRH='P') and r.RPOZUCE=u.kod) or u.KOD='KTV' order by u.KOD", data);
        int r2 = 0;
        while (r2 < data.size()) {
            boolean found = false;
            Vector col = (Vector)data.get(r2);
            String shkt = (String)col.get(0);
            int i = 0;
            while (i < this.classrooms.size() & !found) {
                if (this.classrooms.get((int)i).shortCut.equals(shkt)) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                Resource res = new Resource(this.config);
                res.shortCut = (String)col.get(0);
                res.name = res.shortCut + " (" + col.get(1) + ")";
                res.note = (String)col.get(2);
                res.note = col.get(3) != null ? res.note + "," + col.get(3) : res.note + ",15";
                this.allClassrooms.add(res);
            }
            System.out.print(".");
            ++r2;
        }
        System.out.println(" done");
    }

    public void readTeachers() throws Exception {
        System.out.print("Reading teachers ");
        Vector data = new Vector();
        this.dtr.query("select distinct KOD, NAZEV, USTAV from UCIT, ROZUCIT where UUCIT=KOD and USKR=" + YEAR + " and USEM=" + SEM + " order by NAZEV", data);
        int r = 0;
        while (r < data.size()) {
            Vector col = (Vector)data.get(r);
            Resource res = new Resource(this.config);
            res.shortCut = (String)col.get(0);
            res.name = (String)col.get(1);
            res.note = col.get(2) != null ? (this.departments.containsKey((String)col.get(2)) ? this.departments.get((String)col.get(2)) + "," + col.get(2) : "?," + col.get(2)) : null;
            Vector poz = new Vector();
            this.dtr.query("select POZDEN, POZHOD, POZNELZE from UCITPOZ where POZSKR=" + YEAR + " and POZSEM=" + SEM + " and POZUCIT='" + res.shortCut + "'", poz);
            int rp = 0;
            while (rp < poz.size()) {
                Vector pozl = (Vector)poz.get(rp);
                int slot = (this.str2int(pozl.get(0)) - 1) * HOURSPERDAY + this.str2int(pozl.get(1)) - 1;
                int con = this.str2int(pozl.get(2));
                if (con == 2) {
                    res.getPreference().setHARD(slot);
                } else if (con == 1) {
                    res.getPreference().setSOFT(slot);
                } else {
                    res.getPreference().setFREE(slot);
                }
                ++rp;
            }
            this.teachers.add(res);
            if (r % 10 == 0) {
                System.out.print(".");
            }
            ++r;
        }
        this.dtr.query("select distinct uucit from rozucit where not exists (select * from ucit where kod=uucit) and uskr=" + YEAR + " and usem=" + SEM + " order by UUCIT", data);
        int r2 = 0;
        while (r2 < data.size()) {
            Vector col = (Vector)data.get(r2);
            Resource res = new Resource(this.config);
            res.shortCut = (String)col.get(0);
            res.name = "Nezn\u00e1m\u00fd vyu\u010duj\u00edc\u00ed \u010d\u00edslo" + col.get(0);
            Vector poz = new Vector();
            this.dtr.query("select POZDEN, POZHOD, POZNELZE from UCITPOZ where POZSKR=" + YEAR + " and POZSEM=" + SEM + " and POZUCIT='" + res.shortCut + "'", poz);
            int rp = 0;
            while (rp < poz.size()) {
                Vector pozl = (Vector)poz.get(rp);
                int slot = (this.str2int(pozl.get(0)) - 1) * HOURSPERDAY + this.str2int(pozl.get(1)) - 1;
                int con = this.str2int(pozl.get(2));
                if (con == 2) {
                    res.getPreference().setHARD(slot);
                } else if (con == 1) {
                    res.getPreference().setSOFT(slot);
                } else {
                    res.getPreference().setFREE(slot);
                }
                ++rp;
            }
            this.teachers.add(res);
            if (r2 % 10 == 0) {
                System.out.print(".");
            }
            ++r2;
        }
        System.out.println(" done");
    }

    protected ResourceGroup resourceGroupByShortCut(ActivityResources resourceGroups, String shortCut, String sources) {
        int i = 0;
        while (i < resourceGroups.size()) {
            ResourceGroup rg = resourceGroups.getResources(i);
            if (rg.shortCut.equals(shortCut)) {
                return rg;
            }
            ++i;
        }
        System.out.println("Nebyla nalezena skupina " + sources + " se zkratkou " + shortCut + ".");
        return null;
    }

    protected Resource resourceByShortCut(ResourceGroup group, String shortCut, String source) {
        int i = 0;
        while (i < group.size()) {
            if (group.get((int)i).shortCut.equals(shortCut)) {
                return group.get(i);
            }
            ++i;
        }
        System.out.println("Nebyl nalezen " + source + " se zkratkou " + shortCut + ".");
        return null;
    }

    public void readLectures() throws Exception {
        System.out.print("Reading lectures ");
        Vector data = new Vector();
        this.dtr.query("select r.RUDALOST, r.RPOVINN, r.RKOMENT, r.RVZOR, r.RPOCSTUD, r.RPOZDEN, r.RPOZHOD, r.RPOZUCE, r.RPOZBUD from ROZVRH r where r.RSKR=" + YEAR + " and r.RSEM=" + SEM + " and (r.RROZVRH='C' or r.RROZVRH='P') order by r.RUDALOST", data);
        int r = 0;
        while (r < data.size()) {
            int hour;
            Vector col = (Vector)data.get(r);
            if (col.get(1) != null && col.get(1).toString().substring(0, 3).equalsIgnoreCase("TVY")) {
                col.set(7, "KTV");
            }
            Activity a = new Activity(this.config);
            a.length = this.str2int(((String)col.get(3)).substring(0, 1));
            if (col.get(3) != null && col.get(3).toString().length() > 1 && ((String)col.get(3)).charAt(1) == 'K') {
                ++a.length;
            }
            a.shortCut = (String)col.get(0);
            a.name = "" + col.get(0) + ": " + col.get(2);
            a.note = col.get(3) == null ? null : col.get(3).toString();
            int day = col.get(5) != null ? Integer.parseInt(col.get(5).toString()) : -1;
            int n = hour = col.get(6) != null ? Integer.parseInt(col.get(6).toString()) : -1;
            if (day >= 0) {
                if (hour >= 0) {
                    int iS = 0;
                    while (iS < NRSLOTS) {
                        a.getPreference().setHARD(iS);
                        ++iS;
                    }
                    int slot = (day - 1) * HOURSPERDAY + hour - 1;
                    TimePreference timePreference = a.getPreference();
                    int n2 = slot + a.length - 1;
                    a.getPreference();
                    timePreference.set(slot, n2, TimePreference.FREE);
                } else {
                    int iS = 0;
                    while (iS < NRSLOTS) {
                        if (iS / HOURSPERDAY != day - 1) {
                            a.getPreference().setHARD(iS);
                        }
                        ++iS;
                    }
                }
            } else if (hour >= 0) {
                int iS = 0;
                while (iS < NRSLOTS) {
                    a.getPreference().setHARD(iS);
                    ++iS;
                }
                int iD = 0;
                while (iD < NRDAYS) {
                    int slot = iD * HOURSPERDAY + hour - 1;
                    TimePreference timePreference = a.getPreference();
                    int n3 = slot + a.length - 1;
                    a.getPreference();
                    timePreference.set(slot, n3, TimePreference.FREE);
                    ++iD;
                }
            }
            Vector res = new Vector();
            this.dtr.query("select OOKRUH from ROZOKRUH where OSKR=" + YEAR + " and OSEM=" + SEM + " and OUDALOST='" + a.shortCut + "'", res);
            if (res.size() == 0) {
                System.out.println("Neni definovan zadny okruh pro predmet " + a.shortCut + ".");
            }
            ResourceGroup cls = new ResourceGroup();
            cls.conjunctive = true;
            if (res.size() == 1) {
                ResourceGroup g = this.resourceGroupByShortCut(this.groupsOfClasses, (String)((Vector)res.get(0)).get(0), "trid");
                int gr = 0;
                while (gr < g.size()) {
                    cls.addIfNot(g.get(gr));
                    ++gr;
                }
            } else {
                int rr = 0;
                while (rr < res.size()) {
                    Vector x = (Vector)res.get(rr);
                    ResourceGroup g = this.resourceGroupByShortCut(this.groupsOfClasses, (String)x.get(0), "trid");
                    int gr = 0;
                    while (gr < g.size()) {
                        cls.addIfNot(g.get(gr));
                        ++gr;
                    }
                    ++rr;
                }
            }
            String building = col.get(8) != null ? col.get(8).toString() : null;
            ResourceGroup clr = new ResourceGroup();
            if (col.get(7) == null) {
                if (col.get(4) == null) {
                    if (building != null) {
                        int iC = 0;
                        while (iC < this.classrooms.size()) {
                            Resource oneClass = this.classrooms.get(iC);
                            String classBuilding = oneClass.note.substring(0, oneClass.note.indexOf(44));
                            if (building.equalsIgnoreCase(classBuilding)) {
                                clr.add(oneClass);
                            }
                            ++iC;
                        }
                        if (clr.size() == 0) {
                            System.err.println("Nenalezena vhodna ucebna pro predmet " + a.shortCut + " (budova " + building + ")!");
                            clr.conjunctive = true;
                        }
                    } else {
                        clr = this.classrooms;
                    }
                } else {
                    int students = ((BigDecimal)col.get(4)).intValue();
                    int iC = 0;
                    while (iC < this.classrooms.size()) {
                        Resource oneClass = this.classrooms.get(iC);
                        int capacity = Integer.parseInt(oneClass.note.substring(oneClass.note.lastIndexOf(44) + 1));
                        String classBuilding = oneClass.note.substring(0, oneClass.note.indexOf(44));
                        if (students <= capacity && (building == null || building.equalsIgnoreCase(classBuilding))) {
                            clr.add(oneClass);
                        }
                        ++iC;
                    }
                    if (clr.size() == 0) {
                        System.err.println("Nenalezena vhodna ucebna pro predmet " + a.shortCut + " (prilis mnoho studentu" + (building != null ? "; bulidnig=" + building : "") + ")!");
                        clr.conjunctive = true;
                    }
                }
            } else {
                clr.add(this.resourceByShortCut(this.allClassrooms, (String)col.get(7), "ucebna"));
            }
            ResourceGroup tchr = new ResourceGroup();
            this.dtr.query("select UUCIT from ROZUCIT where USKR=" + YEAR + " and USEM=" + SEM + " and UUDALOST='" + a.shortCut + "'", res);
            if (res.size() == 0) {
                System.out.println("Neni definovan zadny vyucujici pro predmet " + a.shortCut + ".");
            }
            tchr.conjunctive = true;
            int rr = 0;
            while (rr < res.size()) {
                Vector x = (Vector)res.get(rr);
                Resource t = this.resourceByShortCut(this.teachers, (String)x.get(0), "vyucujici");
                if (t != null) {
                    tchr.add(t);
                }
                ++rr;
            }
            a.resources.add(cls);
            a.resources.add(tchr);
            a.resources.add(clr);
            if (r % 10 == 0) {
                System.out.print(".");
            }
            if (a.shortCut.equalsIgnoreCase("FOE001x1a")) {
                Activity b = (Activity)a.clone();
                b.shortCut = "FOE001x1abcd";
                b.resources.getResources(2).addIfNot(this.resourceByShortCut(this.allClassrooms, "F2", "ucebna"));
                b.resources.getResources(2).addIfNot(this.resourceByShortCut(this.allClassrooms, "KFK", "ucebna"));
                b.resources.getResources((int)2).conjunctive = true;
                b.resources.getResources(1).addIfNot(this.resourceByShortCut(this.teachers, "00205", "vyucujici"));
                b.resources.getResources(1).addIfNot(this.resourceByShortCut(this.teachers, "00612", "vyucujici"));
                b.resources.getResources((int)1).conjunctive = true;
                this.lectures.add(b);
            }
            this.lectures.add(a);
            ++r;
        }
        System.out.println(" done");
        System.out.print("Paralelizing lectures ");
        int iA = 0;
        while (iA < this.lectures.size()) {
            Activity lecture = this.lectures.get(iA);
            if (lecture.paralelActivities == null) {
                this.dtr.query("select r.RUDALOST from ROZVRH r, ROZVRH z where z.RUDALOST='" + lecture.shortCut + "' and r.RSKR=" + YEAR + " and r.RSEM=" + SEM + " and z.RSKR=" + YEAR + " and z.RSEM=" + SEM + " and (r.RROZVRH='C' or r.RROZVRH='P') and z.RPOKRAC=r.RPOKRAC and z.RPOVINN=r.RPOVINN and r.RTYP=z.RTYP " + " and exists (select * from rozokruh o1, rozokruh o2 where o1.oskr=" + YEAR + " and o1.osem=" + SEM + " and o2.oskr=" + YEAR + " and o2.osem=" + SEM + " and o1.oudalost=z.rudalost and o2.oudalost=r.rudalost and (substr(o2.ookruh,1,length(o1.ookruh))=o1.ookruh))" + " and r.RUDALOST!='MOD012p12' order by r.RUDALOST", data);
                if (data.size() > 1) {
                    ActivityGroup paralelActivities = new ActivityGroup();
                    int r2 = 0;
                    while (r2 < data.size()) {
                        Vector col = (Vector)data.get(r2);
                        String id = (String)col.get(0);
                        int iAct = 0;
                        while (iAct < this.lectures.size()) {
                            if (this.lectures.get((int)iAct).shortCut.equals(id)) {
                                paralelActivities.add(this.lectures.get(iAct));
                            }
                            ++iAct;
                        }
                        ++r2;
                    }
                    ResourceGroup corespondingResources = new ResourceGroup();
                    int iAct = 0;
                    while (iAct < paralelActivities.size()) {
                        Activity a = paralelActivities.get(iAct);
                        if (a != lecture) {
                            int iR = 0;
                            while (iR < a.resources.getResources(0).size()) {
                                Resource r3 = a.resources.getResources(0).get(iR);
                                if (lecture.resources.getResources(0).indexOf(r3) >= 0) {
                                    corespondingResources.addIfNot(r3);
                                }
                                ++iR;
                            }
                        }
                        ++iAct;
                    }
                    if (corespondingResources.size() > 0) {
                        lecture.paralelActivities = paralelActivities;
                        if (corespondingResources.size() == lecture.resources.getResources(0).size()) {
                            lecture.resources.getResources((int)0).conjunctive = false;
                            lecture.corespondingResources = null;
                        } else {
                            lecture.resources.getResources((int)0).conjunctive = true;
                            lecture.corespondingResources = corespondingResources;
                            ResourceGroup allRes = lecture.resources.getResources(0);
                            int iCR = 0;
                            while (iCR < corespondingResources.size()) {
                                if (allRes.indexOf(corespondingResources.get(iCR)) < 0) {
                                    System.err.println("Bad resource " + corespondingResources.get((int)iCR).shortCut);
                                } else {
                                    allRes.remove(corespondingResources.get(iCR));
                                }
                                ++iCR;
                            }
                        }
                        System.err.println(lecture.shortCut + " " + paralelActivities + ": for resources " + (lecture.corespondingResources == null ? lecture.resources.getResources(0) : lecture.corespondingResources) + (lecture.resources.getResources((int)0).conjunctive ? " conjunctive " : " disjunctive ") + (lecture.corespondingResources != null ? "(res " + lecture.resources.getResources(0) + ")" : ""));
                        lecture.note = lecture.note + ";" + paralelActivities + ";" + (lecture.corespondingResources == null ? lecture.resources.getResources(0) : lecture.corespondingResources);
                        this.groupOfParalelActivities.add(lecture);
                    }
                }
            }
            if (iA % 10 == 0) {
                System.out.print(".");
            }
            ++iA;
        }
        System.out.println(" done");
        System.out.println("Searching for sequential lectures ");
        this.dtr.query("select r.rudalost, z.rudalost from ROZVRH r, ROZVRH z where r.rskr=" + YEAR + " and r.rsem=" + SEM + " and (r.RROZVRH='C' or r.RROZVRH='P') and " + "z.rskr=" + YEAR + " and z.rsem=" + SEM + " and (z.RROZVRH='C' or z.RROZVRH='P') and " + "r.rpokrac<z.rpokrac and r.rtyp=z.rtyp and r.rpovinn=z.rpovinn and r.rparalel=z.rparalel", data);
        int r4 = 0;
        while (r4 < data.size()) {
            Vector col = (Vector)data.get(r4);
            String code1 = col.get(0).toString();
            Activity a1 = null;
            int i = 0;
            while (i < this.lectures.size()) {
                if (this.lectures.get((int)i).shortCut.equals(code1)) {
                    a1 = this.lectures.get(i);
                }
                ++i;
            }
            String code2 = col.get(1).toString();
            Activity a2 = null;
            int i2 = 0;
            while (i2 < this.lectures.size()) {
                if (this.lectures.get((int)i2).shortCut.equals(code2)) {
                    a2 = this.lectures.get(i2);
                }
                ++i2;
            }
            this.dependences.add(new TimeActivityDependence(a1, TimeActivityDependence.DIFFERENT_DAY, a2, this.config));
            if (r4 % 10 == 0) {
                System.out.print(".");
            }
            ++r4;
        }
        System.out.println(" done");
    }

    public static void main(String[] args) {
        try {
            Config c = new Config("c:\\konfig.cfg");
            DataMiner dm = new DataMiner(c);
            dm.readDepartments();
            dm.readClasses();
            dm.readClassrooms();
            dm.readTeachers();
            dm.readLectures();
            dm.close();
            SchoolProblem p = new SchoolProblem(c);
            p.activities = dm.lectures;
            Enumeration e = p.activities.elements();
            while (e.hasMoreElements()) {
                Activity a = (Activity)e.nextElement();
                if (a.shortCut.equalsIgnoreCase("FOEO01x1a")) {
                    p.activities.remove(a);
                }
                if (a.shortCut.equalsIgnoreCase("FOEO01x1b")) {
                    p.activities.remove(a);
                }
                if (a.shortCut.equalsIgnoreCase("FOEO01x1c")) {
                    p.activities.remove(a);
                }
                if (a.shortCut.equalsIgnoreCase("FOEO01x1d")) {
                    p.activities.remove(a);
                }
                if (!a.shortCut.equalsIgnoreCase("MOD012p12")) continue;
                p.activities.remove(a);
            }
            p.resources = new ResourceGroup[]{dm.classes, dm.teachers, dm.allClassrooms, new ResourceGroup()};
            p.groupedClasses = dm.groupsOfClasses;
            p.groupOfParalelActivities = dm.groupOfParalelActivities;
            p.dependences = dm.dependences;
            p.save("c:\\mff.shd");
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }
}

