/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import timetable.data.AbstractActivityDependence;
import timetable.data.Activity;
import timetable.data.ActivityDependenceInterface;
import timetable.data.ActivityGroup;
import timetable.util.Config;
import timetable.util.Loc;
import timetable.util.TimetableException;

public class TimeActivityDependence
extends AbstractActivityDependence {
    public static int NO_DEPENDENCE = 0;
    public static int BEFORE = 1;
    public static int CLOSELY_BEFORE = 2;
    public static int AFTER = 3;
    public static int CLOSELY_AFTER = 4;
    public static int CONCURRENCY = 5;
    public static int DIFFERENT_DAY = 6;
    public static String DEPENDENCE_NAME = Loc.get("timetable.dependence.timedep");
    protected static String[] TYPES = new String[]{Loc.get("timetable.dependence.timedep.no"), Loc.get("timetable.dependence.timedep.before"), Loc.get("timetable.dependence.timedep.closelybefore"), Loc.get("timetable.dependence.timedep.after"), Loc.get("timetable.dependence.timedep.closelyafter"), Loc.get("timetable.dependence.timedep.concurrently"), Loc.get("timetable.dependence.timedep.diffday")};

    public TimeActivityDependence(Config config) {
        super(config);
    }

    public String getDependenceName() {
        return DEPENDENCE_NAME;
    }

    public String[] getTypes() {
        return TYPES;
    }

    public TimeActivityDependence(Activity first, int type, Activity second, Config config) {
        super(first, second, config);
        this.type = type;
    }

    public boolean isOK(int activityStart1, int activityStart2) {
        if (this.type == NO_DEPENDENCE || activityStart1 == -1 || activityStart2 == -1) {
            return true;
        }
        if (this.type == BEFORE) {
            return activityStart1 + this.first.length <= activityStart2;
        }
        if (this.type == CLOSELY_BEFORE) {
            return activityStart1 + this.first.length == activityStart2;
        }
        if (this.type == AFTER) {
            return activityStart2 + this.second.length <= activityStart1;
        }
        if (this.type == CLOSELY_AFTER) {
            return activityStart2 + this.second.length == activityStart1;
        }
        if (this.type == CONCURRENCY) {
            return activityStart1 <= activityStart2 && activityStart2 + this.second.length <= activityStart1 + this.first.length || activityStart2 <= activityStart1 && activityStart1 + this.first.length <= activityStart2 + this.second.length;
        }
        if (this.type == DIFFERENT_DAY) {
            try {
                int days = this.config.getInt(Config.NR_DAYS);
                int slots = this.config.getInt(Config.NR_SLOTS);
                int slotsPerDay = slots / days;
                return activityStart1 / slotsPerDay != activityStart2 / slotsPerDay;
            }
            catch (TimetableException timetableException) {
                return true;
            }
        }
        System.err.println(" o ou");
        return false;
    }

    public String toString() {
        return "DEP " + this.first.shortCut + " " + TYPES[this.type] + " " + this.second.shortCut;
    }

    public void write(ObjectOutputStream out, ActivityGroup allActivites) throws IOException {
        out.writeInt(allActivites.indexOf(this.first));
        out.writeInt(this.type);
        out.writeInt(allActivites.indexOf(this.second));
    }

    public ActivityDependenceInterface read(ObjectInputStream in, ActivityGroup allActivities, Config config) throws IOException, ClassNotFoundException {
        TimeActivityDependence tad = new TimeActivityDependence(allActivities.get(in.readInt()), in.readInt(), allActivities.get(in.readInt()), config);
        return tad;
    }
}

