/*
 * Decompiled with CFR 0.152.
 */
package timetable.data;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import timetable.data.Activity;
import timetable.data.ActivityDependenceGroup;
import timetable.data.ActivityGroup;
import timetable.data.ActivityResources;
import timetable.data.ResourceGroup;
import timetable.util.Config;
import timetable.util.TimetableException;

public class Problem
implements Serializable {
    public Config config = null;
    protected int nrSlots = 0;
    public ActivityGroup activities = new ActivityGroup();
    public ActivityDependenceGroup dependences = new ActivityDependenceGroup();
    public ResourceGroup[] resources = null;
    public ActivityGroup groupOfParalelActivities = new ActivityGroup();

    public void setProblem(Problem problem) {
        this.config = problem.config;
        this.nrSlots = problem.nrSlots;
        this.activities = problem.activities;
        this.dependences = problem.dependences;
        this.resources = problem.resources;
    }

    public Problem(Config config) throws TimetableException {
        this.config = config;
        this.nrSlots = config.getInt(Config.NR_SLOTS);
    }

    public Problem(Problem problem) throws TimetableException {
        this(problem.config);
        this.activities = problem.activities;
        this.dependences = problem.dependences;
        this.resources = problem.resources;
    }

    public void checkConsistency() throws TimetableException {
        System.err.println("Checking consistency ...");
        int i = 0;
        while (i < this.activities.size()) {
            Activity a = this.activities.get(i);
            if (!a.isConsistent(this.dependences)) {
                a.remove(null);
            }
            ++i;
        }
    }

    public boolean isChanged() {
        boolean changed = false;
        int i = 0;
        while (i < this.resources.length && !changed) {
            changed = changed || this.resources[i].isChanged();
            ++i;
        }
        return this.activities.isChanged() || changed;
    }

    public ActivityGroup unscheduledActivities() {
        ActivityGroup g = new ActivityGroup();
        int i = 0;
        while (i < this.activities.size()) {
            if (!this.activities.get(i).isScheduled()) {
                g.add(this.activities.get(i));
            }
            ++i;
        }
        return g;
    }

    public void reset() {
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get(i).remove(null);
            ++i;
        }
    }

    public void clearCounts() {
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get((int)i).nrRemoves = 0;
            ++i;
        }
    }

    public void saveState() {
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get((int)i).lastSelectedResources = this.activities.get((int)i).selectedResources == null ? null : (ActivityResources)this.activities.get((int)i).selectedResources.clone();
            this.activities.get((int)i).lastStart = this.activities.get((int)i).start;
            ++i;
        }
    }

    public void restoreLastState() {
        this.reset();
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get((int)i).start = this.activities.get((int)i).lastStart;
            this.activities.get(i).schedule(this.activities.get((int)i).start, this.activities.get((int)i).lastSelectedResources == null ? null : (ActivityResources)this.activities.get((int)i).lastSelectedResources.clone());
            ++i;
        }
    }

    public void saveBestState() {
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get((int)i).bestSelectedResources = this.activities.get((int)i).selectedResources == null ? null : (ActivityResources)this.activities.get((int)i).selectedResources.clone();
            this.activities.get((int)i).bestStart = this.activities.get((int)i).start;
            ++i;
        }
    }

    public void restoreBestState() {
        this.reset();
        int i = 0;
        while (i < this.activities.size()) {
            this.activities.get((int)i).start = this.activities.get((int)i).bestStart;
            this.activities.get(i).schedule(this.activities.get((int)i).start, this.activities.get((int)i).bestSelectedResources == null ? null : (ActivityResources)this.activities.get((int)i).bestSelectedResources.clone());
            ++i;
        }
    }

    private static String subStr(String s, int length) {
        while (s.length() < length) {
            s = new String(s + " ");
        }
        if (s.length() > length) {
            s = s.substring(0, length);
        }
        return s;
    }

    private void writeLine(OutputStreamWriter osw) throws IOException {
        osw.write("----+");
        int i = 0;
        while (i < this.nrSlots) {
            osw.write("----+");
            ++i;
        }
        osw.write("\n");
    }

    protected void writeHead(OutputStreamWriter osw) throws IOException {
        osw.write("    |");
        int i = 0;
        while (i < this.nrSlots) {
            osw.write(Problem.subStr("" + (1 + i), 4) + "|");
            ++i;
        }
        osw.write("\n");
        this.writeLine(osw);
    }

    public void print(String file, ResourceGroup allResources, int order, int size) throws TimetableException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            try {
                this.print(osw, allResources, order, size);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                osw.flush();
                osw.close();
                fos.close();
                throw throwable;
            }
            osw.flush();
            osw.close();
            fos.close();
            {
            }
        }
        catch (IOException e) {
            throw new TimetableException(e.getMessage());
        }
    }

    public void print(OutputStreamWriter osw, ResourceGroup allResources, int order, int size) throws IOException {
        int nrScheduled = 0;
        int writtenSlots = 0;
        this.writeHead(osw);
        int i = 0;
        while (i < allResources.size()) {
            osw.write(Problem.subStr(allResources.get((int)i).shortCut, 4) + "|");
            Activity[] a = new Activity[this.nrSlots];
            int j = 0;
            while (j < this.activities.size()) {
                if (this.activities.get(j).isScheduled() && !this.activities.get((int)j).selectedResources.isGroup(order) && this.activities.get((int)j).selectedResources.getResource(order) == allResources.get(i)) {
                    ++nrScheduled;
                    int k = 0;
                    while (k < this.activities.get((int)j).length) {
                        if (a[this.activities.get((int)j).start + k] != null) {
                            System.err.println("PRUSER");
                        } else {
                            a[this.activities.get((int)j).start + k] = this.activities.get(j);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < this.nrSlots) {
                if (a[j2] != null) {
                    osw.write(Problem.subStr(a[j2].shortCut, 4) + "|");
                    ++writtenSlots;
                } else if (allResources.get((int)i).preference.isHARD(j2)) {
                    osw.write("XXXX|");
                } else {
                    osw.write("    |");
                }
                ++j2;
            }
            osw.write("\n");
            int r = 0;
            while (r < size) {
                if (r != order) {
                    osw.write("    |");
                    int j3 = 0;
                    while (j3 < this.nrSlots) {
                        if (a[j3] != null) {
                            osw.write(Problem.subStr(a[j3].selectedResources.getResource((int)r).shortCut, 4) + "|");
                        } else {
                            osw.write("    |");
                        }
                        ++j3;
                    }
                    osw.write("\n");
                }
                ++r;
            }
            this.writeLine(osw);
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ResourceGroup allResources = new ResourceGroup();
        int i = 0;
        while (i < this.resources.length) {
            int j = 0;
            while (j < this.resources[i].size()) {
                allResources.add(this.resources[i].get(j));
                ++j;
            }
            ++i;
        }
        out.writeObject(this.config);
        allResources.write(out, this.activities);
        this.activities.write(out, allResources);
        out.writeInt(this.resources.length);
        int i2 = 0;
        while (i2 < this.resources.length) {
            this.resources[i2].write(out, allResources);
            ++i2;
        }
        this.dependences.write(out, this.activities);
        this.groupOfParalelActivities.write(out, allResources);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, TimetableException, Exception {
        this.config = (Config)in.readObject();
        this.nrSlots = this.config.getInt(Config.NR_SLOTS);
        ResourceGroup allResources = ResourceGroup.read(in, this.config);
        this.activities = ActivityGroup.read(in, this.config, allResources);
        allResources.init(this.activities);
        this.resources = new ResourceGroup[in.readInt()];
        int i = 0;
        while (i < this.resources.length) {
            this.resources[i] = ResourceGroup.read(in, allResources);
            ++i;
        }
        this.dependences = ActivityDependenceGroup.read(in, this.activities, this.config);
        this.groupOfParalelActivities = ActivityGroup.read(in, this.config, allResources);
    }

    public void save(String file) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        try {
            oos.writeObject(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oos.flush();
            oos.close();
            throw throwable;
        }
        oos.flush();
        oos.close();
    }

    public static Problem load(String file) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        Problem p = null;
        try {
            p = (Problem)ois.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ois.close();
            throw throwable;
        }
        ois.close();
        return p;
    }
}

