/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.webutil;

import edu.purdue.smas.timetable.Web;
import edu.purdue.smas.timetable.data.Building;
import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.ITypes;
import edu.purdue.smas.timetable.data.Instructor;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.Room;
import edu.purdue.smas.timetable.data.Timetable;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TimeMatrixTables {
    String dayFilter;
    String bldgFilter;
    String roomFilter;
    String instrFilter;
    boolean eveningFilter;
    int prefDisp;
    int orderBy;
    int visualisation;
    int tblType;
    Vector rooms;
    Hashtable roomsHash;
    Vector instructors;
    Hashtable buildings;
    Hashtable classes;
    Hashtable timetablesHash;
    Vector timetables;
    Hashtable room2slots;
    Hashtable instr2slots;
    int nrDays = 6;
    boolean allExSat = false;
    static /* synthetic */ Class class$edu$purdue$smas$timetable$data$Timetable;

    public TimeMatrixTables(HttpServletRequest request, HttpSession session) throws SQLException, TTException {
        this.dayFilter = (String)session.getAttribute("Timetable.FilterDay");
        this.bldgFilter = (String)session.getAttribute("Timetable.FilterBuilding");
        this.roomFilter = (String)session.getAttribute("Timetable.FilterRoom");
        this.instrFilter = (String)session.getAttribute("Timetable.FilterInstructor");
        this.eveningFilter = session.getAttribute("Timetable.FilterEvenings") == null ? true : (Boolean)session.getAttribute("Timetable.FilterEvenings");
        this.prefDisp = session.getAttribute("Timetable.PrefDisp") == null ? 0 : (Integer)session.getAttribute("Timetable.PrefDisp");
        this.orderBy = session.getAttribute("Timetable.OrderBy") == null ? 0 : (Integer)session.getAttribute("Timetable.OrderBy");
        this.visualisation = session.getAttribute("Timetable.Visualisation") == null ? 0 : (Integer)session.getAttribute("Timetable.Visualisation");
        int n = this.tblType = session.getAttribute("Timetable.Type") == null ? 0 : (Integer)session.getAttribute("Timetable.Type");
        if (request.getParameter("op") != null && request.getParameter("op").equals("apply")) {
            this.visualisation = Integer.parseInt(request.getParameter("visualisation"));
            session.setAttribute("Timetable.Visualisation", (Object)new Integer(this.visualisation));
            if (this.visualisation == 1) {
                this.dayFilter = "";
            }
            this.dayFilter = request.getParameter("day_filter");
            session.setAttribute("Timetable.FilterDay", (Object)this.dayFilter);
            this.bldgFilter = request.getParameter("bldg_filter");
            session.setAttribute("Timetable.FilterBuilding", (Object)this.bldgFilter);
            this.roomFilter = request.getParameter("room_filter");
            session.setAttribute("Timetable.FilterRoom", (Object)(this.roomFilter == null ? "" : this.roomFilter));
            this.orderBy = Integer.parseInt(request.getParameter("order_by"));
            session.setAttribute("Timetable.OrderBy", (Object)new Integer(this.orderBy));
            this.prefDisp = Integer.parseInt(request.getParameter("pref_disp"));
            session.setAttribute("Timetable.PrefDisp", (Object)new Integer(this.prefDisp));
            this.tblType = Integer.parseInt(request.getParameter("type_filter"));
            session.setAttribute("Timetable.Type", (Object)new Integer(this.tblType));
            this.instrFilter = request.getParameter("instr_filter");
            session.setAttribute("Timetable.FilterInstructor", (Object)this.instrFilter);
            this.eveningFilter = request.getParameter("evening_filter") == null;
            session.setAttribute("Timetable.FilterEvenings", (Object)new Boolean(this.eveningFilter));
        }
        this.rooms = Room.loadAll(Web.getVersionNumber(session));
        this.roomsHash = Room.loadAllHash(Web.getVersionNumber(session));
        this.instructors = Instructor.loadAll(Web.getVersionNumber(session));
        this.buildings = Building.loadAllHash(Web.getVersionNumber(session));
        Collections.sort(this.rooms, this.orderBy == 0 ? new Room.RoomComparator(this.buildings) : new Room.RoomOrdComparator(this.buildings));
        this.classes = edu.purdue.smas.timetable.data.Class.loadAllHash(Web.getVersionNumber(session));
        this.timetablesHash = Timetable.loadAllHash(Web.getVersionNumber(session));
        Vector timetables = new Vector();
        Enumeration e = this.timetablesHash.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            Enumeration x = v.elements();
            while (x.hasMoreElements()) {
                timetables.addElement(x.nextElement());
            }
        }
        this.room2slots = this.tblType == 0 ? Timetable.getRoomSlotArry(timetables) : null;
        Hashtable hashtable = this.instr2slots = this.tblType == 1 ? this.getInstrSlotArry(this.classes, timetables) : null;
        if (this.dayFilter != null && this.dayFilter.equals("notSat")) {
            this.allExSat = true;
        }
    }

    private String tableCell(String contents, String align, String valign, boolean nowrap, String cellWidth, String cellHeight, String color, String image) {
        StringBuffer text = new StringBuffer();
        return text.toString();
    }

    private String pref2color(Preferences.Preference pref) {
        if (pref.getProlog().equals("R")) {
            return "rgb(80,80,200)";
        }
        if (pref.getProlog().equals("-2")) {
            return "rgb(40,180,60)";
        }
        if (pref.getProlog().equals("-1")) {
            return "rgb(170,240,60)";
        }
        if (pref.getProlog().equals("0")) {
            return "rgb(240,240,240)";
        }
        if (pref.getProlog().equals("1")) {
            return "rgb(240,210,60)";
        }
        if (pref.getProlog().equals("2")) {
            return "rgb(240,120,60)";
        }
        if (pref.getProlog().equals("P")) {
            return "rgb(220,50,40)";
        }
        return null;
    }

    private Hashtable getInstrSlotArry(Hashtable classes, Vector allTimetables) throws TTException {
        Hashtable<String, Timetable[]> ret = new Hashtable<String, Timetable[]>();
        Enumeration e = allTimetables.elements();
        while (e.hasMoreElements()) {
            Timetable[] table;
            Timetable t = (Timetable)e.nextElement();
            edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)classes.get(new Long(t.getClassId()));
            if (c.getInstructorId() == null) continue;
            Timetable[] timetableArray = table = ret.containsKey(c.getInstructorId()) ? (Timetable[])ret.get(c.getInstructorId()) : null;
            if (table == null) {
                table = new Timetable[Constants.SLOTS_PER_DAY * Constants.DAY_CODES.length];
                for (int i = 0; i < table.length; ++i) {
                    table[i] = null;
                }
                ret.put(c.getInstructorId(), table);
            }
            if (table[t.getSlot()] != null) {
                throw new TTException(class$edu$purdue$smas$timetable$data$Timetable == null ? (class$edu$purdue$smas$timetable$data$Timetable = TimeMatrixTables.class$("edu.purdue.smas.timetable.data.Timetable")) : class$edu$purdue$smas$timetable$data$Timetable, "Slot " + t.getSlot() + " used more than once.");
            }
            table[t.getSlot()] = t;
        }
        return ret;
    }

    private StringBuffer getTitleInfo(Timetable timeTable) {
        StringBuffer title = new StringBuffer();
        if (timeTable.getInfo() != null) {
            title.append(" title='VarOrdNum:" + timeTable.getInfo().getVarOrdNum() + ", " + "AssignNum:" + timeTable.getInfo().getAssignNum() + ", " + "MinTime:" + timeTable.getInfo().getMinTime() + ", " + "FacPref:" + timeTable.getInfo().getFacPref() + ", " + "StudConf:" + timeTable.getInfo().getStudConf() + ", " + "MinRoom:" + timeTable.getInfo().getMinRoom() + ", " + "RoomPref:" + timeTable.getInfo().getRoomPref() + "' ");
        }
        return title;
    }

    private String getIdForClassMeeting(Timetable timeTable) {
        return "'" + timeTable.getClassId() + "." + timeTable.getMtgNumber() + "'";
    }

    private void getMouseOverAndMouseOut(StringBuffer onMouseOver, StringBuffer onMouseOut, edu.purdue.smas.timetable.data.Class aClass, String border) {
        onMouseOver.append(" onmouseover=\"");
        onMouseOut.append(" onmouseout=\"");
        if (this.visualisation == 1) {
            Enumeration te = ((Vector)this.timetablesHash.get(new Long(aClass.getId()))).elements();
            while (te.hasMoreElements()) {
                Timetable x = (Timetable)te.nextElement();
                boolean f = this.allExSat ? x.getDay().equals(Constants.DAY_NAMES_SHORT[5]) : (this.dayFilter == null || this.dayFilter.length() == 0 ? false : !this.dayFilter.equals(x.getDay()));
                if (f) continue;
                onMouseOver.append("document.getElementById(" + this.getIdForClassMeeting(x) + ").style.backgroundColor='rgb(223,231,242)';");
                onMouseOut.append("document.getElementById(" + this.getIdForClassMeeting(x) + ").style.backgroundColor='" + (border == null ? "transparent" : border) + "';");
            }
        } else {
            onMouseOver.append("this.style.backgroundColor='rgb(223,231,242)';");
            onMouseOut.append("this.style.backgroundColor='" + (border == null ? "transparent" : border) + "';");
        }
        onMouseOver.append("this.style.cursor='hand';\" ");
        onMouseOut.append("\" ");
    }

    private String getBorderValue(edu.purdue.smas.timetable.data.Class aClass, Room room, Building bldg, int slot) throws SQLException, TTException {
        String border = null;
        if (this.prefDisp == 1) {
            Preferences.Preference timePref = null;
            Vector xtimetables = (Vector)this.timetablesHash.get(new Long(aClass.getId()));
            long slotTime = StandardTimePattern.getTime(7 + (slot + 1) / 2, slot % 2 == 0 ? 30 : 0, 0);
            Enumeration tre = aClass.getTimeRequirements().keys();
            while (timePref == null && tre.hasMoreElements()) {
                Class.TimeRequirement tr = (Class.TimeRequirement)tre.nextElement();
                boolean match = true;
                Enumeration tme = xtimetables.elements();
                while (match && tme.hasMoreElements()) {
                    Timetable xt = (Timetable)tme.nextElement();
                    int d = -1;
                    for (int x = 0; d < 0 && x < Constants.DAY_NAMES_SHORT.length; ++x) {
                        if (!xt.getDay().equals(Constants.DAY_NAMES_SHORT[x])) continue;
                        d = x;
                    }
                    if (d < 0) {
                        match = false;
                        break;
                    }
                    long st = StandardTimePattern.getTime(7 + (xt.getHalfHour() + 1) / 2, xt.getHalfHour() % 2 == 0 ? 30 : 0, 0);
                    if (tr.getDays()[d] && (tr.getEndTime() == null && tr.getStartTime().getTime() == st || tr.getEndTime() != null && tr.getStartTime().getTime() <= st && tr.getEndTime().getTime() >= st)) continue;
                    match = false;
                }
                if (!match) continue;
                timePref = (Preferences.Preference)aClass.getTimeRequirements().get(tr);
            }
            border = timePref == null ? null : this.pref2color(timePref);
        } else if (this.prefDisp == 2 && room != null) {
            Preferences.Preference roomPref = null;
            if (aClass.getRequiredRooms().containsKey(room)) {
                roomPref = (Preferences.Preference)aClass.getRequiredRooms().get(room);
            }
            border = roomPref == null ? null : this.pref2color(roomPref);
        } else if (this.prefDisp == 3 && bldg != null) {
            Preferences.Preference roomPref = null;
            if (aClass.getRequiredBuildings().containsKey(bldg)) {
                roomPref = (Preferences.Preference)aClass.getRequiredBuildings().get(bldg);
            }
            border = roomPref == null ? null : this.pref2color(roomPref);
        } else {
            return null;
        }
        return border;
    }

    public String buildTable(HttpSession session, boolean timeVertical) throws SQLException, TTException {
        Enumeration e;
        StringBuffer tableHtml = new StringBuffer();
        tableHtml.append("<table border='0' cellpadding='2' cellspacing='0' >");
        int rowNumber = 0;
        Enumeration enumeration = e = this.tblType == 0 ? this.rooms.elements() : this.instructors.elements();
        while (e.hasMoreElements()) {
            boolean eol;
            boolean eod;
            Instructor instr;
            Room room = this.tblType == 0 ? (Room)e.nextElement() : null;
            Building bldg = this.tblType == 0 ? (Building)this.buildings.get(room.getBldgId()) : null;
            Instructor instructor = instr = this.tblType == 1 ? (Instructor)e.nextElement() : null;
            if (instr != null && !this.instr2slots.containsKey(instr.getId())) continue;
            Timetable[] table = (Timetable[])(this.tblType == 0 ? this.room2slots.get(room.getId()) : this.instr2slots.get(instr.getId()));
            if (bldg != null && this.bldgFilter != null && this.bldgFilter.length() > 0 && !this.bldgFilter.equals(bldg.getId()) || room != null && this.roomFilter != null && this.roomFilter.length() > 0 && !this.roomFilter.equals(room.getId()) || instr != null && this.instrFilter != null && this.instrFilter.length() > 0 && !this.instrFilter.equals(instr.getId())) continue;
            if (this.visualisation == 1 || rowNumber % 10 == 0) {
                String sfx2 = "";
                if (timeVertical && this.visualisation == 1) {
                    sfx2 = sfx2 + "Vertical";
                }
                tableHtml.append("<tr valign='top'><th class='Timetable" + (rowNumber == 0 ? "Head" : "") + "Cell" + sfx2 + "'>" + (this.visualisation == 1 ? (this.tblType == 0 ? bldg.getABBV() + "<br>" + room.getRoomNo() : instr.getName()) : "") + "</th>");
                if (!timeVertical || this.visualisation == 0) {
                    for (int day = 0; this.visualisation == 0 && day < this.nrDays || this.visualisation == 1 && day < 1; ++day) {
                        boolean filter;
                        String dayCode = Constants.DAY_NAMES_SHORT[day];
                        boolean bl = this.allExSat ? day == 5 : (this.dayFilter == null || this.dayFilter.length() == 0 ? false : (filter = !this.dayFilter.equals(dayCode)));
                        if (this.visualisation != 1 && filter) continue;
                        for (int slot = 0; slot < (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY); ++slot) {
                            int hour = 7 + (slot + 1) / 2;
                            int min = slot % 2 == 0 ? 30 : 0;
                            eod = slot + 1 == (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY);
                            boolean bl2 = eol = eod && this.visualisation == 1;
                            if (eod && this.visualisation == 0) {
                                eol = true;
                                for (int j = day + 1; j < this.nrDays; ++j) {
                                    boolean f;
                                    boolean bl3 = this.allExSat ? j == 5 : (this.dayFilter == null || this.dayFilter.length() == 0 ? false : (f = !this.dayFilter.equals(Constants.DAY_NAMES_SHORT[j])));
                                    if (f) continue;
                                    eol = false;
                                }
                            }
                            if (min == 30) {
                                tableHtml.append("<th height='40' width='40' class='Timetable" + (rowNumber == 0 ? "Head" : "") + "Cell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "'>" + (this.visualisation == 1 ? "" : Constants.DAY_NAME[day] + "<br>") + (hour > 12 ? hour - 12 : hour) + ":" + (min < 10 ? "0" : "") + min + (hour > 12 ? "p" : "a") + "</th>");
                                continue;
                            }
                            tableHtml.append("<th height='40' width='40' class='Timetable" + (rowNumber == 0 ? "Head" : "") + "Cell" + (eol ? "EOL" : (eod ? "EOD" : "In")) + "'>&nbsp;</th>");
                        }
                    }
                } else if (timeVertical && this.visualisation == 1) {
                    for (int day = 0; day < this.nrDays; ++day) {
                        String dayCode = Constants.DAY_NAMES_SHORT[day];
                        if (this.allExSat ? day == 5 : this.dayFilter != null && this.dayFilter.length() != 0 && !this.dayFilter.equals(dayCode)) continue;
                        String sfx = "";
                        if (day + 1 == this.nrDays || this.allExSat && day == 4 || !this.allExSat && this.dayFilter != null && !this.dayFilter.equals("")) {
                            sfx = sfx + "EOL";
                        }
                        tableHtml.append("<th height='40' width='40' class='TimetableHeadCellVertical" + sfx + "'>" + Constants.DAY_NAME[day] + "</th>");
                    }
                }
                tableHtml.append("</tr>");
            }
            tableHtml.append("<tr valign='top'>");
            if (this.visualisation == 0) {
                tableHtml.append("<th height='40' class='Timetable" + (rowNumber % 10 == 0 ? "Head" : "") + "Cell'>" + (this.tblType == 0 ? bldg.getABBV() + "<br>" + room.getRoomNo() : instr.getName()) + "</th>");
            }
            if (!timeVertical || this.visualisation == 0) {
                for (int day = 0; day < this.nrDays; ++day) {
                    String dayCode = Constants.DAY_NAMES_SHORT[day];
                    if (!this.allExSat ? this.dayFilter != null && this.dayFilter.length() != 0 && !this.dayFilter.equals(dayCode) : day == 5) continue;
                    if (this.visualisation == 1) {
                        tableHtml.append((day > 0 && (this.dayFilter == null || !this.dayFilter.equals(dayCode)) ? "</tr><tr valign='top'>" : "") + "<th height='40' class='TimetableCell'>" + Constants.DAY_NAME[day] + "</th>");
                    }
                    for (int slot = 0; slot < (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY); ++slot) {
                        int slotsToEnd = (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY) - slot;
                        if (table == null || table[day * Constants.SLOTS_PER_DAY + slot] == null) {
                            boolean eol2;
                            boolean eod2 = slot + 1 == (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY);
                            boolean bl = eol2 = eod2 && this.visualisation == 1;
                            if (eod2 && this.visualisation == 0) {
                                eol2 = true;
                                for (int j = day + 1; j < this.nrDays; ++j) {
                                    boolean f;
                                    boolean bl4 = this.allExSat ? j == 5 : (this.dayFilter == null || this.dayFilter.length() == 0 ? false : (f = !this.dayFilter.equals(Constants.DAY_NAMES_SHORT[j])));
                                    if (f) continue;
                                    eol2 = false;
                                }
                            }
                            tableHtml.append("<td class='TimetableCell" + (eol2 ? "EOL" : (eod2 ? "EOD" : "")) + "'>&nbsp;</td>");
                            continue;
                        }
                        Timetable t = table[day * Constants.SLOTS_PER_DAY + slot];
                        edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)this.classes.get(new Long(t.getClassId()));
                        if (this.tblType == 1) {
                            room = t.getRoomId() == null ? null : (Room)this.roomsHash.get(t.getRoomId());
                            bldg = room == null ? null : (Building)this.buildings.get(room.getBldgId());
                        }
                        String border = this.getBorderValue(c, room, bldg, slot);
                        eod = slot + t.getHalfHoursPerMtg() == (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY);
                        boolean bl = eol = eod && this.visualisation == 1;
                        if (eod && this.visualisation == 0) {
                            eol = true;
                            for (int j = day + 1; j < this.nrDays; ++j) {
                                boolean f;
                                boolean bl5 = this.allExSat ? j == 5 : (this.dayFilter == null || this.dayFilter.length() == 0 ? false : (f = !this.dayFilter.equals(Constants.DAY_NAMES_SHORT[j])));
                                if (f) continue;
                                eol = false;
                            }
                        }
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, c, border);
                        tableHtml.append("<td nowrap " + (border == null ? "" : "style='background-color:" + border + "'") + " class='TimetableCell" + (eol ? "EOL" : (eod ? "EOD" : "")) + "' align='center' colspan='" + Math.min(t.getHalfHoursPerMtg(), slotsToEnd) + "' onclick=\"document.location='../input/class_edit.jsp?id=" + c.getId() + "'\" id=" + this.getIdForClassMeeting(t) + onMouseOver + onMouseOut + this.getTitleInfo(t) + ">");
                        tableHtml.append(c.getSubject() + c.getCourseNumber() + " " + ITypes.getDescription(c.getIType()) + " " + c.getSection());
                        if (t.getInfo() != null) {
                            tableHtml.append("<br><span style='color:rgb(200,200,200);'>" + (t.getInfo().getMinTime() < t.getInfo().getFacPref() ? "<span style='color:red'>" + (t.getInfo().getFacPref() - t.getInfo().getMinTime()) + "</span>" : "" + (t.getInfo().getFacPref() - t.getInfo().getMinTime())) + ", " + (t.getInfo().getStudConf() > 0L ? "<span style='color:rgb(20,130,10)'>" + t.getInfo().getStudConf() + "</span>" : "" + t.getInfo().getStudConf()) + ", " + (t.getInfo().getMinRoom() < t.getInfo().getRoomPref() ? "<span style='color:blue'>" + (t.getInfo().getRoomPref() - t.getInfo().getMinRoom()) + "</span>" : "" + (t.getInfo().getRoomPref() - t.getInfo().getMinRoom())));
                        }
                        tableHtml.append("</span></td>");
                        slot += t.getHalfHoursPerMtg() - 1;
                    }
                }
            } else if (timeVertical && this.visualisation == 1) {
                int[] rowsToSpan = new int[]{0, 0, 0, 0, 0, 0};
                for (int slot = 0; slot < (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY); ++slot) {
                    int hour = 7 + (slot + 1) / 2;
                    int min = slot % 2 == 0 ? 30 : 0;
                    int slotsToEnd = (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY) - slot;
                    if (slot % 2 == 0) {
                        tableHtml.append("<th height='40' width='40' class='TimetableHeadCell'>" + (hour > 12 ? hour - 12 : hour) + ":" + (min < 10 ? "0" : "") + min + (hour > 12 ? "p" : "a") + "</th>");
                    } else {
                        tableHtml.append("<th height='40' width='40' class='TimetableHeadCellInVertical'>&nbsp;</th>");
                    }
                    for (int day = 0; day < this.nrDays; ++day) {
                        String dayCode = Constants.DAY_NAMES_SHORT[day];
                        if (!this.allExSat ? this.dayFilter != null && this.dayFilter.length() != 0 && !this.dayFilter.equals(dayCode) : day == 5) continue;
                        if (table == null || table[day * Constants.SLOTS_PER_DAY + slot] == null) {
                            String sfx = "";
                            if (slot % 2 == 1) {
                                sfx = "In";
                            }
                            sfx = sfx + "Vertical";
                            if (this.nrDays == day + 1 || this.allExSat && this.nrDays == day + 2 || !this.allExSat && this.dayFilter != null && !this.dayFilter.equals("")) {
                                sfx = sfx + "EOL";
                            }
                            if (rowsToSpan[day] != 0) {
                                rowsToSpan[day] = rowsToSpan[day] - 1;
                                continue;
                            }
                            tableHtml.append("<td class='TimetableCell" + sfx + "'>&nbsp;</td>");
                            continue;
                        }
                        Timetable t = table[day * Constants.SLOTS_PER_DAY + slot];
                        edu.purdue.smas.timetable.data.Class c = (edu.purdue.smas.timetable.data.Class)this.classes.get(new Long(t.getClassId()));
                        if (this.tblType == 1) {
                            room = t.getRoomId() == null ? null : (Room)this.roomsHash.get(t.getRoomId());
                            bldg = room == null ? null : (Building)this.buildings.get(room.getBldgId());
                        }
                        String border = this.getBorderValue(c, room, bldg, slot);
                        StringBuffer onMouseOver = new StringBuffer();
                        StringBuffer onMouseOut = new StringBuffer();
                        this.getMouseOverAndMouseOut(onMouseOver, onMouseOut, c, border);
                        rowsToSpan[day] = Math.min(t.getHalfHoursPerMtg(), slotsToEnd);
                        String sfx = "";
                        if (this.nrDays == day + 1 || this.allExSat && this.nrDays == day + 2 || !this.allExSat && this.dayFilter != null && !this.dayFilter.equals("")) {
                            sfx = sfx + "EOL";
                        }
                        tableHtml.append("<td nowrap " + (border == null ? "" : "style='background-color:" + border + "'") + " class='TimetableCellVertical" + sfx + "' align='center' rowspan='" + rowsToSpan[day] + "' onclick=\"document.location='../input/class_edit.jsp?id=" + c.getId() + "'\" id=" + this.getIdForClassMeeting(t) + onMouseOver + onMouseOut + this.getTitleInfo(t) + ">");
                        rowsToSpan[day] = rowsToSpan[day] - 1;
                        tableHtml.append(c.getSubject() + c.getCourseNumber() + " " + ITypes.getDescription(c.getIType()) + " " + c.getSection());
                        if (t.getInfo() != null) {
                            tableHtml.append("<br><span style='color:rgb(200,200,200);'>" + (t.getInfo().getMinTime() < t.getInfo().getFacPref() ? "<span style='color:red'>" + (t.getInfo().getFacPref() - t.getInfo().getMinTime()) + "</span>" : "" + (t.getInfo().getFacPref() - t.getInfo().getMinTime())) + ", " + (t.getInfo().getStudConf() > 0L ? "<span style='color:rgb(20,130,10)'>" + t.getInfo().getStudConf() + "</span>" : "" + t.getInfo().getStudConf()) + ", " + (t.getInfo().getMinRoom() < t.getInfo().getRoomPref() ? "<span style='color:blue'>" + (t.getInfo().getRoomPref() - t.getInfo().getMinRoom()) + "</span>" : "" + (t.getInfo().getRoomPref() - t.getInfo().getMinRoom())));
                        }
                        tableHtml.append("</span></td>");
                    }
                    tableHtml.append("</tr><tr valign='top'>");
                    if (slot + 1 != (this.eveningFilter ? Constants.SLOTS_PER_DAY_NO_EVENINGS : Constants.SLOTS_PER_DAY)) continue;
                    tableHtml.append("<td>&nbsp;</td>");
                }
            }
            tableHtml.append("</tr>");
            ++rowNumber;
        }
        tableHtml.append("</table>");
        return tableHtml.toString();
    }

    public String getBldgFilter() {
        return this.bldgFilter;
    }

    public String getDayFilter() {
        return this.dayFilter;
    }

    public boolean isEveningFilter() {
        return this.eveningFilter;
    }

    public String getInstrFilter() {
        return this.instrFilter;
    }

    public int getOrderBy() {
        return this.orderBy;
    }

    public int getPrefDisp() {
        return this.prefDisp;
    }

    public String getRoomFilter() {
        return this.roomFilter;
    }

    public int getTblType() {
        return this.tblType;
    }

    public int getVisualisation() {
        return this.visualisation;
    }

    public void setBldgFilter(String string) {
        this.bldgFilter = string;
    }

    public void setDayFilter(String string) {
        this.dayFilter = string;
    }

    public void setEveningFilter(boolean b) {
        this.eveningFilter = b;
    }

    public void setInstrFilter(String string) {
        this.instrFilter = string;
    }

    public void setOrderBy(int i) {
        this.orderBy = i;
    }

    public void setPrefDisp(int i) {
        this.prefDisp = i;
    }

    public void setRoomFilter(String string) {
        this.roomFilter = string;
    }

    public void setTblType(int i) {
        this.tblType = i;
    }

    public void setVisualisation(int i) {
        this.visualisation = i;
    }

    public Hashtable getBuildings() {
        return this.buildings;
    }

    public Hashtable getClasses() {
        return this.classes;
    }

    public Vector getInstructors() {
        return this.instructors;
    }

    public Vector getRooms() {
        return this.rooms;
    }

    public Hashtable getRoomsHash() {
        return this.roomsHash;
    }

    public Vector getTimetables() {
        return this.timetables;
    }

    public Hashtable getTimetablesHash() {
        return this.timetablesHash;
    }

    public void setBuildings(Hashtable hashtable) {
        this.buildings = hashtable;
    }

    public void setClasses(Hashtable hashtable) {
        this.classes = hashtable;
    }

    public void setInstructors(Vector vector) {
        this.instructors = vector;
    }

    public void setRooms(Vector vector) {
        this.rooms = vector;
    }

    public void setRoomsHash(Hashtable hashtable) {
        this.roomsHash = hashtable;
    }

    public void setTimetables(Vector vector) {
        this.timetables = vector;
    }

    public void setTimetablesHash(Hashtable hashtable) {
        this.timetablesHash = hashtable;
    }

    public Hashtable getInstr2slots() {
        return this.instr2slots;
    }

    public Hashtable getRoom2slots() {
        return this.room2slots;
    }

    public void setInstr2slots(Hashtable hashtable) {
        this.instr2slots = hashtable;
    }

    public void setRoom2slots(Hashtable hashtable) {
        this.room2slots = hashtable;
    }

    public boolean isAllExSat() {
        return this.allExSat;
    }

    public int getNrDays() {
        return this.nrDays;
    }

    public void setAllExSat(boolean b) {
        this.allExSat = b;
    }

    public void setNrDays(int i) {
        this.nrDays = i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

