/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Sha
extends InputStream {
    private long[] shaHash = new long[]{1732584193L, 4023233417L, 2562383102L, 271733878L, 3285377520L};
    private static long[] K = new long[]{1518500249L, 1859775393L, 2400959708L, 3395469782L};
    private int[] message = new int[64];
    private int pos = 0;
    private InputStream parent = null;
    private long bitsize = 0L;

    public Sha(InputStream is) {
        this.parent = is;
    }

    public int read() throws IOException {
        int i = this.parent.read();
        if (i < 0) {
            if (this.pos >= 0) {
                this.shaProcessEnd();
                this.pos = -1;
            }
        } else {
            this.message[this.pos++] = i;
            if (this.pos == 64) {
                this.shaProcess();
                this.pos = 0;
            }
            this.bitsize += 8L;
        }
        return i;
    }

    public static long rotate(long word, int n) {
        return (word << n | word >> 32 - n) & 0xFFFFFFFFL;
    }

    private static String int2hex(long i) {
        String hex = Integer.toHexString((int)i);
        return "00000000".substring(0, 8 - hex.length()) + hex;
    }

    public String toString() {
        return Sha.int2hex(this.shaHash[0]) + " " + Sha.int2hex(this.shaHash[1]) + " " + Sha.int2hex(this.shaHash[2]) + " " + Sha.int2hex(this.shaHash[3]) + " " + Sha.int2hex(this.shaHash[4]);
    }

    public String getCode() {
        return Sha.int2hex(this.shaHash[0]) + Sha.int2hex(this.shaHash[1]) + Sha.int2hex(this.shaHash[2]) + Sha.int2hex(this.shaHash[3]) + Sha.int2hex(this.shaHash[4]);
    }

    private void shaProcess() {
        long temp;
        int t;
        long[] W = new long[80];
        for (t = 0; t < 16; ++t) {
            W[t] = this.message[t * 4] << 24 | this.message[t * 4 + 1] << 16 | this.message[t * 4 + 2] << 8 | this.message[t * 4 + 3];
        }
        for (t = 16; t < 80; ++t) {
            W[t] = Sha.rotate((W[t - 3] ^ W[t - 8] ^ W[t - 14] ^ W[t - 16]) & 0xFFFFFFFFL, 1);
        }
        long A = this.shaHash[0];
        long B = this.shaHash[1];
        long C = this.shaHash[2];
        long D = this.shaHash[3];
        long E = this.shaHash[4];
        for (t = 0; t < 20; ++t) {
            temp = Sha.rotate(A, 5) + (B & C | (B ^ 0xFFFFFFFFFFFFFFFFL) & D) + E + W[t] + K[0] & 0xFFFFFFFFL;
            E = D;
            D = C;
            C = Sha.rotate(B, 30);
            B = A;
            A = temp;
        }
        for (t = 20; t < 40; ++t) {
            temp = Sha.rotate(A, 5) + (B ^ C ^ D) + E + W[t] + K[1] & 0xFFFFFFFFL;
            E = D;
            D = C;
            C = Sha.rotate(B, 30);
            B = A;
            A = temp;
        }
        for (t = 40; t < 60; ++t) {
            temp = Sha.rotate(A, 5) + (B & C | B & D | C & D) + E + W[t] + K[2] & 0xFFFFFFFFL;
            E = D;
            D = C;
            C = Sha.rotate(B, 30);
            B = A;
            A = temp;
        }
        for (t = 60; t < 80; ++t) {
            temp = Sha.rotate(A, 5) + (B ^ C ^ D) + E + W[t] + K[3] & 0xFFFFFFFFL;
            E = D;
            D = C;
            C = Sha.rotate(B, 30);
            B = A;
            A = temp;
        }
        this.shaHash[0] = this.shaHash[0] + A;
        this.shaHash[1] = this.shaHash[1] + B;
        this.shaHash[2] = this.shaHash[2] + C;
        this.shaHash[3] = this.shaHash[3] + D;
        this.shaHash[4] = this.shaHash[4] + E;
        int i = 0;
        while (i < 5) {
            int n = i++;
            this.shaHash[n] = this.shaHash[n] & 0xFFFFFFFFL;
        }
    }

    private void shaProcessEnd() {
        if (this.pos > 55) {
            this.message[this.pos++] = 128;
            while (this.pos < 64) {
                this.message[this.pos++] = 0;
            }
            this.shaProcess();
            this.pos = 0;
            while (this.pos < 56) {
                this.message[this.pos++] = 0;
            }
        } else {
            this.message[this.pos++] = 128;
            while (this.pos < 56) {
                this.message[this.pos++] = 0;
            }
        }
        this.message[56] = (char)(this.bitsize >> 56 & 0xFFL);
        this.message[57] = (char)(this.bitsize >> 48 & 0xFFL);
        this.message[58] = (char)(this.bitsize >> 40 & 0xFFL);
        this.message[59] = (char)(this.bitsize >> 32 & 0xFFL);
        this.message[60] = (char)(this.bitsize >> 24 & 0xFFL);
        this.message[61] = (char)(this.bitsize >> 16 & 0xFFL);
        this.message[62] = (char)(this.bitsize >> 8 & 0xFFL);
        this.message[63] = (char)(this.bitsize & 0xFFL);
        this.shaProcess();
    }

    public static String getCode(String text) throws TTException {
        if (text == null) {
            return null;
        }
        try {
            byte[] buf = new byte[text.length()];
            for (int i = 0; i < text.length(); ++i) {
                buf[i] = (byte)text.charAt(i);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            Sha sha = new Sha(is);
            while (sha.read() >= 0) {
            }
            is.close();
            return sha.getCode();
        }
        catch (Exception e) {
            Debug.error(e);
            throw new TTException(e);
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("HASH(admin)=" + Sha.getCode("admin"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

