/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.util;

import edu.purdue.smas.timetable.util.TTException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Config {
    private static Properties sProperties = null;
    static /* synthetic */ Class class$edu$purdue$smas$timetable$util$Config;

    public static boolean containsKey(String key) {
        if (sProperties == null) {
            return false;
        }
        return sProperties.containsKey(key);
    }

    public static String get(String key) {
        if (sProperties == null) {
            return null;
        }
        return sProperties.getProperty(key);
    }

    public static int getInt(String key) {
        if (sProperties == null) {
            return 0;
        }
        return Integer.parseInt(sProperties.getProperty(key, "0"));
    }

    public static long getLong(String key) {
        if (sProperties == null) {
            return 0L;
        }
        return Long.parseLong(sProperties.getProperty(key, "0"));
    }

    public static double getDouble(String key) {
        if (sProperties == null) {
            return 0.0;
        }
        return Double.parseDouble(sProperties.getProperty(key, "0"));
    }

    public static String get(String key, String defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return sProperties.getProperty(key, defaultVal);
    }

    public static int getInt(String key, int defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Integer.parseInt(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static long getLong(String key, long defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Long.parseLong(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static double getDouble(String key, double defaultVal) {
        if (sProperties == null) {
            return defaultVal;
        }
        return Double.parseDouble(sProperties.getProperty(key, String.valueOf(defaultVal)));
    }

    public static synchronized void init(File propertyFile) throws TTException {
        sProperties = new Properties();
        try {
            System.out.println("Loading config file '" + propertyFile.getCanonicalPath() + "' ... ");
            FileInputStream is = new FileInputStream(propertyFile);
            sProperties.load(is);
            is.close();
            if (sProperties.getProperty("INCLUDE") != null) {
                is = null;
                StringTokenizer stk = new StringTokenizer(sProperties.getProperty("INCLUDE"), ";");
                while (stk.hasMoreTokens()) {
                    String aFile = stk.nextToken();
                    System.out.println("  Loading included file '" + aFile + "' ... ");
                    if (new File(aFile).exists()) {
                        is = new FileInputStream(aFile);
                    }
                    if (new File(propertyFile.getParent() + File.separator + aFile).exists()) {
                        is = new FileInputStream(propertyFile.getParent() + File.separator + aFile);
                    }
                    if (is == null) {
                        System.err.println("Unable to find include file '" + aFile + "'.");
                    }
                    sProperties.load(is);
                    is.close();
                }
                sProperties.remove("INCLUDE");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TTException(class$edu$purdue$smas$timetable$util$Config == null ? (class$edu$purdue$smas$timetable$util$Config = Config.class$("edu.purdue.smas.timetable.util.Config")) : class$edu$purdue$smas$timetable$util$Config, TTException.getErrorCode("IOException"), "Unable to read config file: " + propertyFile);
        }
    }

    public static synchronized void init(InputStream is) throws TTException {
        sProperties = new Properties();
        try {
            System.err.println("Loading config file from '" + is + "' ... ");
            sProperties.load(is);
            is.close();
        }
        catch (IOException e) {
            throw new TTException(class$edu$purdue$smas$timetable$util$Config == null ? (class$edu$purdue$smas$timetable$util$Config = Config.class$("edu.purdue.smas.timetable.util.Config")) : class$edu$purdue$smas$timetable$util$Config, TTException.getErrorCode("IOException"), "Unable to read configuration.");
        }
    }

    public static Enumeration keys() {
        return sProperties.keys();
    }

    public static Properties getProperties() {
        return sProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

