/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.serverfwk;

import edu.purdue.smas.timetable.serverfwk.TimetableServer;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipInputStream;

public class TimetableProxy {
    private int iPort;
    private String iHost;
    private Socket iSocket;
    private ObjectInputStream iIn;
    private ObjectOutputStream iOut;
    private TimetableServer iLocalServer = null;
    private static Hashtable sLocalServers = new Hashtable();

    private TimetableProxy(String host, int port) throws TTException {
        this.iHost = host;
        this.iPort = port;
        this.connect();
    }

    public void connect() throws TTException {
        try {
            if (this.iPort == 0) {
                if (sLocalServers.containsKey(this.iHost)) {
                    this.iLocalServer = (TimetableServer)sLocalServers.get(this.iHost);
                } else {
                    Class<?> cl = Class.forName(this.iHost);
                    Constructor<?> constr = cl.getConstructor(new Class[0]);
                    this.iLocalServer = (TimetableServer)constr.newInstance(new Object[0]);
                    sLocalServers.put(this.iHost, this.iLocalServer);
                }
            } else {
                this.iSocket = new Socket(this.iHost, this.iPort);
                this.iOut = new ObjectOutputStream(this.iSocket.getOutputStream());
                this.iIn = new ObjectInputStream(this.iSocket.getInputStream());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            throw new TTException(e);
        }
    }

    public void disconnect() throws TTException {
        try {
            if (this.iLocalServer == null) {
                this.iOut.writeObject("QUIT");
                this.iOut.close();
                this.iIn.close();
                this.iSocket.close();
            }
        }
        catch (Exception e) {
            Debug.error(e);
            throw new TTException(e);
        }
    }

    public void stopServer() throws TTException {
        try {
            if (this.iLocalServer == null) {
                this.iOut.writeObject("STOP_SERVER");
                this.iOut.close();
                this.iIn.close();
                this.iSocket.close();
            }
        }
        catch (Exception e) {
            Debug.error(e);
            throw new TTException(e);
        }
    }

    public int getPort() {
        return this.iPort;
    }

    public String getHost() {
        return this.iHost;
    }

    public static TimetableProxy getProxy(String address) throws TTException {
        try {
            String host = address.substring(0, address.indexOf(58));
            int port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
            TimetableProxy proxy = new TimetableProxy(host, port);
            Debug.log("Server " + address + " connected");
            Debug.log("  version:   " + proxy.getVersion());
            Debug.log("  parameters:" + proxy.getParameters());
            return proxy;
        }
        catch (Exception e) {
            Debug.error(e);
            throw new TTException(e);
        }
    }

    private Hashtable query(String command, Hashtable params) throws TTException {
        try {
            Debug.log("Q:" + command + " " + params);
            Object ret = null;
            if (this.iLocalServer != null) {
                ret = this.iLocalServer.query(command, params);
            } else {
                try {
                    this.iOut.writeObject(command);
                    this.iOut.writeObject(params == null ? new Hashtable() : params);
                    ret = this.iIn.readObject();
                }
                catch (SocketException ex) {
                    Debug.log(ex.getMessage() + " -- trying reconnect.");
                    this.connect();
                    this.iOut.writeObject(command);
                    this.iOut.writeObject(params == null ? new Hashtable() : params);
                    ret = this.iIn.readObject();
                }
            }
            if (ret instanceof String && ret.toString().equals("NULL")) {
                ret = null;
            }
            Hashtable r = ret;
            Debug.log("R:" + r);
            if (r == null) {
                throw new TTException(this, "Command not understood.");
            }
            if (r.containsKey("ERROR")) {
                throw new TTException(this, r.get("ERROR").toString());
            }
            return r;
        }
        catch (Exception ex) {
            if (ex instanceof TTException) {
                throw (TTException)ex;
            }
            Debug.error(ex);
            throw new TTException(ex);
        }
    }

    public String getVersion() throws TTException {
        return this.query("VERSION", new Hashtable()).get("RETURN").toString();
    }

    public Vector getParameters() throws TTException {
        return (Vector)this.query("PARAMS", new Hashtable()).get("RETURN");
    }

    public long loadedVersion() throws TTException {
        return (Long)this.query("LOADED_VERSION", new Hashtable()).get("RETURN");
    }

    public Collection saveBest(long version) throws TTException {
        Hashtable<String, Long> params = new Hashtable<String, Long>();
        params.put("VERSION", new Long(version));
        Hashtable ret = this.query("SAVE_BEST", params);
        return (Collection)ret.get("INFO");
    }

    public Collection saveCurrent(long version) throws TTException {
        Hashtable<String, Long> params = new Hashtable<String, Long>();
        params.put("VERSION", new Long(version));
        Hashtable ret = this.query("SAVE_CURRENT", params);
        return (Collection)ret.get("INFO");
    }

    public Collection solve(long version, Hashtable params) throws TTException {
        params.put("VERSION", new Long(version));
        Hashtable ret = this.query("SOLVE", params);
        return (Collection)ret.get("INFO");
    }

    public Collection solve(long version, long solutionVersion, Hashtable params) throws TTException {
        params.put("VERSION", new Long(version));
        if (solutionVersion >= 0L) {
            params.put("General.InputSolutionVersion", new Long(solutionVersion));
        }
        Hashtable ret = this.query("SOLVE", params);
        return (Collection)ret.get("INFO");
    }

    public void stopSolver() throws TTException {
        this.query("STOP", new Hashtable());
    }

    public void resetSolver() throws TTException {
        this.query("RESET", new Hashtable());
    }

    public boolean isRunning() throws TTException {
        return (Boolean)this.query("IS_RUNNING", new Hashtable()).get("RETURN");
    }

    public boolean isDone() throws TTException {
        return (Boolean)this.query("IS_DONE", new Hashtable()).get("RETURN");
    }

    public boolean isStopped() throws TTException {
        return (Boolean)this.query("IS_STOPPED", new Hashtable()).get("RETURN");
    }

    public Dictionary getCurrentInfo() throws TTException {
        Hashtable r = this.query("CURRENT_INFO", new Hashtable());
        return r.containsKey("RETURN") ? (Dictionary)r.get("RETURN") : null;
    }

    public Dictionary getBestInfo() throws TTException {
        Hashtable r = this.query("BEST_INFO", new Hashtable());
        return r.containsKey("RETURN") ? (Dictionary)r.get("RETURN") : null;
    }

    public Hashtable getProgress() throws TTException {
        Hashtable r = this.query("PROGRESS", new Hashtable());
        return r.containsKey("RETURN") ? (Hashtable)r.get("RETURN") : null;
    }

    public InputStream getStatistics(Hashtable params) throws TTException {
        try {
            byte[] stat = (byte[])this.query("PRINT_STATISTICS", params).get("RETURN");
            if (stat == null) {
                return null;
            }
            ZipInputStream zip = new ZipInputStream(new ByteArrayInputStream(stat));
            zip.getNextEntry();
            return zip;
        }
        catch (IOException e) {
            throw new TTException(e);
        }
    }

    public static void main(String[] args) {
        try {
            Config.init(new File(args.length < 1 ? "D:\\Tom\\purdue\\java\\tt.cfg.jsp" : args[0]));
            Debug.init();
            TimetableProxy proxy = TimetableProxy.getProxy("localhost:8089");
            Debug.log("sleep");
            Thread.sleep(2000L);
            Debug.log("wake up");
            Debug.log("ver:" + proxy.getVersion());
            proxy.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

