/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.serverfwk;

import edu.purdue.smas.timetable.serverfwk.TimetableServer;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class GeneralTimetableServer
implements TimetableServer {
    private ServerSocket iServerSocket = null;
    private boolean iQuit = false;

    public Hashtable query(String command, Hashtable params) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        try {
            if (command.equalsIgnoreCase("VERSION")) {
                ret.put("RETURN", this.getVersion());
            } else if (command.equalsIgnoreCase("PARAMS")) {
                ret.put("RETURN", this.getParams());
            } else if (command.equalsIgnoreCase("SAVE_BEST")) {
                Vector info = this.saveBest((Long)params.get("VERSION"));
                if (info != null) {
                    ret.put("INFO", info);
                }
            } else if (command.equalsIgnoreCase("SAVE_CURRENT")) {
                Vector info = this.saveCurrent((Long)params.get("VERSION"));
                if (info != null) {
                    ret.put("INFO", info);
                }
            } else if (command.equalsIgnoreCase("SOLVE")) {
                Vector info = this.solve((Long)params.get("VERSION"), params);
                if (info != null) {
                    ret.put("INFO", info);
                }
            } else if (command.equalsIgnoreCase("STOP")) {
                this.stopSolver();
            } else if (command.equalsIgnoreCase("RESET")) {
                this.resetSolver();
            } else if (command.equalsIgnoreCase("LOADED_VERSION")) {
                ret.put("RETURN", new Long(this.loadedVersion()));
            } else if (command.equalsIgnoreCase("IS_RUNNING")) {
                ret.put("RETURN", new Boolean(this.isRunning()));
            } else if (command.equalsIgnoreCase("IS_DONE")) {
                ret.put("RETURN", new Boolean(this.isDone()));
            } else if (command.equalsIgnoreCase("IS_STOPPED")) {
                ret.put("RETURN", new Boolean(this.isStopped()));
            } else if (command.equalsIgnoreCase("CURRENT_INFO")) {
                Hashtable info = this.getCurrentInfo();
                if (info != null) {
                    ret.put("RETURN", info);
                }
            } else if (command.equalsIgnoreCase("BEST_INFO")) {
                Hashtable info = this.getBestInfo();
                if (info != null) {
                    ret.put("RETURN", info);
                }
            } else if (command.equalsIgnoreCase("PROGRESS")) {
                ret.put("RETURN", this.getProgress());
            } else if (command.equalsIgnoreCase("PRINT_STATISTICS")) {
                byte[] stat = this.printStatistics(params);
                if (stat != null) {
                    ret.put("RETURN", stat);
                }
            } else {
                return null;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            Debug.error(e);
            ret.put("ERROR", e.getMessage() == null ? "Unknown error" : e.getMessage());
            return ret;
        }
    }

    public abstract String getVersion() throws TTException;

    public abstract Vector getParams() throws TTException;

    public abstract Vector saveBest(long var1) throws TTException;

    public abstract Vector saveCurrent(long var1) throws TTException;

    public abstract Vector solve(long var1, Hashtable var3) throws TTException;

    public abstract void stopSolver() throws TTException;

    public abstract void resetSolver() throws TTException;

    public abstract long loadedVersion() throws TTException;

    public abstract boolean isRunning() throws TTException;

    public abstract boolean isDone() throws TTException;

    public abstract boolean isStopped() throws TTException;

    public abstract Hashtable getCurrentInfo() throws TTException;

    public abstract Hashtable getBestInfo() throws TTException;

    public abstract Hashtable getProgress() throws TTException;

    public byte[] printStatistics(Hashtable params) throws TTException {
        return null;
    }

    public void start(int port) throws TTException {
        try {
            Debug.log("Starting timetable on port " + port + " ...");
            try {
                this.iServerSocket = new ServerSocket(port);
            }
            catch (BindException ex) {
                Debug.log("Server already running (" + ex.getMessage() + "), trying to close previous execution ...");
                try {
                    Socket socket = new Socket("localhost", port);
                    ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                    out.writeObject("STOP_SERVER");
                    out.flush();
                    out.close();
                    socket.close();
                }
                catch (Exception x) {
                    Debug.error(x);
                }
                Debug.log("Starting timetable on port " + port + " (second attempt) ...");
                this.iServerSocket = new ServerSocket(port);
            }
            Debug.log("Server started on port " + port + " (version: " + this.getVersion() + ").");
            while (true) {
                try {
                    while (true) {
                        Socket socket = this.iServerSocket.accept();
                        Debug.log("Client " + socket.getInetAddress() + " connected.");
                        new ServerThread(socket).start();
                    }
                }
                catch (SocketException se) {
                    if (this.iServerSocket.isClosed()) {
                        return;
                    }
                    Debug.error(se);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Debug.error(e);
            throw new TTException(e);
        }
    }

    protected class DelayThread
    extends Thread {
        ObjectInputStream iIn;

        public DelayThread(ObjectInputStream in) {
            this.iIn = in;
        }

        public void run() {
            try {
                Debug.log("Waiting for command ...");
                DelayThread.sleep(1000L);
                this.iIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected class ServerThread
    extends Thread {
        private Socket iSocket = null;

        protected ServerThread(Socket socket) {
            this.iSocket = socket;
        }

        public void run() {
            try {
                ObjectOutputStream out = new ObjectOutputStream(this.iSocket.getOutputStream());
                ObjectInputStream in = new ObjectInputStream(this.iSocket.getInputStream());
                String command = null;
                while (true) {
                    command = null;
                    try {
                        command = (String)in.readObject();
                    }
                    catch (EOFException ex) {
                        // empty catch block
                    }
                    if (command == null || command.equalsIgnoreCase("QUIT") || command.equalsIgnoreCase("STOP_SERVER")) break;
                    Hashtable params = (Hashtable)in.readObject();
                    Hashtable ret = GeneralTimetableServer.this.query(command, params);
                    out.writeObject(ret == null ? "NULL" : ret);
                }
                out.close();
                in.close();
                if (command != null && command.equalsIgnoreCase("STOP_SERVER")) {
                    Debug.log("Server is going down now ...");
                    this.iSocket.close();
                    GeneralTimetableServer.this.iServerSocket.close();
                    return;
                }
            }
            catch (Exception e) {
                Debug.error(e);
            }
            try {
                this.iSocket.close();
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
    }
}

