/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data.pattern;

import edu.purdue.smas.timetable.data.Class;
import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.Timetable;
import edu.purdue.smas.timetable.data.User;
import edu.purdue.smas.timetable.data.pattern.TimePatternModel;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StandardTimePattern
implements TimePatternModel {
    protected int iNrMeetings;
    protected int iHalfHoursPerMeeting;
    protected String[] iDays = null;
    protected int[] iDayCodes = null;
    protected int[] iHours = null;
    protected int[] iMinutes = null;
    protected Preferences.Preference[][] iPreferences;
    protected static Preferences.Preference sDefaultPreference = Preferences.getPreference("0");
    protected static Preferences.Preference sNoPreference = Preferences.getPreference("0");

    public StandardTimePattern(int nrMeetings, int halfHoursPerMeeting) throws TTException {
        int j;
        int i;
        this.iHalfHoursPerMeeting = halfHoursPerMeeting;
        this.iNrMeetings = nrMeetings;
        if (nrMeetings == 1) {
            this.iDays = new String[5];
            this.iDayCodes = new int[5];
            for (i = 0; i < 5; ++i) {
                this.iDays[i] = Constants.DAY_NAME[i];
                this.iDayCodes[i] = Constants.DAY_CODES[i];
            }
        }
        if (nrMeetings == 2) {
            this.iDays = new String[3];
            this.iDayCodes = new int[3];
            this.iDays[0] = Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2];
            this.iDayCodes[0] = Constants.DAY_CODES[0] + Constants.DAY_CODES[2];
            this.iDays[1] = Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3];
            this.iDayCodes[1] = Constants.DAY_CODES[1] + Constants.DAY_CODES[3];
            this.iDays[2] = Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4];
            this.iDayCodes[2] = Constants.DAY_CODES[2] + Constants.DAY_CODES[4];
        }
        if (nrMeetings == 3) {
            this.iDays = new String[1];
            this.iDayCodes = new int[1];
            this.iDays[0] = Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[4];
            this.iDayCodes[0] = Constants.DAY_CODES[0] + Constants.DAY_CODES[2] + Constants.DAY_CODES[4];
        }
        if (nrMeetings == 4) {
            this.iDays = new String[5];
            this.iDayCodes = new int[5];
            for (i = 0; i < 5; ++i) {
                this.iDays[i] = "";
                this.iDayCodes[i] = 0;
                for (j = 0; j < 5; ++j) {
                    if (i == j) continue;
                    this.iDays[i] = this.iDays[i] + Constants.DAY_NAMES_SHORT[j];
                    int n = i;
                    this.iDayCodes[n] = this.iDayCodes[n] + Constants.DAY_CODES[j];
                }
            }
        }
        if (nrMeetings == 5) {
            this.iDays = new String[1];
            this.iDayCodes = new int[1];
            this.iDays[0] = Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[2] + Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[4];
            this.iDayCodes[0] = Constants.DAY_CODES[0] + Constants.DAY_CODES[1] + Constants.DAY_CODES[2] + Constants.DAY_CODES[3] + Constants.DAY_CODES[4];
        }
        if (halfHoursPerMeeting == 2) {
            this.iHours = new int[10];
            this.iMinutes = new int[10];
            for (i = 0; i < 10; ++i) {
                this.iHours[i] = i + 7;
                this.iMinutes[i] = 30;
            }
        }
        if (nrMeetings <= 4 && halfHoursPerMeeting == 4) {
            this.iHours = new int[5];
            this.iMinutes = new int[5];
            for (i = 0; i < 5; ++i) {
                this.iHours[i] = 2 * i + 7;
                this.iMinutes[i] = 30;
            }
        }
        if (nrMeetings == 1 && halfHoursPerMeeting == 6) {
            this.iHours = new int[7];
            this.iMinutes = new int[7];
            for (i = 0; i < 7; ++i) {
                this.iHours[i] = i == 0 ? 7 : (i == 1 ? 8 : (i == 2 ? 10 : (i == 3 ? 11 : (i == 4 ? 13 : (i == 5 ? 14 : 15)))));
                this.iMinutes[i] = i == 6 ? 0 : 30;
            }
        }
        if (nrMeetings == 1 && halfHoursPerMeeting == 8) {
            this.iHours = new int[4];
            this.iMinutes = new int[4];
            for (i = 0; i < 4; ++i) {
                this.iHours[i] = i == 0 ? 7 : (i == 1 ? 8 : (i == 2 ? 12 : 13));
                this.iMinutes[i] = 30;
            }
        }
        if (nrMeetings == 2 && halfHoursPerMeeting == 3) {
            this.iDays = new String[1];
            this.iDayCodes = new int[1];
            this.iDays[0] = Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3];
            this.iDayCodes[0] = Constants.DAY_CODES[1] + Constants.DAY_CODES[3];
        }
        if (halfHoursPerMeeting == 3) {
            this.iHours = new int[7];
            this.iMinutes = new int[7];
            for (i = 0; i < 7; ++i) {
                this.iHours[i] = i == 0 ? 7 : (i == 1 ? 9 : (i == 2 ? 10 : (i == 3 ? 12 : (i == 4 ? 13 : (i == 5 ? 15 : 16)))));
                this.iMinutes[i] = i == 1 || i == 3 || i == 5 ? 0 : 30;
            }
        }
        if (this.iDays == null || this.iHours == null) {
            throw new TTException(this, "Unsupported time pattern");
        }
        this.iPreferences = new Preferences.Preference[this.iDays.length][this.iHours.length];
        for (i = 0; i < this.iDays.length; ++i) {
            for (j = 0; j < this.iHours.length; ++j) {
                this.iPreferences[i][j] = sNoPreference;
            }
        }
    }

    public int getDayCode(int day) {
        return this.iDayCodes[day];
    }

    public String getDayHeader(int day) {
        return this.iDays[day];
    }

    public int getHour(int time) {
        return this.iHours[time];
    }

    public int getMinute(int time) {
        return this.iMinutes[time];
    }

    public static long getTime(int hour, int minute, int sec) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, sec);
        return cal.getTimeInMillis();
    }

    public long getTime(int time) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(11, this.iHours[time]);
        cal.set(12, this.iMinutes[time]);
        return cal.getTimeInMillis();
    }

    public int getNrDays() {
        return this.iDays.length;
    }

    public int getNrTimes() {
        return this.iHours.length;
    }

    public Preferences.Preference getPreference(int day, int time) {
        return this.iPreferences[day][time];
    }

    public String getTimeHeader(int time) {
        int endTime = 60 * this.iHours[time] + this.iMinutes[time] + 30 * this.iHalfHoursPerMeeting;
        int endHour = endTime / 60;
        int endMinute = endTime % 60;
        return (this.iHours[time] > 12 ? this.iHours[time] - 12 : this.iHours[time]) + ":" + (this.iMinutes[time] < 10 ? "0" : "") + this.iMinutes[time] + "<br><font color='gray'>" + (endHour > 12 ? endHour - 12 : endHour) + ":" + (endMinute < 10 ? "0" : "") + endMinute + "</font>";
    }

    public String getTimeHeaderShort(int time) {
        int endTime = 60 * this.iHours[time] + this.iMinutes[time] + 30 * this.iHalfHoursPerMeeting;
        int endHour = endTime / 60;
        int endMinute = endTime % 60;
        return (this.iHours[time] > 12 ? this.iHours[time] - 12 : this.iHours[time]) + ":" + (this.iMinutes[time] < 10 ? "0" : "") + this.iMinutes[time] + " - " + (endHour > 12 ? endHour - 12 : endHour) + ":" + (endMinute < 10 ? "0" : "") + endMinute;
    }

    public void setDefaults(User user) throws TTException, SQLException {
        if (!user.getCurrentRole().equals(Constants.DEPARTMENT_ROLE)) {
            Preferences.Preference bad = Preferences.getPreference("2");
            Preferences.Preference lessBad = Preferences.getPreference("1");
            if (bad == null || this.iHalfHoursPerMeeting >= 8) {
                return;
            }
            long startTime = StandardTimePattern.getTime(7, 30, 0);
            long endTime = StandardTimePattern.getTime(this.iHalfHoursPerMeeting <= 3 ? 16 : 15, this.iHalfHoursPerMeeting <= 4 ? 30 : 0, 0);
            for (int i = 0; i < this.iDays.length; ++i) {
                for (int j = 0; j < this.iHours.length; ++j) {
                    this.iPreferences[i][j] = this.getTime(j) <= startTime ? bad : (this.getTime(j) >= endTime ? lessBad : sNoPreference);
                }
            }
        }
    }

    public void setPreference(int day, int time, Preferences.Preference pref) {
        try {
            this.iPreferences[day][time] = pref;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.println("Unable to set preference for day=" + day + "/" + this.iDayCodes.length + ", time=" + time + "/" + this.iHours.length + " -- " + ex.getMessage());
            throw ex;
        }
    }

    public void clear() {
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iHours.length; ++j) {
                this.iPreferences[i][j] = sNoPreference;
            }
        }
    }

    public Collection getSlots(int day, int time) {
        Vector<Integer> slots = new Vector<Integer>();
        int dayCode = this.iDayCodes[day];
        int slot = 2 * this.iHours[time] + (this.iMinutes[time] == 0 ? 0 : 1) - 15;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) != Constants.DAY_CODES[i]) continue;
            int s = slot + i * Constants.SLOTS_PER_DAY;
            for (int j = 0; j < this.iHalfHoursPerMeeting; ++j) {
                slots.addElement(new Integer(s + j));
            }
        }
        return slots;
    }

    public Collection getStartSlots(int day, int time) {
        Vector<Integer> slots = new Vector<Integer>();
        int dayCode = this.iDayCodes[day];
        int slot = 2 * this.iHours[time] + (this.iMinutes[time] == 0 ? 0 : 1) - 15;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) != Constants.DAY_CODES[i]) continue;
            int s = slot + i * Constants.SLOTS_PER_DAY;
            slots.addElement(new Integer(s));
        }
        return slots;
    }

    public String getText(int day, int time) {
        return this.getDayHeader(day) + " " + this.getTimeHeaderShort(time);
    }

    public void loadTimeRequirements(Hashtable requirements) {
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iHours.length; ++j) {
                this.iPreferences[i][j] = sNoPreference;
            }
        }
        Enumeration e = requirements.keys();
        while (e.hasMoreElements()) {
            Class.TimeRequirement trq = (Class.TimeRequirement)e.nextElement();
            Preferences.Preference pref = (Preferences.Preference)requirements.get(trq);
            int days = Integer.parseInt(trq.getDaysStr(), 2);
            Time startTime = trq.getStartTime();
            Time endTime = trq.getEndTime();
            for (int i = 0; i < this.iDays.length; ++i) {
                if ((days & this.iDayCodes[i]) != this.iDayCodes[i]) continue;
                for (int j = 0; j < this.iHours.length; ++j) {
                    if ((endTime != null || startTime.getTime() != this.getTime(j)) && (endTime == null || startTime.getTime() > this.getTime(j) || endTime.getTime() < this.getTime(j))) continue;
                    this.iPreferences[i][j] = pref;
                }
            }
        }
    }

    public void storeTimeRequirements(Hashtable requirements) {
        boolean[][] done = new boolean[this.iDays.length][this.iHours.length];
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iHours.length; ++j) {
                done[i][j] = false;
            }
        }
        for (int j = 0; j < this.iHours.length; ++j) {
            int j1;
            Time endTime;
            Time startTime;
            Preferences.Preference pref = this.iPreferences[0][j];
            boolean col = !done[0][j];
            int allCode = this.iDayCodes[0];
            for (int i = 1; col && i < this.iDays.length; ++i) {
                if (done[i][j] || !this.iPreferences[i][j].equals(pref) || (allCode & this.iDayCodes[i]) != 0) {
                    col = false;
                }
                allCode |= this.iDayCodes[i];
            }
            if (col) {
                String days = Integer.toBinaryString(allCode);
                startTime = new Time(this.getTime(j));
                int k = j + 1;
                boolean nexCol = true;
                while (nexCol && k < this.iHours.length) {
                    for (int l = 0; nexCol && l < this.iDays.length; ++l) {
                        if (!done[l][k] && this.iPreferences[l][k].equals(pref)) continue;
                        nexCol = false;
                    }
                    if (!nexCol) continue;
                    ++k;
                }
                endTime = new Time(this.getTime(k - 1));
                for (int i1 = j; i1 <= k - 1; ++i1) {
                    for (j1 = 0; j1 < this.iDays.length; ++j1) {
                        done[j1][i1] = true;
                    }
                }
                while (days.length() < 7) {
                    days = "0" + days;
                }
                if (pref.equals(sNoPreference)) continue;
                requirements.put(new Class.TimeRequirement(-1L, days, startTime, endTime.equals(startTime) ? null : endTime), pref);
                continue;
            }
            for (int i = 0; i < this.iDays.length; ++i) {
                if (done[i][j]) continue;
                pref = this.iPreferences[i][j];
                int k = j;
                while (k + 1 < this.iHours.length && this.iPreferences[i][k + 1].equals(pref)) {
                    ++k;
                }
                startTime = new Time(this.getTime(j));
                endTime = new Time(this.getTime(k));
                int code = this.iDayCodes[i];
                for (j1 = j; j1 <= k; ++j1) {
                    done[i][j1] = true;
                }
                for (int l = i + 1; l < this.iDays.length; ++l) {
                    boolean same = true;
                    for (int j12 = j; same && j12 <= k; ++j12) {
                        if (!done[l][j12] && this.iPreferences[l][j12].equals(pref) && (code & this.iDayCodes[l]) == 0) continue;
                        same = false;
                    }
                    if (!same) continue;
                    code += this.iDayCodes[l];
                    for (int j2 = j; j2 <= k; ++j2) {
                        done[l][j2] = true;
                    }
                }
                String days = Integer.toBinaryString(code);
                while (days.length() < 7) {
                    days = "0" + days;
                }
                if (pref.equals(sNoPreference)) continue;
                requirements.put(new Class.TimeRequirement(-1L, days, startTime, endTime.equals(startTime) ? null : endTime), pref);
            }
        }
    }

    public int getNrHalfHoursPerMeeting() {
        return this.iHalfHoursPerMeeting;
    }

    public int getNrMeetings() {
        return this.iNrMeetings;
    }

    public double getNormalizedPreference(int day, int time) {
        if (this.iPreferences[day][time].getProlog().equalsIgnoreCase("R") || this.iPreferences[day][time].getProlog().equalsIgnoreCase("P")) {
            return 0.0;
        }
        int pref = Integer.parseInt(this.iPreferences[day][time].getProlog());
        int sumOfPreferences = 0;
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iHours.length; ++j) {
                sumOfPreferences += this.iPreferences[i][j].getProlog().equalsIgnoreCase("R") || this.iPreferences[i][j].getProlog().equalsIgnoreCase("P") ? 0 : Math.abs(Integer.parseInt(this.iPreferences[i][j].getProlog()));
            }
        }
        if (sumOfPreferences == 0) {
            return 0.0;
        }
        double normPref = this.getTransformPreference() * ((double)pref / (double)sumOfPreferences);
        return -Math.round(-normPref);
    }

    public double getTresholdPreference() {
        switch (this.getNrMeetings()) {
            case 1: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 3: {
                        return 29.0;
                    }
                    case 4: {
                        return 26.0;
                    }
                    case 6: {
                        return 22.0;
                    }
                }
                return 0.0;
            }
            case 2: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 3: {
                        return 29.0;
                    }
                    case 4: {
                        return 26.0;
                    }
                }
                return 0.0;
            }
            case 3: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 4: {
                        return 26.0;
                    }
                }
                return 0.0;
            }
            case 4: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 4: {
                        return 26.0;
                    }
                }
                return 0.0;
            }
            case 5: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 4: {
                        return 26.0;
                    }
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public double getTransformPreference() {
        switch (this.getNrMeetings()) {
            case 1: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 30.0;
                    }
                    case 3: {
                        return 20.0;
                    }
                    case 4: {
                        return 25.0;
                    }
                    case 6: {
                        return 27.0;
                    }
                }
                return 0.0;
            }
            case 2: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 26.0;
                    }
                    case 3: {
                        return 15.0;
                    }
                    case 4: {
                        return 22.0;
                    }
                }
                return 0.0;
            }
            case 3: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 20.0;
                    }
                    case 4: {
                        return 14.0;
                    }
                }
                return 0.0;
            }
            case 4: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 20.0;
                    }
                    case 4: {
                        return 16.0;
                    }
                }
                return 0.0;
            }
            case 5: {
                switch (this.getNrHalfHoursPerMeeting()) {
                    case 2: {
                        return 10.0;
                    }
                    case 4: {
                        return 10.0;
                    }
                }
                return 0.0;
            }
        }
        return 0.0;
    }

    public int countPreferences(Preferences.Preference pref) {
        int ret = 0;
        for (int i = 0; i < this.iDays.length; ++i) {
            for (int j = 0; j < this.iHours.length; ++j) {
                if (!this.iPreferences[i][j].equals(pref)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean contains(Vector timetables) {
        if (timetables == null || timetables.size() != this.getNrMeetings()) {
            return false;
        }
        int[] startSlots = new int[timetables.size()];
        int idx = 0;
        Enumeration e1 = timetables.elements();
        while (e1.hasMoreElements()) {
            Timetable timetable = (Timetable)e1.nextElement();
            if (timetable.getHalfHoursPerMtg() != this.getNrHalfHoursPerMeeting()) {
                return false;
            }
            startSlots[idx++] = timetable.getSlot();
        }
        for (int day = 0; day < this.iDays.length; ++day) {
            for (int time = 0; time < this.iHours.length; ++time) {
                int slot = 2 * this.iHours[time] + (this.iMinutes[time] == 0 ? 0 : 1) - 15;
                int j = 0;
                boolean equal = true;
                for (int i = 0; equal && i < Constants.DAY_CODES.length; ++i) {
                    if ((this.iDayCodes[day] & Constants.DAY_CODES[i]) != Constants.DAY_CODES[i]) continue;
                    int s = slot + i * Constants.SLOTS_PER_DAY;
                    if (startSlots[j] != s) {
                        equal = false;
                        break;
                    }
                    ++j;
                }
                if (!equal) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getNrMeetings() + "x" + 25 * this.getNrHalfHoursPerMeeting();
    }

    public static void main(String[] args) {
        try {
            StandardTimePattern stt = new StandardTimePattern(2, 3);
            stt.setPreference(0, 0, Preferences.getPreference("-2"));
            stt.setPreference(0, 1, Preferences.getPreference("-2"));
            stt.setPreference(0, 2, Preferences.getPreference("-2"));
            stt.setPreference(0, 3, Preferences.getPreference("-2"));
            stt.setPreference(0, 4, Preferences.getPreference("-2"));
            stt.setPreference(0, 5, Preferences.getPreference("-2"));
            for (int i = 0; i < stt.getNrDays(); ++i) {
                for (int j = 0; j < stt.getNrTimes(); ++j) {
                    System.out.println("Pref[" + i + "," + j + "]=" + stt.getNormalizedPreference(i, j));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

