/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data.pattern;

import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.TTException;

public class SaturdayTimePattern
extends StandardTimePattern {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SaturdayTimePattern(int nrMeetings, int halfHoursPerMeeting) throws TTException {
        super(nrMeetings, halfHoursPerMeeting);
        if (nrMeetings == 1) {
            this.iDays = new String[]{Constants.DAY_NAME[5]};
            this.iDayCodes = new int[]{Constants.DAY_CODES[5]};
            if (halfHoursPerMeeting == 2) {
                this.iHours = new int[5];
                this.iMinutes = new int[5];
                for (int i = 0; i < 5; ++i) {
                    this.iHours[i] = 7 + i;
                    this.iMinutes[i] = 30;
                }
            } else if (halfHoursPerMeeting == 4) {
                this.iHours = new int[4];
                this.iMinutes = new int[4];
                for (int i = 0; i < 4; ++i) {
                    this.iHours[i] = 7 + i;
                    this.iMinutes[i] = 30;
                }
            } else {
                if (halfHoursPerMeeting != 6) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
                this.iHours = new int[3];
                this.iMinutes = new int[3];
                for (int i = 0; i < 3; ++i) {
                    this.iHours[i] = 7 + i;
                    this.iMinutes[i] = 30;
                }
            }
        } else {
            if (nrMeetings != 3) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
            this.iDays = new String[]{Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3] + Constants.DAY_NAMES_SHORT[5]};
            this.iDayCodes = new int[]{Constants.DAY_CODES[1] + Constants.DAY_CODES[3] + Constants.DAY_CODES[5]};
            if (halfHoursPerMeeting != 2) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
            this.iHours = new int[5];
            this.iMinutes = new int[5];
            for (int i = 0; i < 5; ++i) {
                this.iHours[i] = 7 + i;
                this.iMinutes[i] = 30;
            }
        }
        this.iPreferences = new Preferences.Preference[this.iDays.length][this.iHours.length];
        this.clear();
    }

    public void setDefaults() {
        this.clear();
    }

    public String toString() {
        return super.toString() + " Sat.";
    }
}

