/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data.pattern;

import edu.purdue.smas.timetable.data.Preferences;
import edu.purdue.smas.timetable.data.pattern.StandardTimePattern;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.TTException;

public class EveningTimePattern
extends StandardTimePattern {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EveningTimePattern(int nrMeetings, int halfHoursPerMeeting) throws TTException {
        super(nrMeetings, halfHoursPerMeeting);
        if (nrMeetings == 1) {
            int i;
            this.iDays = new String[4];
            this.iDayCodes = new int[4];
            for (i = 0; i < 4; ++i) {
                this.iDays[i] = Constants.DAY_NAME[i];
                this.iDayCodes[i] = Constants.DAY_CODES[i];
            }
            if (halfHoursPerMeeting == 2) {
                this.iHours = new int[9];
                this.iMinutes = new int[9];
                for (i = 0; i < 9; ++i) {
                    this.iHours[i] = 17 + (i + 1) / 2;
                    this.iMinutes[i] = i % 2 == 0 ? 30 : 0;
                }
            } else if (halfHoursPerMeeting == 4) {
                this.iHours = new int[10];
                this.iMinutes = new int[10];
                for (i = 0; i < 10; ++i) {
                    this.iHours[i] = 16 + i / 2;
                    this.iMinutes[i] = i % 2 == 0 ? 0 : 30;
                }
            } else {
                if (halfHoursPerMeeting != 6) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
                this.iHours = new int[9];
                this.iMinutes = new int[9];
                for (i = 0; i < 9; ++i) {
                    this.iHours[i] = 15 + (i + 1) / 2;
                    this.iMinutes[i] = i % 2 == 0 ? 30 : 0;
                }
            }
        } else {
            if (nrMeetings != 2) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
            this.iDays = new String[]{Constants.DAY_NAMES_SHORT[0] + Constants.DAY_NAMES_SHORT[2], Constants.DAY_NAMES_SHORT[1] + Constants.DAY_NAMES_SHORT[3]};
            this.iDayCodes = new int[]{Constants.DAY_CODES[0] + Constants.DAY_CODES[2], Constants.DAY_CODES[1] + Constants.DAY_CODES[3]};
            if (halfHoursPerMeeting != 3) throw new TTException(this, "Unknown evening pattern " + this.iNrMeetings + "x" + this.iHalfHoursPerMeeting);
            this.iHours = new int[8];
            this.iMinutes = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.iHours[i] = 17 + (i + 1) / 2;
                this.iMinutes[i] = i % 2 == 0 ? 30 : 0;
            }
        }
        this.iPreferences = new Preferences.Preference[this.iDays.length][this.iHours.length];
        this.clear();
    }

    public String getTimeHeader(int time) {
        int endTime = 60 * this.iHours[time] + this.iMinutes[time] + 30 * this.iHalfHoursPerMeeting;
        int endHour = endTime / 60;
        int endMinute = endTime % 60;
        return (this.iHours[time] > 12 ? this.iHours[time] - 12 : this.iHours[time]) + ":" + (this.iMinutes[time] < 10 ? "0" : "") + this.iMinutes[time] + (this.iHours[time] >= 12 ? "p" : "a") + "<br><font color='gray'>" + (endHour > 12 ? endHour - 12 : endHour) + ":" + (endMinute < 10 ? "0" : "") + endMinute + (endHour >= 12 ? "p" : "a") + "</font>";
    }

    public String getTimeHeaderShort(int time) {
        int endTime = 60 * this.iHours[time] + this.iMinutes[time] + 30 * this.iHalfHoursPerMeeting;
        int endHour = endTime / 60;
        int endMinute = endTime % 60;
        return (this.iHours[time] > 12 ? this.iHours[time] - 12 : this.iHours[time]) + ":" + (this.iMinutes[time] < 10 ? "0" : "") + this.iMinutes[time] + (this.iHours[time] >= 12 ? "p" : "a") + " - " + (endHour > 12 ? endHour - 12 : endHour) + ":" + (endMinute < 10 ? "0" : "") + endMinute + (endHour >= 12 ? "p" : "a");
    }

    public String getText(int day, int time) {
        return super.getText(day, time) + "p";
    }

    public void setDefaults() {
        this.clear();
    }

    public String toString() {
        return super.toString() + " evn.";
    }
}

