/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.Departments;
import edu.purdue.smas.timetable.data.Subjects;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Constants;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Sha;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class User {
    private long iUserID = -1L;
    private String iLogin = null;
    private String iName = null;
    private String iPasswdHashed = null;
    private boolean iIsAdmin = false;
    private String iCurrentRole = null;
    private Vector iSubjects = new Vector();
    private Vector iDepartments = new Vector();
    private Vector iRoles = null;
    private boolean iTimeVertical = false;

    public void setUserID(long userID) {
        this.iUserID = userID;
    }

    public long getUserID() {
        return this.iUserID;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getName() {
        return this.iName;
    }

    public void setPasswd(String passwd) throws TTException {
        this.iPasswdHashed = Sha.getCode(passwd);
    }

    private void setPasswdHashed(String passwdHashed) {
        this.iPasswdHashed = passwdHashed;
    }

    public String getPasswdHashed() {
        return this.iPasswdHashed;
    }

    public void setLogin(String login) {
        this.iLogin = login.toLowerCase();
    }

    public String getLogin() {
        return this.iLogin;
    }

    public boolean isAdmin() {
        return this.iIsAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.iIsAdmin = isAdmin;
    }

    public Vector getDepartments() {
        return this.iDepartments;
    }

    public String getDepartmentsAsString() {
        StringBuffer sb = new StringBuffer();
        if (this.iDepartments.size() == Departments.getAllDepartments().size()) {
            sb.append("All");
        } else {
            Enumeration e = this.iDepartments.elements();
            while (e.hasMoreElements()) {
                sb.append(Departments.getABBV(e.nextElement().toString())).append("<br>");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 4, sb.length());
            }
        }
        return sb.toString();
    }

    public Vector getSubjects() {
        return this.isAdmin() ? Subjects.allSubjects() : this.iSubjects;
    }

    public String getSubjectsAsString() {
        StringBuffer sb = new StringBuffer();
        if (this.iSubjects.size() == Subjects.allSubjects().size()) {
            sb.append("All");
        } else {
            Enumeration e = this.iSubjects.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString()).append(", ");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        return sb.toString();
    }

    public boolean hasDepartment(String department) {
        return this.iDepartments.indexOf(department) >= 0;
    }

    public boolean hasDepartment(Vector departments) {
        Enumeration e = departments.elements();
        while (e.hasMoreElements()) {
            if (!this.hasDepartment((String)e.nextElement())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubject(String subject) {
        return this.iSubjects.indexOf(subject) >= 0;
    }

    private static User load(ResultSet rs) throws SQLException, TTException {
        User u = new User();
        u.setUserID(rs.getLong("USERID"));
        u.setLogin(rs.getString("LOGIN"));
        u.setName(rs.getString("NAME"));
        u.setPasswdHashed(rs.getString("PASSWD"));
        u.setAdmin(rs.getString("USERROLE").equalsIgnoreCase("admin"));
        u.setTimeVertical(rs.getString("TIME_VERTICAL").equals("T"));
        u.loadDepartments();
        return u;
    }

    private void loadDepartments() throws SQLException, TTException {
        if (this.getUserID() < 0L) {
            return;
        }
        if (this.getCurrentRole().equals(Constants.DEPARTMENT_ROLE)) {
            Statement s = Database.execute("select DEPT_CODE from " + Config.get("SQL_SCHEMA") + ".USER_DEPARTMENT where USERID=" + Database.prepParam(this.getUserID()) + " order by DEPT_CODE");
            while (s.getResultSet().next()) {
                this.iDepartments.addElement(s.getResultSet().getString("DEPT_CODE"));
            }
            s.close();
            s = Database.execute("select SUBJ_ABBV from " + Config.get("SQL_SCHEMA") + ".USER_DEPARTMENT ud, " + Config.get("SQL_SCHEMA") + ".SUBJECT s where ud.DEPT_CODE=s.DEPT_CODE and ud.USERID=" + Database.prepParam(this.getUserID()) + " order by SUBJ_ABBV");
            while (s.getResultSet().next()) {
                this.iSubjects.addElement(s.getResultSet().getString("SUBJ_ABBV"));
            }
            s.close();
        } else {
            Enumeration e = Departments.elements();
            while (e.hasMoreElements()) {
                this.iDepartments.addElement(e.nextElement());
            }
            e = Subjects.elements();
            while (e.hasMoreElements()) {
                this.iSubjects.addElement(e.nextElement());
            }
        }
    }

    public static User load(long id) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".USERS where USERID=" + Database.prepParam(id));
        User u = null;
        if (s.getResultSet().next()) {
            u = User.load(s.getResultSet());
        }
        s.close();
        return u;
    }

    public static User load(String login) throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".USERS where LOGIN=" + Database.prepParam(login.toLowerCase()));
        User u = null;
        if (s.getResultSet().next()) {
            u = User.load(s.getResultSet());
        }
        s.close();
        return u;
    }

    public static Vector loadAll() throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".USERS");
        Vector<User> ret = new Vector<User>();
        while (s.getResultSet().next()) {
            ret.addElement(User.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public static Hashtable loadHash() throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".USERS");
        Hashtable<Long, User> ret = new Hashtable<Long, User>();
        while (s.getResultSet().next()) {
            User u = User.load(s.getResultSet());
            ret.put(new Long(u.getUserID()), u);
        }
        s.close();
        return ret;
    }

    public static User load(Hashtable cache, long id) {
        return cache.containsKey(new Long(id)) ? (User)cache.get(new Long(id)) : null;
    }

    public static User logIn(String login, String passwd) throws SQLException, TTException {
        String uname = login.toLowerCase();
        String upasswd = Sha.getCode(passwd);
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".USERS where LOGIN=" + Database.prepParam(uname) + " and passwd=" + Database.prepParam(upasswd));
        User u = null;
        if (s.getResultSet().next()) {
            u = User.load(s.getResultSet());
        }
        s.close();
        return u;
    }

    public void save() throws SQLException, TTException {
        if (this.getUserID() < 0L) {
            this.setUserID(Database.executeLong("select " + Config.get("SQL_SCHEMA") + ".SEQ_USERS.nextval from DUAL"));
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".USERS (userid,login,name,passwd,userrole, time_vertical) values (" + Database.prepParam(this.getUserID()) + ", " + Database.prepParam(this.getLogin()) + ", " + Database.prepParam(this.getName()) + ", " + Database.prepParam(this.getPasswdHashed()) + ", " + Database.prepParam(this.isAdmin() ? "admin" : "normal") + ", " + Database.prepParam(this.isTimeVertical() ? "T" : "F") + ")");
            Enumeration e = this.getDepartments().elements();
            while (e.hasMoreElements()) {
                Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".USER_DEPARTMENT (userid,dept_code) values (" + Database.prepParam(this.getUserID()) + ", " + Database.prepParam(e.nextElement()) + ")");
            }
        } else {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".USERS set " + "LOGIN=" + Database.prepParam(this.getLogin()) + ", " + "NAME=" + Database.prepParam(this.getName()) + ", " + "PASSWD=" + Database.prepParam(this.getPasswdHashed()) + ", " + "USERROLE=" + Database.prepParam(this.isAdmin() ? "admin" : "normal") + ", " + "TIME_VERTICAL=" + Database.prepParam(this.isTimeVertical() ? "T" : "F") + " where USERID=" + Database.prepParam(this.getUserID()));
            Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".USER_DEPARTMENT where USERID=" + Database.prepParam(this.getUserID()));
            Enumeration e = this.getDepartments().elements();
            while (e.hasMoreElements()) {
                Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".USER_DEPARTMENT (userid,dept_code) values (" + Database.prepParam(this.getUserID()) + ", " + Database.prepParam(e.nextElement()) + ")");
            }
        }
    }

    public static void delete(long userID) throws SQLException, TTException {
        Database.executeNoOutput("delete from " + Config.get("SQL_SCHEMA") + ".USERS where USERID=" + Database.prepParam(userID));
    }

    public boolean canDelete() {
        return this.getUserID() >= 0L;
    }

    public boolean checkPasswd(String passwd) throws TTException {
        return this.iPasswdHashed == null || passwd == null ? false : this.iPasswdHashed.equals(Sha.getCode(passwd));
    }

    public String toString() {
        return "User{login=" + this.getLogin() + ",name=" + this.getName() + "}";
    }

    public static long count() throws SQLException, TTException {
        return Database.executeLong("select count(*) from " + Config.get("SQL_SCHEMA") + ".USERS");
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof User)) {
            return false;
        }
        return this.getUserID() == ((User)o).getUserID();
    }

    public String getCurrentRole() throws TTException, SQLException {
        if (this.iCurrentRole == null) {
            if (this.getRoles().isEmpty()) {
                this.setCurrentRole(Constants.DEPARTMENT_ROLE);
            } else {
                this.setCurrentRole((String)this.getRoles().firstElement());
            }
        }
        return this.iCurrentRole;
    }

    public void setCurrentRole(String currentRole) {
        this.iCurrentRole = currentRole;
    }

    public Vector getRoles() throws TTException, SQLException {
        if (this.iRoles == null) {
            this.iRoles = new Vector();
            Statement s = Database.execute("select ROLE from " + Config.get("SQL_SCHEMA") + ".USER_ROLES where puid=" + Database.prepParam(this.iUserID));
            while (s.getResultSet().next()) {
                this.iRoles.add(s.getResultSet().getString("ROLE"));
            }
            s.close();
        }
        return this.iRoles;
    }

    public boolean isTimeVertical() {
        return this.iTimeVertical;
    }

    public void setTimeVertical(boolean timeVertical) {
        this.iTimeVertical = timeVertical;
    }
}

