/*
 * Decompiled with CFR 0.152.
 */
package edu.purdue.smas.timetable.data;

import edu.purdue.smas.timetable.data.TimetableConfig;
import edu.purdue.smas.timetable.util.Config;
import edu.purdue.smas.timetable.util.Database;
import edu.purdue.smas.timetable.util.Debug;
import edu.purdue.smas.timetable.util.TTException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

public class TimetableVersion {
    private long iVersion = -1L;
    private long iParentVersion;
    private java.sql.Date iCreated;
    private boolean iEditable;
    private String iNote;
    private String iStatus;
    private boolean iParentIsDirty;
    private boolean iDirtyCalled = false;
    public static String STATUS_INPUT = "INPUT";
    public static String STATUS_DELETED = "DELETED";
    public static String STATUS_TIMETABLE = "TIMETABLE";
    static /* synthetic */ Class class$edu$purdue$smas$timetable$data$TimetableVersion;

    public boolean isRoot() {
        return this.iVersion == this.iParentVersion;
    }

    public boolean haveParent() {
        return this.iVersion != this.iParentVersion;
    }

    public long getVersion() {
        return this.iVersion;
    }

    public long getParentVersion() {
        return this.iParentVersion;
    }

    public java.sql.Date getCreated() {
        return this.iCreated;
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public String getNote() {
        return this.iNote;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public void setStatus(String status) {
        this.iStatus = status;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isParentDirty() {
        return this.iParentIsDirty;
    }

    private void setParentDirty(boolean dirty) {
        this.iParentIsDirty = dirty;
    }

    private static TimetableVersion load(ResultSet rs) throws SQLException, TTException {
        TimetableVersion v = new TimetableVersion();
        v.iVersion = rs.getLong("VERSION");
        v.iParentVersion = rs.getLong("PARENT_VERSION");
        v.iCreated = rs.getDate("CREATED");
        v.iEditable = rs.getInt("EDITABLE") != 0;
        v.iNote = rs.getString("NOTE");
        v.iStatus = rs.getString("STATUS");
        v.iParentIsDirty = rs.getInt("DIRTY_PARENT") != 0;
        return v;
    }

    public static TimetableVersion load(long version) throws SQLException, TTException {
        TimetableVersion v = null;
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION where VERSION=" + Database.prepParam(version));
        if (s.getResultSet().next()) {
            v = TimetableVersion.load(s.getResultSet());
        }
        s.close();
        return v;
    }

    public static Vector loadAll() throws SQLException, TTException {
        Statement s = Database.execute("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION where STATUS<>'DELETED' order by VERSION");
        Vector<TimetableVersion> ret = new Vector<TimetableVersion>();
        while (s.getResultSet().next()) {
            ret.addElement(TimetableVersion.load(s.getResultSet()));
        }
        s.close();
        return ret;
    }

    public void save() throws SQLException, TTException {
        if (this.iVersion < 0L) {
            throw new TTException(this, "Invalid timetable version");
        }
        Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION set " + "NOTE=" + Database.prepParam(this.getNote()) + ", " + "STATUS=" + Database.prepParam(this.getStatus()) + ", " + "EDITABLE=" + (this.isEditable() ? 1 : 0) + ", " + "DIRTY_PARENT=" + (this.isParentDirty() ? 1 : 0) + " where VERSION=" + this.iVersion);
    }

    public static void dirty(long version) throws SQLException, TTException {
        Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION set " + "DIRTY_PARENT=1 where PARENT_VERSION=" + version);
    }

    public void dirty() throws SQLException, TTException {
        if (this.iDirtyCalled) {
            return;
        }
        Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION set " + "DIRTY_PARENT=1 where PARENT_VERSION=" + this.getVersion());
        this.iDirtyCalled = true;
    }

    public static void setCurrentVersion(long version) throws SQLException, TTException {
        TimetableVersion v = TimetableVersion.load(version);
        if (v == null) {
            throw new TTException(class$edu$purdue$smas$timetable$data$TimetableVersion == null ? (class$edu$purdue$smas$timetable$data$TimetableVersion = TimetableVersion.class$("edu.purdue.smas.timetable.data.TimetableVersion")) : class$edu$purdue$smas$timetable$data$TimetableVersion, "Unable to change current version -- version " + version + " not exists.");
        }
        if (v.getStatus().equals(STATUS_DELETED)) {
            throw new TTException(class$edu$purdue$smas$timetable$data$TimetableVersion == null ? (class$edu$purdue$smas$timetable$data$TimetableVersion = TimetableVersion.class$("edu.purdue.smas.timetable.data.TimetableVersion")) : class$edu$purdue$smas$timetable$data$TimetableVersion, "Unable to change current version -- version " + version + " already deleted.");
        }
        TimetableConfig.set("VERSION", String.valueOf(version));
    }

    public static TimetableVersion getCurrentVersion() throws SQLException, TTException {
        return TimetableVersion.load(TimetableConfig.getLong("VERSION"));
    }

    public static long getCurrentVersionNumber() throws TTException {
        return TimetableConfig.getLong("VERSION");
    }

    public static TimetableVersion createNewVersion(TimetableVersion previous, String note) throws SQLException, TTException {
        return TimetableVersion.createNewVersion(previous, note, true);
    }

    public static TimetableVersion createNewVersion(TimetableVersion previous, String note, boolean copyStudents) throws SQLException, TTException {
        previous.iDirtyCalled = false;
        if (previous.getStatus().equals(STATUS_DELETED)) {
            throw new TTException(class$edu$purdue$smas$timetable$data$TimetableVersion == null ? (class$edu$purdue$smas$timetable$data$TimetableVersion = TimetableVersion.class$("edu.purdue.smas.timetable.data.TimetableVersion")) : class$edu$purdue$smas$timetable$data$TimetableVersion, "Unable to create a new version from version " + previous.getVersion() + " -- version already deleted.");
        }
        TimetableVersion version = new TimetableVersion();
        version.iVersion = Database.executeLong("select " + Config.get("SQL_SCHEMA") + ".SEQ_TIMETABLE_VERSION.nextval from DUAL");
        Debug.log("Creating new version " + version.getVersion() + " from version " + previous.getVersion() + " ...");
        version.iParentVersion = previous.getVersion();
        version.iCreated = new java.sql.Date(new Date().getTime());
        version.setStatus(STATUS_INPUT);
        version.setNote(note);
        version.setEditable(true);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION (version, parent_version, created, editable, note, status, dirty_parent) values (" + Database.prepParam(version.getVersion()) + ", " + Database.prepParam(version.getParentVersion()) + ", " + Database.prepParam(version.getCreated()) + ", " + Database.prepParam(version.isEditable() ? 1L : 0L) + ", " + Database.prepParam(version.getNote()) + ", " + Database.prepParam(version.getStatus()) + ", 0" + ")");
        previous.setEditable(false);
        previous.save();
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE_DEF select FEATURE_ID, NAME, " + version.iVersion + " as VERSION, ABBV from " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE_DEF where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".ROOM_DEPT select ROOM_ID , DEPT_CODE, PERCENT_SHARE, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".ROOM_DEPT where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".BUILDING select BLDG_ID, ABBV, NAME, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".BUILDING where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".ROOM select ROOM_ID, BLDG_ID, ROOM_NO, CAPACITY, ROOM_ORD, " + version.iVersion + " as VERSION, X_COORDINATE, Y_COORDINATE from " + Config.get("SQL_SCHEMA") + ".ROOM where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE select ROOM_ID, FEATURE_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR select INSTR_UID, FIRST_NAME, MIDDLE_NAME, LAST_NAME, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR_DEPT select INSTR_UID, DEPT_CODE, FTE, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR_DEPT where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS select CLASS_ID, SUBJECT, COURSE_NBR, ITYPE, SECTION, TIME_PATTERN_ID, EXPECTED_CAPACITY, INSTR_UID, OWNER_UID, START_DATE, END_DATE, " + version.iVersion + " as VERSION, NONSTANDARD_REQ, OWNER_ROLE from " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ select CLASS_ID, BLDG_ID, PREF_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ select CLASS_ID, FEATURE_ID, PREF_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ select CLASS_ID, ROOM_ID, PREF_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ select REQ_ID, CLASS_ID, DAYS, START_TIME, END_TIME, PREF_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN select PATTERN_ID, CLASS_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ select GROUP_ID, REQ_ID, PREF_ID, " + version.iVersion + " as VERSION, OWNER_ROLE from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP select GROUP_ID, SUBJECT, COURSE_NBR, ITYPE, SECTION, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP where VERSION=" + version.iParentVersion);
        if (copyStudents) {
            Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT select STUDENT_ID, SUBJECT, COURSE_NBR, ITYPE, SECTION, SEQ_NBR, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT where VERSION=" + version.iParentVersion);
        }
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS select " + version.iVersion + " as VERSION, KEY, VALUE from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO select " + version.iVersion + " as VERSION, KEY, VALUE from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".SAME_CLASS select CLASS_ID, SUBJECT, COURSE_NBR, ITYPE, SECTION, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where VERSION=" + version.iParentVersion);
        Database.executeNoOutput("insert into " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF select DEPT_CODE, BLDG_ID, PREF_ID, " + version.iVersion + " as VERSION from " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where VERSION=" + version.iParentVersion);
        Debug.log("Version created.");
        return version;
    }

    public static void deleteVersion(TimetableVersion version) throws SQLException, TTException {
        Debug.log("Deleting version " + version.getVersion() + " ...");
        if (version.getVersion() == TimetableVersion.getCurrentVersionNumber()) {
            throw new TTException(class$edu$purdue$smas$timetable$data$TimetableVersion == null ? (class$edu$purdue$smas$timetable$data$TimetableVersion = TimetableVersion.class$("edu.purdue.smas.timetable.data.TimetableVersion")) : class$edu$purdue$smas$timetable$data$TimetableVersion, "Unable to delete current version -- change current version first.");
        }
        if (version.getStatus().equals(STATUS_DELETED)) {
            throw new TTException(class$edu$purdue$smas$timetable$data$TimetableVersion == null ? (class$edu$purdue$smas$timetable$data$TimetableVersion = TimetableVersion.class$("edu.purdue.smas.timetable.data.TimetableVersion")) : class$edu$purdue$smas$timetable$data$TimetableVersion, "Unable to delete version " + version.getVersion() + " -- version already deleted.");
        }
        version.setEditable(false);
        version.setStatus(STATUS_DELETED);
        version.save();
        if (version.isRoot()) {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION set PARENT_VERSION=VERSION, dirty_parent=1 where PARENT_VERSION=" + version.getVersion());
        } else {
            Database.executeNoOutput("update " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION set PARENT_VERSION=" + version.getParentVersion() + ", dirty_parent=1 where PARENT_VERSION=" + version.getVersion());
        }
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".DEPT_BLDG_PREF where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".STUDENT_ENROLLMENT where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_GROUP where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_DISTRIBUTION_REQ where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".PROHIBITED_TIME_PATTERN where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_BUILDING_REQ where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_FEATURE_REQ where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_ROOM_REQ where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS_TIME_REQ where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".SAME_CLASS where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".CLASS where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".INSTRUCTOR_DEPT where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".ROOM where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".ROOM_DEPT where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".BUILDING where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".ROOM_FEATURE_DEF where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIMETABLE where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIMETABLE_INFO where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIMETABLE_GLOBAL_INFO where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIMETABLE_SOLVER_PARAMS where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIME_ADVICE where VERSION=" + version.getVersion());
        Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".ROOM_ADVICE where VERSION=" + version.getVersion());
        Debug.log("Version deleted.");
    }

    private static void deleteDeletedLeaves() throws SQLException, TTException {
        while (Database.executeLong("select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION v where v.STATUS='DELETED' and not exists (select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION w where w.PARENT_VERSION=v.VERSION)") > 0L) {
            Database.executeNoOutput("delete " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION d where d.VERSION in (" + "select VERSION from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION v where v.STATUS='DELETED' " + "and not exists (select * from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION w where w.PARENT_VERSION=v.VERSION))");
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimetableVersion)) {
            return false;
        }
        return ((TimetableVersion)o).getVersion() == this.getVersion();
    }

    public static int countNotDirtyChildrens(long version) throws TTException, SQLException {
        return Database.executeInt("select count(*) from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION where DIRTY_PARENT=0 and PARENT_VERSION=" + version);
    }

    public static int countChildrens(long version) throws TTException, SQLException {
        return Database.executeInt("select count(*) from " + Config.get("SQL_SCHEMA") + ".TIMETABLE_VERSION where PARENT_VERSION=" + version);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

